/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class PowersetIterator<E>
implements Iterator<Set<E>> {
    private final List<E> mList;
    private final long mPowersetSize;
    private long mCurrentElement;

    public PowersetIterator(Collection<E> set) {
        this.mList = new ArrayList<E>(set);
        if (set.size() >= 64) {
            throw new IllegalArgumentException("Powerset for " + set.size() + " elements is too large.");
        }
        this.mPowersetSize = 1L << set.size();
        this.mCurrentElement = 0L;
    }

    @Override
    public boolean hasNext() {
        return this.mCurrentElement != this.mPowersetSize;
    }

    public <C extends Collection<E>> C next(C resultContainer) {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int i = 0;
        while (i < this.mList.size()) {
            if (PowersetIterator.isBitSet(this.mCurrentElement, i)) {
                resultContainer.add(this.mList.get(i));
            }
            ++i;
        }
        ++this.mCurrentElement;
        return resultContainer;
    }

    private static boolean isBitSet(long value, int bitIndex) {
        return bitIndex < 64 && (value & 1L << bitIndex) != 0L;
    }

    @Override
    public Set<E> next() {
        return this.next(new HashSet());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("modification not supported");
    }
}

