/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import de.uni_freiburg.informatik.ultimate.util.ScopeUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.IScopedMap;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ScopedHashMap<K, V>
extends AbstractMap<K, V>
implements IScopedMap<K, V> {
    private final HashMap<K, V> mMap;
    private HashMap<K, V>[] mHistory;
    private int mCurScope = -1;
    private final boolean mShrink;

    public ScopedHashMap() {
        this(true);
    }

    public ScopedHashMap(ScopedHashMap<K, V> original) {
        this.mMap = new HashMap<K, V>(original.mMap);
        this.mHistory = new HashMap[original.mHistory.length];
        int i = 0;
        while (i < this.mHistory.length) {
            HashMap<K, V> origEntry = original.mHistory[i];
            this.mHistory[i] = origEntry == null ? null : new HashMap<K, V>(origEntry);
            ++i;
        }
        this.mShrink = original.mShrink;
        this.mCurScope = original.mCurScope;
    }

    public ScopedHashMap(boolean shrink) {
        this.mMap = new HashMap();
        this.mHistory = new HashMap[5];
        this.mShrink = shrink;
    }

    HashMap<K, V> getMap() {
        return this.mMap;
    }

    public HashMap<K, V> undoMap() {
        return this.mHistory[this.mCurScope];
    }

    void recordUndo(K key, V value) {
        HashMap<K, V> old;
        if (this.mCurScope != -1 && !(old = this.undoMap()).containsKey(key)) {
            old.put(key, value);
        }
    }

    void undoEntry(Map.Entry<K, V> old) {
        if (old.getValue() == null) {
            this.mMap.remove(old.getKey());
        } else {
            this.mMap.put(old.getKey(), old.getValue());
        }
    }

    @Override
    public void beginScope() {
        if (this.mCurScope == this.mHistory.length - 1) {
            this.mHistory = ScopeUtils.grow(this.mHistory);
        }
        this.mHistory[++this.mCurScope] = new HashMap();
    }

    @Override
    public void endScope() {
        for (Map.Entry<K, V> old : this.undoMap().entrySet()) {
            this.undoEntry(old);
        }
        this.mHistory[this.mCurScope--] = null;
        if (this.mShrink && ScopeUtils.shouldShrink(this.mHistory)) {
            this.mHistory = ScopeUtils.shrink(this.mHistory);
        }
    }

    public Iterable<Map.Entry<K, V>> currentScopeEntries() {
        if (this.mCurScope == -1) {
            return this.entrySet();
        }
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<K, V>> mBacking;
                    private Map.Entry<K, V> mLast;
                    {
                        this.mBacking = ScopedHashMap.this.undoMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.mLast = this.mBacking.next();
                        final Object key = this.mLast.getKey();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return key;
                            }

                            @Override
                            public V getValue() {
                                return ScopedHashMap.this.getMap().get(key);
                            }

                            @Override
                            public V setValue(V value) {
                                return ScopedHashMap.this.getMap().put(key, value);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        ScopedHashMap.this.undoEntry(this.mLast);
                    }
                };
            }

            @Override
            public int size() {
                return ScopedHashMap.this.undoMap().size();
            }
        };
    }

    @Override
    public Iterable<K> currentScopeKeys() {
        if (this.mCurScope == -1) {
            return this.keySet();
        }
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    private final Iterator<Map.Entry<K, V>> mBacking;
                    private Map.Entry<K, V> mLast;
                    {
                        this.mBacking = ScopedHashMap.this.undoMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public K next() {
                        this.mLast = this.mBacking.next();
                        return this.mLast.getKey();
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        ScopedHashMap.this.undoEntry(this.mLast);
                    }
                };
            }

            @Override
            public int size() {
                return ScopedHashMap.this.undoMap().size();
            }
        };
    }

    public Iterable<V> currentScopeValues() {
        if (this.mCurScope == -1) {
            return this.values();
        }
        return new AbstractSet<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private final Iterator<Map.Entry<K, V>> mBacking;
                    private Map.Entry<K, V> mLast;
                    {
                        this.mBacking = ScopedHashMap.this.undoMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public V next() {
                        this.mLast = this.mBacking.next();
                        return ScopedHashMap.this.getMap().get(this.mLast.getKey());
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        ScopedHashMap.this.undoEntry(this.mLast);
                    }
                };
            }

            @Override
            public int size() {
                return ScopedHashMap.this.undoMap().size();
            }
        };
    }

    @Override
    public void clear() {
        this.mMap.clear();
        this.mHistory = new HashMap[5];
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.mMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    @Override
    public boolean isEmptyScope() {
        return this.mCurScope == -1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<K, V>> mBacking;
                    private Map.Entry<K, V> mLast;
                    {
                        this.mBacking = ScopedHashMap.this.getMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.mLast = this.mBacking.next();
                        return this.mLast;
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        ScopedHashMap.this.recordUndo(this.mLast.getKey(), this.mLast.getValue());
                    }
                };
            }

            @Override
            public int size() {
                return ScopedHashMap.this.getMap().size();
            }
        };
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        V oldval = this.mMap.put(key, value);
        this.recordUndo(key, oldval);
        return oldval;
    }

    @Override
    public V remove(Object key) {
        V oldval = this.mMap.remove(key);
        this.recordUndo(key, oldval);
        return oldval;
    }

    @Override
    public int size() {
        return this.mMap.size();
    }

    public int getActiveScopeNum() {
        return this.mCurScope + 1;
    }

    public boolean overwritesKeyInScope(Object key, int scope) {
        assert (scope != 0);
        return this.mHistory[scope - 1].containsKey(key);
    }
}

