/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SparseMapBuilder<K, V> {
    private static final String MAP_CANNOT_BE_MODIFIED_AFTER_THE_RESULT_WAS_RETURNED = "Map cannot be modified after the result was returned.";
    private boolean mConstructionFinished;
    private Map<K, V> mMap = Collections.emptyMap();

    public V put(K key, V value) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException(MAP_CANNOT_BE_MODIFIED_AFTER_THE_RESULT_WAS_RETURNED);
        }
        if (this.mMap.isEmpty()) {
            this.mMap = Collections.singletonMap(key, value);
            return null;
        }
        if (this.mMap.size() == 1) {
            HashMap<K, V> newMap = new HashMap<K, V>();
            newMap.putAll(this.mMap);
            this.mMap = newMap;
        }
        return this.mMap.put(key, value);
    }

    public Map<K, V> getBuiltMap() {
        this.mConstructionFinished = true;
        return this.mMap;
    }

    public void clear() {
        if (this.mConstructionFinished) {
            throw new IllegalStateException(MAP_CANNOT_BE_MODIFIED_AFTER_THE_RESULT_WAS_RETURNED);
        }
        this.mMap = Collections.emptyMap();
    }

    public boolean containsKey(Object key) {
        return this.mMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.mMap.containsValue(value);
    }

    public V get(Object key) {
        return this.mMap.get(key);
    }

    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    public V remove(Object key) {
        V result;
        if (this.mConstructionFinished) {
            throw new IllegalStateException(MAP_CANNOT_BE_MODIFIED_AFTER_THE_RESULT_WAS_RETURNED);
        }
        if (this.mMap.containsKey(key)) {
            if (this.mMap.size() == 2) {
                result = this.mMap.remove(key);
                Map.Entry<K, V> remainingEntry = this.mMap.entrySet().iterator().next();
                this.mMap = Collections.singletonMap(remainingEntry.getKey(), remainingEntry.getValue());
            } else if (this.mMap.size() == 1) {
                result = this.mMap.remove(key);
                this.mMap = Collections.emptyMap();
            } else {
                result = this.mMap.remove(key);
            }
        } else {
            result = null;
        }
        return result;
    }

    public int size() {
        return this.mMap.size();
    }
}

