/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.SortedSet;
import java.util.TreeSet;

public class TreePriorityQueue<E>
implements Queue<E> {
    private final TreeSet<E> mQueue;

    public TreePriorityQueue() {
        this.mQueue = new TreeSet();
    }

    public TreePriorityQueue(Comparator<E> comp) {
        this.mQueue = new TreeSet<E>(comp);
    }

    public TreePriorityQueue(Collection<E> col) {
        this.mQueue = new TreeSet<E>(col);
    }

    public TreePriorityQueue(SortedSet<E> s) {
        this.mQueue = new TreeSet<E>(s);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.mQueue.addAll(c);
    }

    @Override
    public void clear() {
        this.mQueue.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.mQueue.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.mQueue.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.mQueue.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.mQueue.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.mQueue.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.mQueue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.mQueue.retainAll(c);
    }

    @Override
    public int size() {
        return this.mQueue.size();
    }

    @Override
    public Object[] toArray() {
        return this.mQueue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.mQueue.toArray(a);
    }

    @Override
    public boolean add(E arg0) {
        return this.mQueue.add(arg0);
    }

    @Override
    public E element() {
        return this.mQueue.first();
    }

    @Override
    public boolean offer(E e) {
        return this.mQueue.add(e);
    }

    @Override
    public E peek() {
        if (this.mQueue.isEmpty()) {
            return null;
        }
        return this.mQueue.first();
    }

    @Override
    public E poll() {
        return this.mQueue.pollFirst();
    }

    @Override
    public E remove() {
        if (this.mQueue.isEmpty()) {
            throw new NoSuchElementException("The Queue is Empty");
        }
        return this.mQueue.pollFirst();
    }
}

