/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class UnifyHash<E>
extends AbstractCollection<E> {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient ReferenceQueue<E> mQueue = new ReferenceQueue();
    private transient Bucket<E>[] mBuckets;
    transient int mModCount = 0;
    int mSize = 0;
    int mThreshold;
    float mLoadFactor;

    public UnifyHash(int initialCapacity, float loadFactor) {
        this.mLoadFactor = loadFactor;
        this.mBuckets = new Bucket[initialCapacity];
        this.mThreshold = (int)(loadFactor * (float)initialCapacity);
    }

    public UnifyHash(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public UnifyHash() {
        this(11, 0.75f);
    }

    private void grow() {
        Bucket<E>[] oldBuckets = this.mBuckets;
        int newCap = this.mBuckets.length * 2 + 1;
        this.mThreshold = (int)(this.mLoadFactor * (float)newCap);
        this.mBuckets = new Bucket[newCap];
        int i = 0;
        while (i < oldBuckets.length) {
            Bucket<E> b = oldBuckets[i];
            while (b != null) {
                if (i != Math.abs(b.mHash % oldBuckets.length)) {
                    throw new RuntimeException(String.valueOf(i) + ", hash: " + b.mHash + ", oldlength: " + oldBuckets.length);
                }
                int newSlot = Math.abs(b.mHash % newCap);
                Bucket nextBucket = b.mNext;
                b.mNext = this.mBuckets[newSlot];
                this.mBuckets[newSlot] = b;
                b = nextBucket;
            }
            ++i;
        }
    }

    public final void cleanUp() {
        Bucket died;
        while ((died = (Bucket)this.mQueue.poll()) != null) {
            int diedSlot = Math.abs(died.mHash % this.mBuckets.length);
            if (this.mBuckets[diedSlot] == died) {
                this.mBuckets[diedSlot] = died.mNext;
            } else {
                Bucket<E> b = this.mBuckets[diedSlot];
                while (b.mNext != died) {
                    b = b.mNext;
                }
                b.mNext = died.mNext;
            }
            --this.mSize;
        }
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public Iterator<E> iterator() {
        this.cleanUp();
        return new Iterator<E>(){
            private int mBucket = 0;
            private final int mKnown;
            private Bucket<E> mNextBucket;
            private E mNextVal;
            {
                this.mKnown = UnifyHash.this.mModCount;
                this.internalNext();
            }

            private void internalNext() {
                while (true) {
                    if (this.mNextBucket == null) {
                        if (this.mBucket == UnifyHash.this.mBuckets.length) {
                            return;
                        }
                        this.mNextBucket = UnifyHash.this.mBuckets[this.mBucket++];
                        continue;
                    }
                    this.mNextVal = this.mNextBucket.get();
                    if (this.mNextVal != null) {
                        return;
                    }
                    this.mNextBucket = this.mNextBucket.mNext;
                }
            }

            @Override
            public boolean hasNext() {
                return this.mNextBucket != null;
            }

            @Override
            public E next() {
                if (this.mKnown != UnifyHash.this.mModCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.mNextBucket == null) {
                    throw new NoSuchElementException();
                }
                Object result = this.mNextVal;
                this.mNextBucket = this.mNextBucket.mNext;
                this.internalNext();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterable<E> iterateHashCode(final int hash) {
        this.cleanUp();
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(){
                    private int mKnown;
                    private boolean mRemoveOk;
                    private Bucket<E> mRemoveBucket;
                    private Bucket<E> mPrevBucket;
                    private Bucket<E> mNextBucket;
                    private E mNextVal;
                    {
                        this.mKnown = (this).UnifyHash.this.mModCount;
                        this.mRemoveOk = false;
                        this.mRemoveBucket = null;
                        this.mPrevBucket = null;
                        this.mNextBucket = (this).UnifyHash.this.mBuckets[Math.abs(n % (this).UnifyHash.this.mBuckets.length)];
                        this.internalNext();
                    }

                    private void internalNext() {
                        while (this.mNextBucket != null) {
                            if (this.mNextBucket.mHash == hash) {
                                this.mNextVal = this.mNextBucket.get();
                                if (this.mNextVal != null) {
                                    return;
                                }
                            }
                            this.mPrevBucket = this.mNextBucket;
                            this.mNextBucket = this.mNextBucket.mNext;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mNextBucket != null;
                    }

                    @Override
                    public E next() {
                        if (this.mKnown != (this).UnifyHash.this.mModCount) {
                            throw new ConcurrentModificationException();
                        }
                        if (this.mNextBucket == null) {
                            throw new NoSuchElementException();
                        }
                        Object result = this.mNextVal;
                        this.mRemoveBucket = this.mPrevBucket;
                        this.mRemoveOk = true;
                        this.mPrevBucket = this.mNextBucket;
                        this.mNextBucket = this.mNextBucket.mNext;
                        this.internalNext();
                        return result;
                    }

                    @Override
                    public void remove() {
                        if (this.mKnown != (this).UnifyHash.this.mModCount) {
                            throw new ConcurrentModificationException();
                        }
                        if (!this.mRemoveOk) {
                            throw new IllegalStateException();
                        }
                        if (this.mRemoveBucket == null) {
                            (this).UnifyHash.this.mBuckets[Math.abs((int)(hash % (this).UnifyHash.this.mBuckets.length))] = (this).UnifyHash.this.mBuckets[Math.abs((int)(hash % (this).UnifyHash.this.mBuckets.length))].mNext;
                        } else {
                            this.mRemoveBucket.mNext = this.mRemoveBucket.mNext.mNext;
                        }
                        this.mKnown = ++(this).UnifyHash.this.mModCount;
                        --(this).UnifyHash.this.mSize;
                    }
                };
            }
        };
    }

    public void put(int hash, E o) {
        if (this.mSize++ > this.mThreshold) {
            this.grow();
        }
        ++this.mModCount;
        int slot = Math.abs(hash % this.mBuckets.length);
        Bucket<E> b = new Bucket<E>(o, this.mQueue);
        b.mHash = hash;
        b.mNext = this.mBuckets[slot];
        this.mBuckets[slot] = b;
    }

    public boolean remove(int hash, E o) {
        Iterator<E> i = this.iterateHashCode(hash).iterator();
        while (i.hasNext()) {
            if (i.next() != o) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public E unify(E o, int hash, Comparator<E> comparator) {
        this.cleanUp();
        int slot = Math.abs(hash % this.mBuckets.length);
        Bucket<E> b = this.mBuckets[slot];
        while (b != null) {
            Object old;
            if (b.mHash == hash && (old = b.get()) != null && comparator.compare(o, old) == 0) {
                return (E)old;
            }
            b = b.mNext;
        }
        this.put(hash, o);
        return o;
    }

    public E unify(E o) {
        this.cleanUp();
        int hash = o.hashCode();
        int slot = Math.abs(hash % this.mBuckets.length);
        Bucket<E> b = this.mBuckets[slot];
        while (b != null) {
            Object old;
            if (b.mHash == hash && (old = b.get()) != null && o.equals(old)) {
                return (E)old;
            }
            b = b.mNext;
        }
        this.put(hash, o);
        return o;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeInt(this.mBuckets.length);
        Bucket<E>[] bucketArray = this.mBuckets;
        int n = this.mBuckets.length;
        int n2 = 0;
        while (n2 < n) {
            Bucket<E> b = bucketArray[n2];
            while (b != null) {
                Object elem = b.get();
                if (elem != null) {
                    oos.writeInt(b.mHash);
                    oos.writeObject(elem);
                }
                b = b.mNext;
            }
            ++n2;
        }
        oos.writeInt(0);
        oos.writeObject(null);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.mQueue = new ReferenceQueue();
        this.mModCount = 0;
        ois.defaultReadObject();
        int bucketsize = ois.readInt();
        this.mBuckets = new Bucket[bucketsize];
        while (true) {
            int hash = ois.readInt();
            Object obj = ois.readObject();
            if (obj == null) break;
            this.put(hash, obj);
        }
    }

    static class Bucket<E>
    extends WeakReference<E> {
        int mHash;
        Bucket<E> mNext;

        public Bucket(E o, ReferenceQueue<E> q) {
            super(o, q);
        }
    }
}

