/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.IPartition;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class UnionFind<E>
implements IPartition<E>,
Cloneable {
    private final Comparator<E> mElementComparator;
    private final Map<E, ImmutableSet<E>> mEquivalenceClass = new HashMap<E, ImmutableSet<E>>();
    private final Map<ImmutableSet<E>, E> mRepresentative = new HashMap<ImmutableSet<E>, E>();

    public UnionFind() {
        this.mElementComparator = null;
    }

    public UnionFind(Comparator<E> elementComparator) {
        assert (elementComparator != null) : "use other constructor in this case!";
        this.mElementComparator = elementComparator;
    }

    protected UnionFind(UnionFind<E> unionFind) {
        for (Map.Entry<ImmutableSet<E>, E> entry : unionFind.mRepresentative.entrySet()) {
            E representative = entry.getValue();
            ImmutableSet<E> equivalenceClass = entry.getKey();
            for (E equivalenceClassMember : equivalenceClass) {
                Set oldValue = this.mEquivalenceClass.put(equivalenceClassMember, equivalenceClass);
                assert (oldValue == null) : "element was contained twice";
            }
            this.mRepresentative.put(equivalenceClass, representative);
        }
        this.mElementComparator = unionFind.mElementComparator;
        assert (this.representativesAreMinimal());
    }

    public void addEquivalenceClass(ImmutableSet<E> newBlock) {
        if (this.mElementComparator == null) {
            this.addEquivalenceClass(newBlock, null);
        } else {
            this.addEquivalenceClass(newBlock, this.findMinimalElement(newBlock));
        }
        assert (this.representativesAreMinimal());
    }

    public void addEquivalenceClass(ImmutableSet<E> newBlock, E newBlockRep) {
        E rep;
        assert (DataStructureUtils.haveEmptyIntersection(newBlock, this.getAllElements()));
        assert (!newBlock.isEmpty());
        assert (newBlockRep == null || newBlock.contains(newBlockRep));
        assert (this.mElementComparator == null || newBlockRep != null) : "if we don't give a representative for the new blockhere, this method might violate the invariant that the representative is always the minimal element.";
        assert (this.mElementComparator == null || this.mElementComparator.compare(newBlockRep, this.findMinimalElement(newBlock)) <= 0);
        for (E elem : newBlock) {
            this.mEquivalenceClass.put(elem, newBlock);
        }
        E e = rep = newBlockRep == null ? newBlock.iterator().next() : newBlockRep;
        assert (this.mEquivalenceClass.get(rep) != null);
        this.mRepresentative.put(newBlock, rep);
        assert (this.representativesAreMinimal());
    }

    public UnionFind<E> clone() {
        return new UnionFind<E>(this);
    }

    public E find(E elem) {
        ImmutableSet<E> set = this.mEquivalenceClass.get(elem);
        return this.mRepresentative.get(set);
    }

    public Set<E> find(Set<E> elemSet) {
        HashSet<E> result = new HashSet<E>();
        for (E elem : elemSet) {
            E rep = this.find(elem);
            if (rep == null) continue;
            result.add(rep);
        }
        return result;
    }

    public E findAndConstructEquivalenceClassIfNeeded(E elem) {
        E findResult = this.find(elem);
        if (findResult == null) {
            this.makeEquivalenceClass(elem);
            return elem;
        }
        return findResult;
    }

    public Set<E> getAllElements() {
        return Collections.unmodifiableSet(this.mEquivalenceClass.keySet());
    }

    public Collection<Set<E>> getAllEquivalenceClasses() {
        LinkedList<Set<ImmutableSet<E>>> allEquivalenceClasses = new LinkedList<Set<ImmutableSet<E>>>();
        for (E representative : this.getAllRepresentatives()) {
            allEquivalenceClasses.add(this.getEquivalenceClassMembers(representative));
        }
        return allEquivalenceClasses;
    }

    public Collection<E> getAllRepresentatives() {
        return Collections.unmodifiableCollection(this.mRepresentative.values());
    }

    @Override
    public ImmutableSet<E> getContainingSet(E elem) {
        return this.getEquivalenceClassMembers(elem);
    }

    public Comparator<E> getElementComparator() {
        return this.mElementComparator;
    }

    public ImmutableSet<E> getEquivalenceClassMembers(E elem) {
        return this.mEquivalenceClass.get(elem);
    }

    @Override
    public Iterator<Set<E>> iterator() {
        return this.getAllEquivalenceClasses().iterator();
    }

    public void makeEquivalenceClass(E elem) {
        if (this.mEquivalenceClass.containsKey(elem)) {
            throw new IllegalArgumentException("Already contained " + elem);
        }
        ImmutableSet<E> result = ImmutableSet.singleton(elem);
        this.mEquivalenceClass.put(elem, result);
        this.mRepresentative.put(result, elem);
    }

    public void remove(E element) {
        this.remove(element, null);
    }

    public void remove(E element, E newRepChoice) {
        assert (newRepChoice == null || this.find(newRepChoice) == this.find(element));
        ImmutableSet<E> eqc = this.mEquivalenceClass.get(element);
        HashSet<E> newEqcElements = new HashSet<E>(eqc);
        newEqcElements.remove(element);
        ImmutableSet<E> newEqc = ImmutableSet.of(newEqcElements);
        if (this.find(element).equals(element)) {
            E newRep;
            if (eqc.size() == 1) {
                this.mEquivalenceClass.remove(element);
                this.mRepresentative.remove(eqc);
                assert (this.areMembersConsistent());
                return;
            }
            if (this.mElementComparator == null) {
                if (newRepChoice == null) {
                    newRep = newEqc.iterator().next();
                } else {
                    assert (newEqc.contains(newRepChoice));
                    newRep = newRepChoice;
                }
            } else {
                E minimum = this.findMinimalElement(newEqc);
                if (newRepChoice == null) {
                    newRep = minimum;
                } else {
                    if (this.mElementComparator.compare(newRepChoice, minimum) != 0) {
                        throw new IllegalArgumentException("newRepChoice must be compatible with the element comparator!");
                    }
                    newRep = newRepChoice;
                }
            }
            this.mRepresentative.put(eqc, newRep);
        }
        for (E eqcEl : newEqc) {
            this.mEquivalenceClass.put(eqcEl, newEqc);
        }
        this.mEquivalenceClass.remove(element);
        E rep = this.mRepresentative.get(eqc);
        this.mRepresentative.remove(eqc);
        assert (!rep.equals(element));
        this.mRepresentative.put(newEqc, rep);
        assert (this.areMembersConsistent());
        assert (this.representativesAreMinimal());
    }

    public void removeAll(Collection<E> elements) {
        elements.forEach(this::remove);
    }

    @Override
    public int size() {
        return this.mRepresentative.size();
    }

    public String toString() {
        return this.mRepresentative.toString();
    }

    public void transformElements(Function<E, E> elemTransformer) {
        HashMap<ImmutableSet<E>, E> representativeCopy = new HashMap<ImmutableSet<E>, E>(this.mRepresentative);
        for (Map.Entry<ImmutableSet<E>, E> entry : representativeCopy.entrySet()) {
            for (E oldElem : entry.getKey()) {
                this.mEquivalenceClass.remove(oldElem);
            }
            this.mRepresentative.remove(entry.getKey());
            E newRep = elemTransformer.apply(entry.getValue());
            ImmutableSet newEqClass = entry.getKey().stream().map(elemTransformer).collect(ImmutableSet.collector());
            for (Object newElem : newEqClass) {
                this.mEquivalenceClass.put(newElem, newEqClass);
            }
            this.mRepresentative.put(newEqClass, newRep);
        }
        assert (this.representativesAreMinimal());
    }

    public void union(Collection<E> elements) {
        Iterator<E> it = elements.iterator();
        if (!it.hasNext()) {
            return;
        }
        E firstElem = it.next();
        while (it.hasNext()) {
            this.union(firstElem, it.next());
        }
    }

    public void union(E elem1, E elem2) {
        E rep2;
        E rep1;
        ImmutableSet<E> smallerSet;
        ImmutableSet<E> set1 = this.mEquivalenceClass.get(elem1);
        ImmutableSet<E> set2 = this.mEquivalenceClass.get(elem2);
        boolean set1IsLarger = set1.size() > set2.size();
        ImmutableSet<E> largerSet = set1IsLarger ? set1 : set2;
        ImmutableSet<E> immutableSet = smallerSet = set1IsLarger ? set2 : set1;
        E newRep = this.mElementComparator != null ? (this.mElementComparator.compare(rep1 = this.mRepresentative.get(set1), rep2 = this.mRepresentative.get(set2)) > 0 ? rep2 : rep1) : this.mRepresentative.get(largerSet);
        this.mRepresentative.remove(largerSet);
        this.mRepresentative.remove(smallerSet);
        ImmutableSet<E> union = ImmutableSet.of(DataStructureUtils.union(smallerSet, largerSet));
        for (E e : union) {
            this.mEquivalenceClass.put(e, union);
        }
        this.mRepresentative.put(union, newRep);
        assert (this.representativesAreMinimal());
    }

    public static <E> Triple<UnionFind<E>, HashRelation<E, E>, HashRelation<E, E>> intersectPartitionBlocks(UnionFind<E> uf1, UnionFind<E> uf2) {
        assert (uf1.mElementComparator == uf2.mElementComparator);
        UnionFind result = new UnionFind(uf1.mElementComparator);
        HashRelation<E, E> uf1SplitInfo = new HashRelation<E, E>();
        HashRelation<Object, E> uf2SplitInfo = new HashRelation<Object, E>();
        for (Set<E> uf1Block : uf1.getAllEquivalenceClasses()) {
            E uf1Rep = uf1.find(uf1Block.iterator().next());
            HashRelation<Object, E> uf2RepToIntersection = new HashRelation<Object, E>();
            for (E uf1El : uf1Block) {
                E uf2Rep = uf2.find(uf1El);
                uf2RepToIntersection.addPair(uf2Rep, uf1El);
            }
            for (Object uf2Rep : uf2RepToIntersection.getDomain()) {
                Set intersection = uf2RepToIntersection.getImage(uf2Rep);
                result.addEquivalenceClass(ImmutableSet.of(intersection));
                E subBlockRep = result.find(intersection.iterator().next());
                uf1SplitInfo.addPair(uf1Rep, subBlockRep);
                uf2SplitInfo.addPair(uf2Rep, subBlockRep);
            }
        }
        assert (result.representativesAreMinimal());
        assert (UnionFind.sanityCheckIntersectPartitionBlocks(uf1, uf2, result, uf1SplitInfo, uf2SplitInfo));
        return new Triple<UnionFind<E>, HashRelation<E, E>, HashRelation<E, E>>(result, uf1SplitInfo, uf2SplitInfo);
    }

    public static <E> UnionFind<E> unionPartitionBlocks(UnionFind<E> uf1, UnionFind<E> uf2) {
        assert (uf1.mElementComparator == uf2.mElementComparator);
        UnionFind<E> result = new UnionFind<E>(uf1.mElementComparator);
        HashSet<E> todo = new HashSet<E>(uf1.getAllElements());
        while (!todo.isEmpty()) {
            E tver1El = todo.iterator().next();
            E uf1Rep = uf1.find(tver1El);
            E uf2Rep = uf2.find(tver1El);
            E newBlockRep = uf1.mElementComparator == null ? uf1Rep : (uf1.mElementComparator.compare(uf1Rep, uf2Rep) < 0 ? uf1Rep : uf2Rep);
            Set<E> newBlock = DataStructureUtils.union(uf1.getEquivalenceClassMembers(tver1El), uf2.getEquivalenceClassMembers(tver1El));
            result.addEquivalenceClass(ImmutableSet.of(newBlock), newBlockRep);
            todo.removeAll(newBlock);
        }
        assert (result.representativesAreMinimal());
        return result;
    }

    private boolean areMembersConsistent() {
        for (E e : this.mRepresentative.values()) {
            if (this.mEquivalenceClass.containsKey(e)) continue;
            return false;
        }
        for (Set set : this.mEquivalenceClass.values()) {
            if (this.mRepresentative.containsKey(set)) continue;
            return false;
        }
        for (Set set : this.mRepresentative.keySet()) {
            if (this.mEquivalenceClass.values().contains(set)) continue;
            return false;
        }
        return true;
    }

    private E findMinimalElement(Set<E> newBlock) {
        assert (!newBlock.isEmpty());
        Iterator<E> newBlockIt = newBlock.iterator();
        E result = newBlockIt.next();
        while (newBlockIt.hasNext()) {
            E current = newBlockIt.next();
            E e = result = this.mElementComparator.compare(current, result) < 0 ? current : result;
        }
        return result;
    }

    private boolean representativesAreMinimal() {
        if (this.mElementComparator == null) {
            return true;
        }
        for (Map.Entry<ImmutableSet<E>, E> en : this.mRepresentative.entrySet()) {
            E rep = en.getValue();
            for (E member : en.getKey()) {
                assert (this.mElementComparator.compare(rep, member) <= 0);
            }
        }
        return true;
    }

    boolean sanityCheck() {
        assert (this.assertRepresentativeMapIsInjective());
        return true;
    }

    private static <E> boolean sanityCheckIntersectPartitionBlocks(UnionFind<E> uf1, UnionFind<E> uf2, UnionFind<E> result, HashRelation<E, E> uf1SplitInfo, HashRelation<E, E> uf2SplitInfo) {
        for (Object l : uf1SplitInfo.getDomain()) {
            if (uf1.find(l) != l) {
                assert (false);
                return false;
            }
            for (Object r : uf1SplitInfo.getImage(l)) {
                if (result.find(r) == r) continue;
                assert (false);
                return false;
            }
        }
        for (Object l : uf2SplitInfo.getDomain()) {
            if (uf2.find(l) != l) {
                assert (false);
                return false;
            }
            for (Object r : uf2SplitInfo.getImage(l)) {
                if (result.find(r) == r) continue;
                assert (false);
                return false;
            }
        }
        return true;
    }

    private boolean assertRepresentativeMapIsInjective() {
        HashSet<E> alreadySeenRepresentatives = new HashSet<E>();
        for (E rep : this.mRepresentative.values()) {
            assert (!alreadySeenRepresentatives.contains(rep));
            alreadySeenRepresentatives.add(rep);
        }
        return true;
    }
}

