/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCCElementFactory<ELEM extends ICongruenceClosureElement<ELEM>, CONTENT> {
    final Map<CONTENT, ELEM> mContentToBaseElem = new HashMap<CONTENT, ELEM>();
    final NestedMap2<ELEM, ELEM, ELEM> mFunctionToArgToFuncAppElem = new NestedMap2();

    protected abstract ELEM newBaseElement(CONTENT var1, boolean var2);

    protected abstract ELEM newFuncAppElement(ELEM var1, ELEM var2);

    public ELEM getBaseElement(CONTENT content) {
        return this.getBaseElement(content, false);
    }

    public ELEM getBaseElement(CONTENT content, boolean isLiteral) {
        ICongruenceClosureElement be = (ICongruenceClosureElement)this.mContentToBaseElem.get(content);
        if (be == null) {
            be = this.newBaseElement(content, isLiteral);
            this.mContentToBaseElem.put(content, be);
        }
        return (ELEM)be;
    }

    public ELEM getOrConstructFuncAppElement(ELEM func, ELEM argument) {
        return this.getFuncAppElement(func, argument, false);
    }

    public ELEM getFuncAppElement(ELEM func, ELEM argument, boolean forceExisting) {
        ICongruenceClosureElement fae = (ICongruenceClosureElement)this.mFunctionToArgToFuncAppElem.get(func, argument);
        if (fae == null) {
            if (forceExisting) {
                throw new IllegalStateException();
            }
            fae = this.newFuncAppElement(func, argument);
            this.mFunctionToArgToFuncAppElem.put(func, argument, fae);
        }
        return (ELEM)fae;
    }
}

