/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CcManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintConjunction;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CCLiteralSetConstraints<ELEM extends ICongruenceClosureElement<ELEM>> {
    private final CcManager<ELEM> mCcManager;
    SetConstraintManager<ELEM> mSetConstraintManager;
    private CongruenceClosure<ELEM> mCongruenceClosure;
    private Map<ELEM, SetConstraintConjunction<ELEM>> mContainsConstraints;
    private boolean mIsInconsistent;

    public CCLiteralSetConstraints(CcManager<ELEM> manager, CongruenceClosure<ELEM> congruenceClosure) {
        this.mCcManager = manager;
        this.mCongruenceClosure = congruenceClosure;
        this.mSetConstraintManager = manager.getSetConstraintManager();
        this.mContainsConstraints = new HashMap<ELEM, SetConstraintConjunction<ELEM>>();
        this.mIsInconsistent = false;
    }

    CCLiteralSetConstraints(CcManager<ELEM> manager, CongruenceClosure<ELEM> congruenceClosure, CCLiteralSetConstraints<ELEM> litSetConstraints) {
        assert (!litSetConstraints.isInconsistent());
        this.mCcManager = manager;
        this.mCongruenceClosure = congruenceClosure;
        this.mSetConstraintManager = manager.getSetConstraintManager();
        this.mContainsConstraints = new HashMap<ELEM, SetConstraintConjunction<ELEM>>();
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> en : litSetConstraints.getConstraints().entrySet()) {
            this.mContainsConstraints.put((ICongruenceClosureElement)en.getKey(), new SetConstraintConjunction<ELEM>(this, en.getValue()));
        }
        this.mIsInconsistent = false;
    }

    public HashRelation<ELEM, ELEM> reportContains(ELEM element, Set<SetConstraint<ELEM>> constraintRaw) {
        assert (this.sanityCheck());
        ELEM elementRep = this.mCongruenceClosure.getRepresentativeElement(element);
        Set<SetConstraint<ELEM>> constraintUpdRep = this.mSetConstraintManager.updateOnChangedRepresentative(constraintRaw, this.mCongruenceClosure);
        Set<SetConstraint<ELEM>> oldConstraint = this.getConstraint(element);
        this.mContainsConstraints.remove(elementRep);
        Set<SetConstraint<ELEM>> newConstraint = oldConstraint != null ? DataStructureUtils.union(oldConstraint, constraintUpdRep) : constraintUpdRep;
        HashRelation<ELEM, ELEM> equalitiesToPropagate = null;
        if (newConstraint != null) {
            equalitiesToPropagate = this.updateContainsConstraintApplyPropagations(elementRep, newConstraint);
        }
        return equalitiesToPropagate;
    }

    public HashRelation<ELEM, ELEM> reportContains(ELEM element, Collection<ELEM> elements) {
        assert (this.sanityCheck());
        if (this.isInconsistent()) {
            return null;
        }
        this.mCcManager.addElement(this.mCongruenceClosure, element, true, false);
        this.mCcManager.addAllElements(this.mCongruenceClosure, elements, null, true);
        ELEM elementRep = this.mCongruenceClosure.getRepresentativeElement(element);
        return this.reportContains(elementRep, Collections.singleton(this.mSetConstraintManager.buildSetConstraint(elements)));
    }

    private HashRelation<ELEM, ELEM> updateContainsConstraintApplyPropagations(ELEM constrainedElemRep, Set<SetConstraint<ELEM>> newConstraint) {
        assert (!this.mContainsConstraints.containsKey(constrainedElemRep)) : "assuming this has been removed before";
        assert (this.mCongruenceClosure.isRepresentative(constrainedElemRep));
        assert (this.sanityCheck());
        HashRelation<ELEM, ICongruenceClosureElement> result = new HashRelation<ELEM, ICongruenceClosureElement>();
        Set<SetConstraint<ELEM>> newConstraintFiltered = this.mSetConstraintManager.filterWithDisequalities(this.mCongruenceClosure, constrainedElemRep, newConstraint);
        if (newConstraintFiltered.stream().anyMatch(SetConstraint::isInconsistent)) {
            this.reportInconsistency();
            return result;
        }
        Set<SetConstraint<ELEM>> newConstraint1 = this.mCcManager.normalizeSetConstraintConjunction(this, newConstraintFiltered);
        for (ICongruenceClosureElement sv : this.mSetConstraintManager.getSingletonValues(newConstraint1)) {
            if (constrainedElemRep.equals(sv)) continue;
            result.addPair(constrainedElemRep, sv);
        }
        SetConstraintConjunction<ELEM> newConstraint2 = this.mCcManager.buildSetConstraintConjunction(this, constrainedElemRep, newConstraint1);
        if (!newConstraint2.isTautological()) {
            this.putContainsConstraint(constrainedElemRep, newConstraint2);
        }
        assert (this.sanityCheck());
        return result;
    }

    private void reportInconsistency() {
        this.mIsInconsistent = true;
        this.mContainsConstraints = null;
    }

    public HashRelation<ELEM, ELEM> reportEquality(ELEM elem1OldRep, ELEM elem2OldRep, ELEM newRep) {
        assert (this.mCongruenceClosure.getRepresentativeElement(elem1OldRep) == newRep);
        assert (this.mCongruenceClosure.getRepresentativeElement(elem2OldRep) == newRep);
        if (this.isInconsistent()) {
            return null;
        }
        Set<SetConstraint<ELEM>> elem1LiteralSet = this.getConstraint(elem1OldRep);
        Set<SetConstraint<ELEM>> elem2LiteralSet = this.getConstraint(elem2OldRep);
        this.mContainsConstraints.remove(elem1OldRep);
        this.mContainsConstraints.remove(elem2OldRep);
        if (elem1LiteralSet != null) {
            elem1LiteralSet = this.mSetConstraintManager.updateOnChangedRepresentative(elem1LiteralSet, elem1OldRep, elem2OldRep, newRep);
        }
        if (elem2LiteralSet != null) {
            elem2LiteralSet = this.mSetConstraintManager.updateOnChangedRepresentative(elem2LiteralSet, elem1OldRep, elem2OldRep, newRep);
        }
        Set<SetConstraint<ELEM>> newConstraint = null;
        if (elem1LiteralSet != null && elem2LiteralSet != null) {
            newConstraint = this.mSetConstraintManager.meet(this, elem1LiteralSet, elem2LiteralSet);
        } else if (elem1LiteralSet != null) {
            newConstraint = elem1LiteralSet;
        } else if (elem2LiteralSet != null) {
            newConstraint = elem2LiteralSet;
        }
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> en : new HashSet<Map.Entry<ELEM, SetConstraintConjunction<ELEM>>>(this.mContainsConstraints.entrySet())) {
            Set<SetConstraint<ELEM>> oldSc = en.getValue().getSetConstraints();
            Set<SetConstraint<ELEM>> newSc = this.mSetConstraintManager.updateOnChangedRepresentative(oldSc, elem1OldRep, elem2OldRep, newRep);
            assert (newSc == oldSc || this.mSetConstraintManager.getSingletonValues(newSc).isEmpty());
            SetConstraintConjunction<ELEM> updated = newSc == oldSc ? en.getValue() : this.mCcManager.buildSetConstraintConjunction(this, (ICongruenceClosureElement)en.getKey(), newSc);
            this.mContainsConstraints.put((ICongruenceClosureElement)en.getKey(), updated);
        }
        HashRelation<ELEM, ELEM> eqToProp = null;
        if (newConstraint != null) {
            eqToProp = this.updateContainsConstraintApplyPropagations(newRep, newConstraint);
        }
        assert (this.sanityCheck());
        return eqToProp;
    }

    public CCLiteralSetConstraints<ELEM> join(CongruenceClosure<ELEM> newCc, HashRelation<ELEM, ELEM> thisSplitInfo, HashRelation<ELEM, ELEM> otherSplitInfo, CCLiteralSetConstraints<ELEM> other) {
        if (this.isInconsistent()) {
            return other;
        }
        if (other.isInconsistent()) {
            return this;
        }
        CCLiteralSetConstraints newSetConstraints = new CCLiteralSetConstraints(this.mCcManager, newCc);
        HashMap<ICongruenceClosureElement, SetConstraintConjunction<ICongruenceClosureElement>> newContainsConstraints = new HashMap<ICongruenceClosureElement, SetConstraintConjunction<ICongruenceClosureElement>>();
        for (ICongruenceClosureElement constrainedElem : newCc.getAllRepresentatives()) {
            Set thisConstraint = this.getConstraintWrtSplit(constrainedElem, newCc, thisSplitInfo);
            Set otherConstraint = other.getConstraintWrtSplit(constrainedElem, newCc, otherSplitInfo);
            Set<SetConstraint<ELEM>> newConstraints = this.mSetConstraintManager.join(newSetConstraints, thisConstraint, otherConstraint);
            assert (this.mSetConstraintManager.getSingletonValues(newConstraints).stream().filter(sv -> !newCc.getRepresentativeElement(sv).equals(constrainedElem)).collect(Collectors.toSet()).isEmpty()) : "created non-tautological singleton set constraints --> report them, befor buildSetConstraintConj.. throws them away!";
            SetConstraintConjunction<ICongruenceClosureElement> newConstraint = this.mCcManager.buildSetConstraintConjunction(newSetConstraints, constrainedElem, newConstraints);
            if (SetConstraintManager.isTautological(newConstraint)) continue;
            newContainsConstraints.put(constrainedElem, newConstraint);
        }
        newSetConstraints.setContainsConstraints(newContainsConstraints);
        return newSetConstraints;
    }

    private void setContainsConstraints(Map<ELEM, SetConstraintConjunction<ELEM>> newContainsConstraints) {
        this.mContainsConstraints = newContainsConstraints;
    }

    public boolean isStrongerThan(CCLiteralSetConstraints<ELEM> other) {
        assert (CcManager.isPartitionStronger(this.getCongruenceClosure().mElementTVER, other.getCongruenceClosure().mElementTVER)) : "assuming this has been checked already";
        HashSet<ELEM> constrainedElements = new HashSet<ELEM>();
        constrainedElements.addAll(this.mContainsConstraints.keySet());
        constrainedElements.addAll(other.mContainsConstraints.keySet());
        HashRelation<ELEM, ELEM> splitInfo = CcManager.computeSplitInfo(this.getCongruenceClosure(), other.getCongruenceClosure());
        for (ICongruenceClosureElement elem : constrainedElements) {
            Set secondConstraint;
            Set firstConstraint = this.getConstraintWrtSplit(elem, other.getCongruenceClosure(), splitInfo);
            if (this.mSetConstraintManager.isStrongerThan(firstConstraint, secondConstraint = other.getConstraint(elem))) continue;
            return false;
        }
        return true;
    }

    public boolean isInconsistent() {
        return this.mIsInconsistent;
    }

    boolean sanityCheck() {
        if (this.mIsInconsistent) {
            return true;
        }
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> entry : this.mContainsConstraints.entrySet()) {
            if (!this.mCongruenceClosure.isRepresentative((ICongruenceClosureElement)entry.getKey())) {
                assert (false);
                return false;
            }
            if (!entry.getValue().isTautological()) continue;
            assert (false);
            return false;
        }
        for (SetConstraintConjunction setConstraintConjunction : this.mContainsConstraints.values()) {
            if (!setConstraintConjunction.sanityCheck()) {
                assert (false);
                return false;
            }
            if (setConstraintConjunction.mSurroundingCCSetConstraints == this) continue;
            assert (false);
            return false;
        }
        if (this.mCongruenceClosure.mLiteralSetConstraints != this) {
            assert (false);
            return false;
        }
        return true;
    }

    public Map<ELEM, SetConstraintConjunction<ELEM>> getConstraints() {
        return Collections.unmodifiableMap(this.mContainsConstraints);
    }

    Set<SetConstraint<ELEM>> getConstraint(ELEM elem) {
        SetConstraintConjunction<ELEM> sccEl;
        if (!this.mCongruenceClosure.hasElement(elem)) {
            return null;
        }
        HashSet<SetConstraint<ELEM>> result = new HashSet<SetConstraint<ELEM>>();
        ELEM rep = this.mCongruenceClosure.getRepresentativeElement(elem);
        result.add(this.mSetConstraintManager.buildSetConstraint(Collections.singleton(rep)));
        SetConstraintConjunction<ELEM> sccRep = this.mContainsConstraints.get(rep);
        if (sccRep != null) {
            result.addAll(sccRep.getSetConstraints());
        }
        if ((sccEl = this.mContainsConstraints.get(elem)) != null) {
            result.addAll(sccEl.getSetConstraints());
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    private Set<SetConstraint<ELEM>> getConstraintWrtSplit(ELEM constrainedElem, CongruenceClosure<ELEM> ccWithFinerPartition, HashRelation<ELEM, ELEM> splitInfo) {
        if (!this.mCongruenceClosure.hasElement(constrainedElem)) {
            return null;
        }
        Set<SetConstraint<ELEM>> oldConstraint = this.getConstraint(constrainedElem);
        if (oldConstraint == null) {
            return null;
        }
        HashSet<SetConstraint<Object>> result = new HashSet<SetConstraint<ELEM>>(oldConstraint);
        for (ICongruenceClosureElement oldRep : splitInfo.getDomain()) {
            assert (!this.mCongruenceClosure.hasElement(oldRep) || this.mCongruenceClosure.isRepresentative(oldRep));
            HashSet<SetConstraint<ICongruenceClosureElement>> newResult = new HashSet<SetConstraint<ICongruenceClosureElement>>();
            for (SetConstraint setConstraint : result) {
                for (ICongruenceClosureElement newRep : splitInfo.getImage(oldRep)) {
                    assert (ccWithFinerPartition.isRepresentative(newRep));
                    newResult.add(this.mSetConstraintManager.transformElements(setConstraint, e -> e.equals(oldRep) ? newRep : e));
                }
            }
            result = newResult;
        }
        return result;
    }

    public void setCongruenceClosure(CongruenceClosure<ELEM> congruenceClosure) {
        assert (this.mCongruenceClosure == null) : "never re-set the congruence closure!";
        this.mCongruenceClosure = congruenceClosure;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CCLiteralSetConstraints:\n");
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> en : this.getConstraints().entrySet()) {
            sb.append(en.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void projectAway(ELEM elem) {
        this.mContainsConstraints.remove(elem);
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> en : new HashSet<Map.Entry<ELEM, SetConstraintConjunction<ELEM>>>(this.mContainsConstraints.entrySet())) {
            en.getValue().projectAway(elem);
            if (!en.getValue().isTautological()) continue;
            this.mContainsConstraints.remove(en.getKey());
        }
    }

    public void replaceRepresentative(ELEM oldRep, ELEM newRep) {
        SetConstraintConjunction<ELEM> constraints = this.mContainsConstraints.remove(oldRep);
        if (constraints != null && newRep != null) {
            this.putContainsConstraint(newRep, constraints);
        }
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> en : new HashSet<Map.Entry<ELEM, SetConstraintConjunction<ELEM>>>(this.mContainsConstraints.entrySet())) {
            Set<SetConstraint<ELEM>> oldSc = en.getValue().getSetConstraints();
            Set<SetConstraint<ELEM>> newSc = this.mSetConstraintManager.updateOnChangedRepresentative(oldSc, oldRep, newRep);
            assert (this.mSetConstraintManager.getSingletonValues(newSc).isEmpty());
            SetConstraintConjunction<ELEM> updated = newSc == oldSc ? en.getValue() : this.mCcManager.buildSetConstraintConjunction(this, (ICongruenceClosureElement)en.getKey(), newSc);
            this.putContainsConstraint((ICongruenceClosureElement)en.getKey(), updated);
        }
    }

    public SetConstraintConjunction<ELEM> putContainsConstraint(ELEM newRep, SetConstraintConjunction<ELEM> constraints) {
        assert (constraints.mSurroundingCCSetConstraints == this);
        return this.mContainsConstraints.put(newRep, constraints);
    }

    public void reportDisequality(ELEM elem1, ELEM elem2) {
        Set<SetConstraint<ELEM>> elem1ConstraintFiltered;
        Set<SetConstraint<ELEM>> elem1Constraint;
        SetConstraintConjunction<ELEM> newConstraint;
        Set<SetConstraint<ELEM>> elem2ConstraintFiltered;
        ELEM elem1Rep = this.mCongruenceClosure.getRepresentativeElement(elem1);
        ELEM elem2Rep = this.mCongruenceClosure.getRepresentativeElement(elem2);
        assert (!elem1Rep.isLiteral() || !elem2Rep.isLiteral()) : "literal disequalities should be implicit and not reported";
        Set<SetConstraint<ELEM>> elem2Constraint = this.getConstraint(elem2Rep);
        if (elem2Constraint != null && (elem2ConstraintFiltered = this.mSetConstraintManager.filterWithDisequality(elem2Constraint, elem1Rep)) != elem2Constraint) {
            assert (this.mSetConstraintManager.getSingletonValues(elem2ConstraintFiltered).isEmpty());
            newConstraint = this.mCcManager.buildSetConstraintConjunction(this, elem2Rep, elem2ConstraintFiltered);
            if (newConstraint.isInconsistent()) {
                this.reportInconsistency();
            }
            this.putContainsConstraint(elem2Rep, newConstraint);
        }
        if ((elem1Constraint = this.getConstraint(elem1Rep)) != null && (elem1ConstraintFiltered = this.mSetConstraintManager.filterWithDisequality(elem1Constraint, elem2Rep)) != elem1Constraint) {
            newConstraint = this.mCcManager.buildSetConstraintConjunction(this, elem1Rep, elem1ConstraintFiltered);
            if (newConstraint.isInconsistent()) {
                this.reportInconsistency();
            }
            this.putContainsConstraint(elem1Rep, newConstraint);
        }
    }

    public CCLiteralSetConstraints<ELEM> filterAndKeepOnlyConstraintsThatIntersectWith(Set<ELEM> constraintsToKeepReps) {
        assert (!this.isInconsistent()) : "handle this case";
        CCLiteralSetConstraints<ICongruenceClosureElement> result = new CCLiteralSetConstraints<ICongruenceClosureElement>(this.mCcManager, null);
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> en : this.mContainsConstraints.entrySet()) {
            if (constraintsToKeepReps.contains(en.getKey())) {
                result.putContainsConstraint((ICongruenceClosureElement)en.getKey(), new SetConstraintConjunction<ELEM>(result, en.getValue()));
            }
            if (!DataStructureUtils.haveNonEmptyIntersection(constraintsToKeepReps, en.getValue().getAllRhsElements())) continue;
            result.putContainsConstraint((ICongruenceClosureElement)en.getKey(), new SetConstraintConjunction<ELEM>(result, en.getValue()));
        }
        assert (!result.isInconsistent());
        return result;
    }

    public void transformElements(Function<ELEM, ELEM> elemTransformer) {
        HashMap<ELEM, SetConstraintConjunction<ELEM>> copy = new HashMap<ELEM, SetConstraintConjunction<ELEM>>(this.mContainsConstraints);
        for (Map.Entry en : copy.entrySet()) {
            this.mContainsConstraints.remove(en.getKey());
            ICongruenceClosureElement keyTransformed = (ICongruenceClosureElement)elemTransformer.apply((ICongruenceClosureElement)en.getKey());
            Set<SetConstraint<ELEM>> valueTransformedSet = this.mSetConstraintManager.transformElements(((SetConstraintConjunction)en.getValue()).getSetConstraints(), elemTransformer);
            assert (this.mSetConstraintManager.getSingletonValues(valueTransformedSet).isEmpty());
            SetConstraintConjunction<ICongruenceClosureElement> valueTransformed = this.mCcManager.buildSetConstraintConjunction(this, keyTransformed, valueTransformedSet);
            this.putContainsConstraint(keyTransformed, valueTransformed);
        }
    }

    public CongruenceClosure<ELEM> getCongruenceClosure() {
        return this.mCongruenceClosure;
    }

    public HashRelation<ELEM, ELEM> getElemToExpansion() {
        HashRelation<ICongruenceClosureElement, ELEM> result = new HashRelation<ICongruenceClosureElement, ELEM>();
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> en : this.mContainsConstraints.entrySet()) {
            if (!en.getValue().hasOnlyLiterals()) continue;
            result.addAllPairs((ICongruenceClosureElement)en.getKey(), en.getValue().getLiterals());
        }
        return result;
    }

    public boolean isEmpty() {
        if (this.isInconsistent()) {
            return false;
        }
        return this.mContainsConstraints.isEmpty();
    }

    public Set<ELEM> getRelatedElements(ELEM rep) {
        assert (this.mCongruenceClosure.isRepresentative(rep));
        HashSet<ICongruenceClosureElement> result = new HashSet<ICongruenceClosureElement>();
        Set<SetConstraint<ELEM>> c = this.getConstraint(rep);
        if (c != null) {
            c.forEach(sc -> sc.getElementSet().forEach(result::add));
        }
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> en : this.getConstraints().entrySet()) {
            if (((ICongruenceClosureElement)en.getKey()).equals(rep)) {
                en.getValue().getAllRhsElements().forEach(result::add);
                continue;
            }
            if (!en.getValue().getAllRhsElements().contains(rep)) continue;
            en.getValue().getAllRhsElements().forEach(result::add);
            result.add((ICongruenceClosureElement)en.getKey());
        }
        result.remove(rep);
        return result;
    }

    public Set<SetConstraint<ELEM>> getContainsConstraint(ELEM elem) {
        return this.getConstraint(elem);
    }

    public boolean isConstrained(ELEM elem) {
        if (elem != this.mCongruenceClosure.getRepresentativeElement(elem)) {
            throw new AssertionError((Object)"this is only called when elem is unconstrained on mCongruenceClosure.mElementTVER, right?");
        }
        return this.mContainsConstraints.get(elem) != null;
    }

    public Set<ELEM> getAllElementsMentionedInASetConstraint() {
        HashSet<ELEM> result = new HashSet<ELEM>();
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> en : this.mContainsConstraints.entrySet()) {
            result.add(en.getValue().getConstrainedElement());
            result.addAll(en.getValue().getAllRhsElements());
        }
        return result;
    }
}

