/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.SymmetricHashRelation;

public class CachingSetConstraintComparator<ELEM extends ICongruenceClosureElement<ELEM>>
implements IPartialComparator<SetConstraint<ELEM>> {
    private final SetConstraintComparator<ELEM> mBaseScc;
    SymmetricHashRelation<SetConstraint<ELEM>> mIncomparableElements = new SymmetricHashRelation();
    HashRelation<SetConstraint<ELEM>, SetConstraint<ELEM>> mStrictlySmaller = new HashRelation();

    public CachingSetConstraintComparator(SetConstraintManager<ELEM> setConstraintManager) {
        this.mBaseScc = new SetConstraintComparator<ELEM>(setConstraintManager);
    }

    @Override
    public IPartialComparator.ComparisonResult compare(SetConstraint<ELEM> o1, SetConstraint<ELEM> o2) {
        if (this.mIncomparableElements.containsPair(o1, o2)) {
            return IPartialComparator.ComparisonResult.INCOMPARABLE;
        }
        if (this.mStrictlySmaller.containsPair(o1, o2)) {
            return IPartialComparator.ComparisonResult.STRICTLY_SMALLER;
        }
        if (this.mStrictlySmaller.containsPair(o2, o1)) {
            return IPartialComparator.ComparisonResult.STRICTLY_GREATER;
        }
        IPartialComparator.ComparisonResult comparisonResult = this.mBaseScc.compare(o1, o2);
        if (comparisonResult == IPartialComparator.ComparisonResult.INCOMPARABLE) {
            this.mIncomparableElements.addPair(o1, o2);
        } else if (comparisonResult == IPartialComparator.ComparisonResult.STRICTLY_GREATER) {
            this.mStrictlySmaller.addPair(o2, o1);
        } else if (comparisonResult == IPartialComparator.ComparisonResult.STRICTLY_SMALLER) {
            this.mStrictlySmaller.addPair(o1, o2);
        } else assert (false) : "setConstraints are unified, right??";
        return comparisonResult;
    }
}

