/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.util.datastructures.CrossProducts;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.AbstractRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CcAuxData<ELEM extends ICongruenceClosureElement<ELEM>> {
    private final CongruenceClosure<ELEM> mCongruenceClosure;
    private final HashRelation<ELEM, ELEM> mAfCcPars;
    private final HashRelation<ELEM, ELEM> mArgCcPars;
    private final Map<ELEM, HashRelation<ELEM, ELEM>> mCcChildren;
    private final boolean mOmitRepresentativeChecks;

    CcAuxData(CongruenceClosure<ELEM> congruenceClosure) {
        this.mCongruenceClosure = congruenceClosure;
        this.mAfCcPars = new HashRelation();
        this.mArgCcPars = new HashRelation();
        this.mCcChildren = new HashMap<ELEM, HashRelation<ELEM, ELEM>>();
        this.mOmitRepresentativeChecks = false;
    }

    public CcAuxData(CongruenceClosure<ELEM> congruenceClosure, CcAuxData<ELEM> auxData, boolean omitRepresentativeChecks) {
        this.mCongruenceClosure = congruenceClosure;
        this.mAfCcPars = new HashRelation(auxData.mAfCcPars);
        this.mArgCcPars = new HashRelation(auxData.mArgCcPars);
        this.mCcChildren = new HashMap<ELEM, HashRelation<ELEM, ELEM>>();
        for (Map.Entry<ELEM, HashRelation<ELEM, ELEM>> en : auxData.mCcChildren.entrySet()) {
            this.mCcChildren.put((ICongruenceClosureElement)en.getKey(), new HashRelation((AbstractRelation)en.getValue()));
        }
        this.mOmitRepresentativeChecks = omitRepresentativeChecks;
    }

    CcAuxData(CongruenceClosure<ELEM> congruenceClosure, CcAuxData<ELEM> auxData) {
        this(congruenceClosure, auxData, false);
    }

    Pair<HashRelation<ELEM, ELEM>, HashRelation<ELEM, ELEM>> updateAndGetPropagationsOnMerge(ELEM e1, ELEM e2, ELEM e1OldRep, ELEM e2OldRep, Set<ELEM> oldUnequalRepsForElem1, Set<ELEM> oldUnequalRepsForElem2) {
        HashRelation<ELEM, ELEM> oldCcc2;
        ICongruenceClosureElement newRep = (ICongruenceClosureElement)this.mCongruenceClosure.mElementTVER.getRepresentative(e1);
        assert (this.mCongruenceClosure.mElementTVER.getRepresentative(e2) == newRep) : "we merged before calling this method, right?";
        HashRelation congruentResult = new HashRelation();
        HashRelation unequalResult = new HashRelation();
        Set afccpar1 = this.mAfCcPars.getImage(e1OldRep);
        Set afccpar2 = this.mAfCcPars.getImage(e2OldRep);
        Set argccpar1 = this.mArgCcPars.getImage(e1OldRep);
        Set argccpar2 = this.mArgCcPars.getImage(e2OldRep);
        this.collectCcParBasedPropagations(afccpar1, afccpar2, congruentResult, unequalResult);
        this.collectCcParBasedPropagations(argccpar1, argccpar2, congruentResult, unequalResult);
        assert (this.hasOnlyPairsOfSameType(congruentResult));
        assert (this.hasOnlyPairsOfSameType(unequalResult));
        this.collectPropagationsForImplicitlyAddedDisequalities(oldUnequalRepsForElem1, e2OldRep, unequalResult);
        this.collectPropagationsForImplicitlyAddedDisequalities(oldUnequalRepsForElem2, e1OldRep, unequalResult);
        assert (this.hasOnlyPairsOfSameType(unequalResult));
        if (newRep == e1OldRep) {
            Set oldArg2;
            Set oldAf2 = this.mAfCcPars.removeDomainElement(e2OldRep);
            if (oldAf2 != null) {
                for (ICongruenceClosureElement e : oldAf2) {
                    assert (e.isFunctionApplication());
                    this.mAfCcPars.addPair(newRep, e);
                }
            }
            if ((oldArg2 = this.mArgCcPars.removeDomainElement(e2OldRep)) != null) {
                for (Object e : oldArg2) {
                    assert (e.isFunctionApplication());
                    this.mArgCcPars.addPair(newRep, e);
                }
            }
        } else {
            Set oldArg1;
            assert (newRep == e2OldRep);
            Set oldAf1 = this.mAfCcPars.removeDomainElement(e1OldRep);
            if (oldAf1 != null) {
                for (ICongruenceClosureElement e : oldAf1) {
                    assert (e.isFunctionApplication());
                    this.mAfCcPars.addPair(newRep, e);
                }
            }
            if ((oldArg1 = this.mArgCcPars.removeDomainElement(e1OldRep)) != null) {
                for (Object e : oldArg1) {
                    assert (e.isFunctionApplication());
                    this.mArgCcPars.addPair(newRep, e);
                }
            }
        }
        HashRelation newCcc = new HashRelation();
        HashRelation<ELEM, ELEM> oldCcc1 = this.mCcChildren.remove(e1OldRep);
        if (oldCcc1 != null) {
            newCcc.addAll(oldCcc1);
        }
        if ((oldCcc2 = this.mCcChildren.remove(e2OldRep)) != null) {
            newCcc.addAll(oldCcc2);
        }
        this.mCcChildren.put(newRep, newCcc);
        assert (this.hasOnlyPairsOfSameType(congruentResult));
        assert (this.hasOnlyPairsOfSameType(unequalResult));
        return new Pair<HashRelation<ELEM, ELEM>, HashRelation<ELEM, ELEM>>(congruentResult, unequalResult);
    }

    private boolean hasOnlyPairsOfSameType(HashRelation<ELEM, ELEM> relation) {
        for (Map.Entry pair : relation) {
            assert (((ICongruenceClosureElement)pair.getKey()).hasSameTypeAs((ICongruenceClosureElement)pair.getValue())) : "relation should only have pairs of same typebut does not";
        }
        return true;
    }

    private void collectCcParBasedPropagations(Set<ELEM> parents1, Set<ELEM> parents2, HashRelation<ELEM, ELEM> congruentResult, HashRelation<ELEM, ELEM> unequalResult) {
        if (parents1 == null || parents2 == null || parents1.isEmpty() || parents2.isEmpty()) {
            return;
        }
        for (List parentPair : CrossProducts.crossProductOfSets(Arrays.asList(parents1, parents2))) {
            ICongruenceClosureElement parent1 = (ICongruenceClosureElement)parentPair.get(0);
            ICongruenceClosureElement parent2 = (ICongruenceClosureElement)parentPair.get(1);
            if (this.mCongruenceClosure.hasElements(new ICongruenceClosureElement[]{parent1.getAppliedFunction(), parent1.getArgument(), parent2.getAppliedFunction(), parent2.getArgument()}) && this.mCongruenceClosure.getEqualityStatus(parent1.getAppliedFunction(), parent2.getAppliedFunction()) == EqualityStatus.EQUAL && this.mCongruenceClosure.getEqualityStatus(parent1.getArgument(), parent2.getArgument()) == EqualityStatus.EQUAL) {
                congruentResult.addPair(parent1, parent2);
                continue;
            }
            if (this.mCongruenceClosure.getEqualityStatus(parent1, parent2) != EqualityStatus.NOT_EQUAL) continue;
            this.addPropIfOneIsEqualOneIsUnconstrained(parent1.getAppliedFunction(), parent1.getArgument(), parent2.getAppliedFunction(), parent2.getArgument(), unequalResult);
        }
    }

    private void collectPropagationsForImplicitlyAddedDisequalities(Set<ELEM> oldUnequalRepsForElem1, ELEM e2OldRep, HashRelation<ELEM, ELEM> disequalitiesToPropagate) {
        for (ICongruenceClosureElement repUnequalToE1 : oldUnequalRepsForElem1) {
            HashRelation<ELEM, ELEM> unequalRep1Cccs = this.mCcChildren.get(repUnequalToE1);
            if (unequalRep1Cccs == null) continue;
            for (Map.Entry ccc2 : unequalRep1Cccs) {
                HashRelation<ELEM, ELEM> mergePartnerOldRepCccs = this.mCcChildren.get(e2OldRep);
                if (mergePartnerOldRepCccs == null) continue;
                for (Map.Entry ccc1 : mergePartnerOldRepCccs) {
                    this.addPropIfOneIsEqualOneIsUnconstrained((ICongruenceClosureElement)ccc1.getKey(), (ICongruenceClosureElement)ccc1.getValue(), (ICongruenceClosureElement)ccc2.getKey(), (ICongruenceClosureElement)ccc2.getValue(), disequalitiesToPropagate);
                }
            }
        }
    }

    public void removeElement(ELEM elem, boolean elemWasRepresentative, ELEM newRep) {
        if (elemWasRepresentative) {
            Set oldAfCcparEntry = this.mAfCcPars.removeDomainElement(elem);
            if (newRep != null && oldAfCcparEntry != null) {
                oldAfCcparEntry.forEach(e -> {
                    boolean bl = this.mAfCcPars.addPair(newRep, e);
                });
            }
            Set oldArgCcparEntry = this.mArgCcPars.removeDomainElement(elem);
            if (newRep != null && oldArgCcparEntry != null) {
                oldArgCcparEntry.forEach(e -> {
                    boolean bl = this.mArgCcPars.addPair(newRep, e);
                });
            }
            HashRelation<ELEM, ELEM> oldCccEntry = this.mCcChildren.remove(elem);
            if (newRep != null && oldCccEntry != null) {
                this.mCcChildren.put(newRep, oldCccEntry);
            }
        }
        if (newRep != null) {
            for (ICongruenceClosureElement e2 : new ArrayList(this.mAfCcPars.getImage(newRep))) {
                if (!e2.getAppliedFunction().equals(elem)) continue;
                this.mAfCcPars.removePair(newRep, e2);
            }
            for (ICongruenceClosureElement e2 : new ArrayList(this.mArgCcPars.getImage(newRep))) {
                if (!e2.getArgument().equals(elem)) continue;
                this.mArgCcPars.removePair(newRep, e2);
            }
        }
        this.mAfCcPars.removeRangeElement(elem);
        this.mArgCcPars.removeRangeElement(elem);
        if (newRep == null) {
            assert (elemWasRepresentative);
        } else if (elem.isFunctionApplication() && this.mCcChildren.get(newRep) != null) {
            this.mCcChildren.get(newRep).removePair(elem.getAppliedFunction(), elem.getArgument());
        }
    }

    HashRelation<ELEM, ELEM> registerNewElement(ELEM elem) {
        assert (elem.isFunctionApplication()) : "right?..";
        Object afRep = this.mCongruenceClosure.hasElement(elem.getAppliedFunction()) ? (ICongruenceClosureElement)this.mCongruenceClosure.mElementTVER.getRepresentative(elem.getAppliedFunction()) : elem.getAppliedFunction();
        Object argRep = this.mCongruenceClosure.hasElement(elem.getArgument()) ? (ICongruenceClosureElement)this.mCongruenceClosure.mElementTVER.getRepresentative(elem.getArgument()) : elem.getArgument();
        HashRelation<ELEM, ICongruenceClosureElement> equalitiesToPropagate = new HashRelation<ELEM, ICongruenceClosureElement>();
        if (!this.mCongruenceClosure.isInconsistent()) {
            Set afCcPars = this.mAfCcPars.getImage(afRep);
            Set candidates = afCcPars.stream().filter(afccpar -> this.mCongruenceClosure.hasElement((ICongruenceClosureElement)argRep) && this.mCongruenceClosure.hasElement(afccpar.getArgument()) && this.mCongruenceClosure.getEqualityStatus((ICongruenceClosureElement)argRep, (ICongruenceClosureElement)afccpar.getArgument()) == EqualityStatus.EQUAL).collect(Collectors.toSet());
            for (ICongruenceClosureElement c : candidates) {
                assert (c.isFunctionApplication());
                equalitiesToPropagate.addPair(elem, c);
            }
        }
        this.mAfCcPars.addPair(afRep, elem);
        this.mArgCcPars.addPair(argRep, elem);
        ICongruenceClosureElement elemRep = (ICongruenceClosureElement)this.mCongruenceClosure.mElementTVER.getRepresentative(elem);
        this.updateCcChild(elemRep, elem.getAppliedFunction(), elem.getArgument());
        return equalitiesToPropagate;
    }

    private void updateCcChild(ELEM elemRep, ELEM appliedFunction, ELEM argument) {
        HashRelation<Object, Object> elemCcc = this.mCcChildren.get(elemRep);
        if (elemCcc == null) {
            elemCcc = new HashRelation();
            this.mCcChildren.put(elemRep, elemCcc);
        }
        elemCcc.addPair(appliedFunction, argument);
    }

    public HashRelation<ELEM, ELEM> getPropagationsOnReportDisequality(ELEM elem1, ELEM elem2) {
        HashRelation result = new HashRelation();
        ICongruenceClosureElement e1Rep = (ICongruenceClosureElement)this.mCongruenceClosure.mElementTVER.getRepresentative(elem1);
        ICongruenceClosureElement e2Rep = (ICongruenceClosureElement)this.mCongruenceClosure.mElementTVER.getRepresentative(elem2);
        HashRelation<ICongruenceClosureElement, ICongruenceClosureElement> ccc1 = this.getCcChildren(e1Rep);
        HashRelation<ICongruenceClosureElement, ICongruenceClosureElement> ccc2 = this.getCcChildren(e2Rep);
        for (Map.Entry pair1 : ccc1.getSetOfPairs()) {
            for (Map.Entry pair2 : ccc2.getSetOfPairs()) {
                this.addPropIfOneIsEqualOneIsUnconstrained((ICongruenceClosureElement)pair1.getKey(), (ICongruenceClosureElement)pair1.getValue(), (ICongruenceClosureElement)pair2.getKey(), (ICongruenceClosureElement)pair2.getValue(), result);
            }
        }
        return result;
    }

    public HashRelation<ELEM, ELEM> getCcChildren(ELEM rep) {
        assert (this.mOmitRepresentativeChecks || this.mCongruenceClosure.isRepresentative(rep));
        HashRelation<Object, Object> result = this.mCcChildren.get(rep);
        if (result == null) {
            result = new HashRelation();
            this.mCcChildren.put(rep, result);
        }
        return result;
    }

    private void addPropIfOneIsEqualOneIsUnconstrained(ELEM af1, ELEM arg1, ELEM af2, ELEM arg2, HashRelation<ELEM, ELEM> result) {
        if (!(this.mCongruenceClosure.hasElement(af1) && this.mCongruenceClosure.hasElement(af2) && this.mCongruenceClosure.hasElement(arg1) && this.mCongruenceClosure.hasElement(arg2))) {
            return;
        }
        EqualityStatus equalityStatusOfAppliedFunctions = this.mCongruenceClosure.getEqualityStatus(af1, af2);
        EqualityStatus equalityStatusOfArguments = this.mCongruenceClosure.getEqualityStatus(arg1, arg2);
        if (equalityStatusOfAppliedFunctions == EqualityStatus.EQUAL && equalityStatusOfArguments == EqualityStatus.UNKNOWN && arg1.hasSameTypeAs(arg2)) {
            result.addPair(arg1, arg2);
        }
        if (equalityStatusOfAppliedFunctions == EqualityStatus.UNKNOWN && equalityStatusOfArguments == EqualityStatus.EQUAL && af1.hasSameTypeAs(af2)) {
            result.addPair(af1, af2);
        }
    }

    public Collection<ELEM> getAfCcPars(ELEM elem) {
        assert (this.mOmitRepresentativeChecks || this.mCongruenceClosure.isRepresentative(elem));
        return this.mAfCcPars.getImage(elem);
    }

    public Collection<ELEM> getArgCcPars(ELEM elem) {
        assert (this.mOmitRepresentativeChecks || this.mCongruenceClosure.isRepresentative(elem));
        return this.mArgCcPars.getImage(elem);
    }

    public void transformElements(Function<ELEM, ELEM> elemTransformer) {
        this.mAfCcPars.transformElements(elemTransformer, elemTransformer);
        this.mArgCcPars.transformElements(elemTransformer, elemTransformer);
        for (Map.Entry<ELEM, HashRelation<ELEM, ELEM>> en : new HashMap<ELEM, HashRelation<ELEM, ELEM>>(this.mCcChildren).entrySet()) {
            this.mCcChildren.remove(en.getKey());
            assert (en.getValue().isEmpty() || !this.mCcChildren.values().contains(en.getValue())) : "just to make sure there's no overlap in the map's image values";
            en.getValue().transformElements(elemTransformer, elemTransformer);
            this.mCcChildren.put((ICongruenceClosureElement)elemTransformer.apply((ICongruenceClosureElement)en.getKey()), en.getValue());
        }
    }
}

