/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ThreeValuedEquivalenceRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CCLiteralSetConstraints;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IEqualityReportingTarget;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IRemovalInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.RemoveCcElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintConjunction;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.PartialOrderCache;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.statistics.BenchmarkWithCounters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public class CcManager<ELEM extends ICongruenceClosureElement<ELEM>> {
    private final IPartialComparator<CongruenceClosure<ELEM>> mCcComparator;
    private final ILogger mLogger;
    private final CongruenceClosure<ELEM> mInconsistentCc;
    private final CongruenceClosure<ELEM> mEmptyFrozenCc;
    private final PartialOrderCache<CongruenceClosure<ELEM>> mPartialOrderCache;
    private final boolean mBenchmarkMode;
    private BenchmarkWithCounters mBenchmark;
    private final SetConstraintManager<ELEM> mSetConstraintManager;

    public CcManager(ILogger logger, IPartialComparator<CongruenceClosure<ELEM>> ccComparator) {
        this.mLogger = logger;
        this.mCcComparator = ccComparator;
        this.mSetConstraintManager = new SetConstraintManager(this);
        this.mInconsistentCc = new CongruenceClosure(true);
        this.mInconsistentCc.freezeAndClose();
        this.mEmptyFrozenCc = new CongruenceClosure(this);
        this.mEmptyFrozenCc.freezeAndClose();
        this.mPartialOrderCache = null;
        this.mBenchmarkMode = false;
        if (this.mBenchmarkMode) {
            this.mBenchmark = new BenchmarkWithCounters();
            this.mBenchmark.registerCountersAndWatches(CcBmNames.getNames());
        } else {
            this.mBenchmark = null;
        }
    }

    private CongruenceClosure<ELEM> addToPartialOrderCache(CongruenceClosure<ELEM> cc) {
        assert (this.mPartialOrderCache != null);
        this.freezeIfNecessary(cc);
        CongruenceClosure<ELEM> result = this.mPartialOrderCache.addElement(cc);
        return cc;
    }

    public CongruenceClosure<ELEM> meet(CongruenceClosure<ELEM> cc1, CongruenceClosure<ELEM> cc2, boolean inplace) {
        CongruenceClosure<ELEM> result = this.meet(cc1, cc2, null, inplace);
        result = this.postProcessCcResult(result);
        return result;
    }

    private CongruenceClosure<ELEM> postProcessCcResult(CongruenceClosure<ELEM> cc) {
        CongruenceClosure<ELEM> result = cc;
        return result;
    }

    public CongruenceClosure<ELEM> meet(CongruenceClosure<ELEM> cc1, CongruenceClosure<ELEM> cc2, IRemovalInfo<ELEM> remInfo, boolean inplace) {
        this.bmStart(CcBmNames.MEET);
        if (!inplace) {
            this.freezeIfNecessary(cc1);
            this.freezeIfNecessary(cc2);
        }
        assert (inplace != cc1.isFrozen());
        if (cc1.isTautological() && !inplace) {
            this.freezeIfNecessary(cc2);
            this.bmEnd(CcBmNames.MEET);
            return cc2;
        }
        if (cc2.isTautological()) {
            this.bmEnd(CcBmNames.MEET);
            return cc1;
        }
        if (cc1.isInconsistent()) {
            this.bmEnd(CcBmNames.MEET);
            return cc1;
        }
        if (cc2.isInconsistent() && !inplace) {
            this.bmEnd(CcBmNames.MEET);
            return this.getInconsistentCc();
        }
        CongruenceClosure<ELEM> result = remInfo == null ? cc1.meetRec(cc2, inplace) : cc1.meetRec(cc2, remInfo, inplace);
        CongruenceClosure<ELEM> resultPp = this.postProcessCcResult(result);
        this.bmEnd(CcBmNames.MEET);
        return resultPp;
    }

    public CongruenceClosure<ELEM> join(CongruenceClosure<ELEM> cc1, CongruenceClosure<ELEM> cc2, boolean modifiable) {
        this.bmStart(CcBmNames.JOIN);
        this.freezeIfNecessary(cc1);
        this.freezeIfNecessary(cc2);
        if (cc1.isInconsistent()) {
            this.bmEnd(CcBmNames.JOIN);
            return cc2;
        }
        if (cc2.isInconsistent()) {
            this.bmEnd(CcBmNames.JOIN);
            return cc1;
        }
        if (cc1.isTautological() || cc2.isTautological()) {
            this.bmEnd(CcBmNames.JOIN);
            return this.getEmptyCc(modifiable);
        }
        CongruenceClosure<ELEM> result = cc1.join(cc2);
        if (!modifiable) {
            result.freezeAndClose();
        }
        assert (modifiable != result.isFrozen());
        CongruenceClosure<ELEM> resultPp = this.postProcessCcResult(result);
        this.bmEnd(CcBmNames.JOIN);
        return resultPp;
    }

    public Set<CongruenceClosure<ELEM>> filterRedundantCcs(Set<CongruenceClosure<ELEM>> unionList) {
        PartialOrderCache<CongruenceClosure<ELEM>> poc = new PartialOrderCache<CongruenceClosure<ELEM>>(this.mCcComparator);
        Set<CongruenceClosure<ELEM>> result = this.filterRedundantCcs(unionList, poc);
        return result;
    }

    public IPartialComparator<CongruenceClosure<ELEM>> getCcComparator() {
        return this.mCcComparator;
    }

    public Set<CongruenceClosure<ELEM>> filterRedundantCcs(Set<CongruenceClosure<ELEM>> unionList, PartialOrderCache<CongruenceClosure<ELEM>> ccPoCache) {
        this.bmStart(CcBmNames.FILTERREDUNDANT);
        if (unionList.isEmpty()) {
            this.bmEnd(CcBmNames.FILTERREDUNDANT);
            return unionList;
        }
        Set<CongruenceClosure<ELEM>> maxReps = ccPoCache.getMaximalRepresentatives(unionList);
        assert (!maxReps.stream().anyMatch(cc -> cc.isInconsistent()) || maxReps.size() == 1);
        if (maxReps.iterator().next().isInconsistent()) {
            this.bmEnd(CcBmNames.FILTERREDUNDANT);
            return Collections.emptySet();
        }
        this.bmEnd(CcBmNames.FILTERREDUNDANT);
        return maxReps;
    }

    public CongruenceClosure<ELEM> reportEquality(ELEM node1, ELEM node2, CongruenceClosure<ELEM> origCc, boolean inplace) {
        this.bmStart(CcBmNames.REPORT_EQUALITY);
        if (inplace) {
            origCc.reportEquality(node1, node2);
            this.bmEnd(CcBmNames.REPORT_EQUALITY);
            return origCc;
        }
        CongruenceClosure<ELEM> unfrozen = this.unfreeze(origCc);
        unfrozen.reportEquality(node1, node2);
        unfrozen.freezeAndClose();
        CongruenceClosure<ELEM> resultPp = this.postProcessCcResult(unfrozen);
        this.bmEnd(CcBmNames.REPORT_EQUALITY);
        return resultPp;
    }

    public CongruenceClosure<ELEM> reportDisequality(ELEM node1, ELEM node2, CongruenceClosure<ELEM> origCc, boolean inplace) {
        this.bmStart(CcBmNames.REPORT_DISEQUALITY);
        if (inplace) {
            origCc.reportDisequality(node1, node2);
            this.bmEnd(CcBmNames.REPORT_DISEQUALITY);
            return origCc;
        }
        CongruenceClosure<ELEM> unfrozen = this.unfreeze(origCc);
        unfrozen.reportDisequality(node1, node2);
        unfrozen.freezeAndClose();
        assert (unfrozen.isInconsistent() || unfrozen.getEqualityStatus(node1, node2) == EqualityStatus.NOT_EQUAL);
        CongruenceClosure<ELEM> resultPp = this.postProcessCcResult(unfrozen);
        this.bmEnd(CcBmNames.REPORT_DISEQUALITY);
        return resultPp;
    }

    public CongruenceClosure<ELEM> reportContainsConstraint(ELEM elem, Collection<ELEM> elementSet, CongruenceClosure<ELEM> origCc, boolean inplace) {
        return this.reportContainsConstraint(elem, Collections.singleton(this.mSetConstraintManager.buildSetConstraint(elementSet)), origCc, inplace);
    }

    public CongruenceClosure<ELEM> reportContainsConstraint(ELEM elem, Set<SetConstraint<ELEM>> elementSet, CongruenceClosure<ELEM> origCc, boolean inplace) {
        this.bmStart(CcBmNames.REPORTCONTAINS);
        if (inplace) {
            origCc.reportContainsConstraint(elem, (Collection<SetConstraint<ELEM>>)elementSet);
            this.bmEnd(CcBmNames.REPORTCONTAINS);
            return origCc;
        }
        CongruenceClosure<ELEM> unfrozen = this.unfreeze(origCc);
        unfrozen.reportContainsConstraint(elem, (Collection<SetConstraint<ELEM>>)elementSet);
        unfrozen.freezeAndClose();
        CongruenceClosure<ELEM> resultPp = this.postProcessCcResult(unfrozen);
        this.bmEnd(CcBmNames.REPORTCONTAINS);
        return resultPp;
    }

    public CongruenceClosure<ELEM> removeSimpleElement(ELEM elem, CongruenceClosure<ELEM> origCc, boolean modifiable) {
        this.freezeIfNecessary(origCc);
        CongruenceClosure<ELEM> result = this.unfreeze(origCc);
        RemoveCcElement.removeSimpleElement(result, elem);
        if (!modifiable) {
            result.freezeAndClose();
        }
        assert (modifiable != result.isFrozen());
        CongruenceClosure<ELEM> resultPp = this.postProcessCcResult(result);
        return resultPp;
    }

    public CongruenceClosure<ELEM> removeSimpleElementDontIntroduceNewNodes(ELEM elem, CongruenceClosure<ELEM> origCc, boolean modifiable) {
        this.freezeIfNecessary(origCc);
        CongruenceClosure<ELEM> result = this.unfreeze(origCc);
        RemoveCcElement.removeSimpleElementDontIntroduceNewNodes(result, elem);
        if (!modifiable) {
            result.freezeAndClose();
        }
        assert (modifiable != result.isFrozen());
        CongruenceClosure<ELEM> resultPp = this.postProcessCcResult(result);
        return resultPp;
    }

    public CongruenceClosure<ELEM> unfreeze(CongruenceClosure<ELEM> origCc) {
        assert (origCc.isFrozen());
        return new CongruenceClosure<ELEM>(origCc);
    }

    private CongruenceClosure<ELEM> unfreeze(CongruenceClosure<ELEM> cc, IRemovalInfo<ELEM> remInfo) {
        assert (cc.isFrozen());
        return new CongruenceClosure<ELEM>(cc, remInfo);
    }

    public CongruenceClosure<ELEM> addElement(CongruenceClosure<ELEM> congruenceClosure, ELEM elem, boolean inplace, boolean omitSanityCheck) {
        return this.addElement(congruenceClosure, elem, congruenceClosure, inplace, omitSanityCheck);
    }

    public CongruenceClosure<ELEM> addElement(CongruenceClosure<ELEM> congruenceClosure, ELEM elem, IEqualityReportingTarget<ELEM> newEqualityTarget, boolean inplace, boolean omitSanityCheck) {
        assert (inplace != congruenceClosure.isFrozen());
        if (inplace) {
            congruenceClosure.addElement(elem, newEqualityTarget, omitSanityCheck);
            return congruenceClosure;
        }
        CongruenceClosure<ELEM> unfrozen = this.unfreeze(congruenceClosure);
        unfrozen.addElement(elem, newEqualityTarget, omitSanityCheck);
        unfrozen.freezeAndClose();
        CongruenceClosure<ELEM> resultPp = this.postProcessCcResult(unfrozen);
        return resultPp;
    }

    public boolean addElementReportChange(CongruenceClosure<ELEM> congruenceClosure, ELEM elem, boolean omitSanityCheck) {
        return congruenceClosure.addElement(elem, congruenceClosure, omitSanityCheck);
    }

    public boolean isDebugMode() {
        return true;
    }

    public ILogger getLogger() {
        return this.mLogger;
    }

    public CongruenceClosure<ELEM> getSingleEqualityCc(ELEM node1, ELEM node2, boolean modifiable) {
        CongruenceClosure<ELEM> cc = this.getEmptyCc(modifiable);
        CongruenceClosure<ELEM> result = this.reportEquality(node1, node2, cc, modifiable);
        CongruenceClosure<ELEM> resultPp = this.postProcessCcResult(result);
        return resultPp;
    }

    public CongruenceClosure<ELEM> getSingleDisequalityCc(ELEM node1, ELEM node2, boolean modifiable) {
        CongruenceClosure<ELEM> cc = this.getEmptyCc(modifiable);
        CongruenceClosure<ELEM> result = this.reportDisequality(node1, node2, cc, modifiable);
        CongruenceClosure<ELEM> resultPp = this.postProcessCcResult(result);
        return resultPp;
    }

    public CongruenceClosure<ELEM> getEmptyCc(boolean modifiable) {
        if (modifiable) {
            return new CongruenceClosure(this);
        }
        return this.mEmptyFrozenCc;
    }

    public CongruenceClosure<ELEM> getInconsistentCc() {
        return this.mInconsistentCc;
    }

    public CongruenceClosure<ELEM> getCongruenceClosureFromTver(ThreeValuedEquivalenceRelation<ELEM> tver, boolean modifiable) {
        CongruenceClosure<ELEM> result = new CongruenceClosure<ELEM>(this, tver);
        if (!modifiable) {
            result.freezeAndClose();
        }
        return result;
    }

    public CongruenceClosure<ELEM> getCongruenceClosureFromTver(ThreeValuedEquivalenceRelation<ELEM> tver, IRemovalInfo<ELEM> removeElementInfo, CCLiteralSetConstraints<ELEM> literalConstraints, boolean modifiable) {
        CongruenceClosure<ELEM> result = new CongruenceClosure<ELEM>(this, tver, literalConstraints, removeElementInfo);
        if (!modifiable) {
            result.freezeAndClose();
        }
        return result;
    }

    public CongruenceClosure<ELEM> getCopyWithRemovalInfo(CongruenceClosure<ELEM> cc, IRemovalInfo<ELEM> remInfo) {
        return new CongruenceClosure<ELEM>(cc, remInfo);
    }

    public CongruenceClosure<ELEM> copyNoRemInfo(CongruenceClosure<ELEM> cc) {
        if (cc.isInconsistent()) {
            return cc;
        }
        CongruenceClosure<ELEM> result = new CongruenceClosure<ELEM>(cc);
        if (cc.isFrozen()) {
            result.freezeAndClose();
        }
        return result;
    }

    public CongruenceClosure<ELEM> copyNoRemInfoUnfrozen(CongruenceClosure<ELEM> cc) {
        return new CongruenceClosure<ELEM>(cc);
    }

    public CongruenceClosure<ELEM> transformElements(CongruenceClosure<ELEM> cc, Function<ELEM, ELEM> transformer, boolean inplace) {
        CongruenceClosure<ELEM> result;
        if (inplace) {
            cc.transformElementsAndFunctions(transformer);
            result = cc;
        } else {
            CongruenceClosure<ELEM> unfrozen = this.unfreezeIfNecessary(cc);
            unfrozen.transformElementsAndFunctions(transformer);
            unfrozen.freezeAndClose();
            result = unfrozen;
        }
        assert (result.sanityCheck());
        CongruenceClosure<ELEM> resultPp = this.postProcessCcResult(result);
        return resultPp;
    }

    public CongruenceClosure<ELEM> projectToElements(CongruenceClosure<ELEM> cc, Set<ELEM> nodesToKeep, IRemovalInfo<ELEM> remInfo) {
        this.bmStart(CcBmNames.PROJECT_TO_ELEMENTS);
        CongruenceClosure<ELEM> unfrozen = this.unfreezeIfNecessary(cc);
        CongruenceClosure<ELEM> result = unfrozen.projectToElements(nodesToKeep, remInfo);
        result.freezeAndClose();
        CongruenceClosure<ELEM> resultPp = this.postProcessCcResult(result);
        this.bmEnd(CcBmNames.PROJECT_TO_ELEMENTS);
        return resultPp;
    }

    public CongruenceClosure<ELEM> addAllElements(CongruenceClosure<ELEM> cc, Collection<ELEM> elemsToAdd, IRemovalInfo<ELEM> remInfo, boolean inplace) {
        CongruenceClosure<ELEM> result;
        this.bmStart(CcBmNames.ADD_ALL_ELEMENTS);
        assert (!cc.isInconsistent());
        if (inplace) {
            result = cc;
        } else {
            this.freezeIfNecessary(cc);
            result = this.unfreeze(cc, remInfo);
        }
        for (ICongruenceClosureElement elem : elemsToAdd) {
            this.addElement(result, elem, true, true);
        }
        if (!inplace) {
            result.freezeAndClose();
        }
        CongruenceClosure<ELEM> resultPp = this.postProcessCcResult(result);
        this.bmEnd(CcBmNames.ADD_ALL_ELEMENTS);
        return resultPp;
    }

    public CongruenceClosure<ELEM> unfreezeIfNecessary(CongruenceClosure<ELEM> cc) {
        if (cc.isFrozen()) {
            return this.unfreeze(cc);
        }
        return cc;
    }

    public void freezeIfNecessary(CongruenceClosure<ELEM> cc) {
        if (!cc.isFrozen()) {
            cc.freezeAndClose();
        }
    }

    public CongruenceClosure<ELEM> getCopy(CongruenceClosure<ELEM> congruenceClosure, boolean modifiable) {
        CongruenceClosure<ELEM> copy = new CongruenceClosure<ELEM>(congruenceClosure);
        if (!modifiable) {
            copy.freezeAndClose();
        }
        return copy;
    }

    public boolean isStrongerThan(CongruenceClosure<ELEM> cc1, CongruenceClosure<ELEM> cc2) {
        return this.isStrongerThanNoCaching(cc1, cc2);
    }

    public boolean isStrongerThanNoCaching(CongruenceClosure<ELEM> cc1, CongruenceClosure<ELEM> cc2) {
        this.bmStart(CcBmNames.IS_STRONGER_THAN_NO_CACHING);
        if (cc1.isInconsistent()) {
            this.bmEnd(CcBmNames.IS_STRONGER_THAN_NO_CACHING);
            return true;
        }
        if (cc2.isInconsistent()) {
            this.bmEnd(CcBmNames.IS_STRONGER_THAN_NO_CACHING);
            return false;
        }
        if (cc2.isTautological()) {
            this.bmEnd(CcBmNames.IS_STRONGER_THAN_NO_CACHING);
            return true;
        }
        if (cc1.isTautological()) {
            this.bmEnd(CcBmNames.IS_STRONGER_THAN_NO_CACHING);
            return false;
        }
        Pair<CongruenceClosure<ELEM>, CongruenceClosure<ELEM>> aligned = this.alignElements(cc1, cc2, !cc1.isFrozen() && !cc2.isFrozen());
        CongruenceClosure<ELEM> thisAligned = aligned.getFirst();
        CongruenceClosure<ELEM> otherAligned = aligned.getSecond();
        assert (this.assertElementsAreSuperset(thisAligned, otherAligned));
        assert (this.assertElementsAreSuperset(otherAligned, thisAligned));
        boolean result = this.checkIsStrongerThan(thisAligned, otherAligned);
        this.bmEnd(CcBmNames.IS_STRONGER_THAN_NO_CACHING);
        return result;
    }

    private boolean checkIsStrongerThan(CongruenceClosure<ELEM> thisAligned, CongruenceClosure<ELEM> otherAligned) {
        assert (!thisAligned.isInconsistent() && !otherAligned.isInconsistent());
        assert (this.assertElementsAreSuperset(thisAligned, otherAligned));
        assert (this.assertElementsAreSuperset(otherAligned, thisAligned));
        if (!CcManager.isPartitionStronger(thisAligned.mElementTVER, otherAligned.mElementTVER)) {
            return false;
        }
        if (!CcManager.areDisequalitiesStrongerThan(thisAligned, otherAligned)) {
            return false;
        }
        return thisAligned.getLiteralSetConstraints().isStrongerThan(otherAligned.getLiteralSetConstraints());
    }

    public boolean isEquivalent(CongruenceClosure<ELEM> cc1, CongruenceClosure<ELEM> cc2) {
        CongruenceClosure<ELEM> otherAligned;
        if (cc1.isInconsistent() && cc2.isInconsistent()) {
            return true;
        }
        if (cc1.isTautological() && cc2.isTautological()) {
            return true;
        }
        if (cc2.isInconsistent() || cc1.isInconsistent()) {
            return false;
        }
        if (cc2.isTautological() || cc1.isTautological()) {
            return false;
        }
        Pair<CongruenceClosure<ELEM>, CongruenceClosure<ELEM>> aligned = this.alignElements(cc1, cc2, !cc1.isFrozen() && !cc2.isFrozen());
        CongruenceClosure<ELEM> thisAligned = aligned.getFirst();
        return this.checkIsStrongerThan(thisAligned, otherAligned = aligned.getSecond()) && this.checkIsStrongerThan(otherAligned, thisAligned);
    }

    public Pair<CongruenceClosure<ELEM>, CongruenceClosure<ELEM>> alignElements(CongruenceClosure<ELEM> cc1, CongruenceClosure<ELEM> cc2, boolean inplace) {
        assert (!inplace || !cc1.isFrozen());
        assert (!inplace || !cc2.isFrozen());
        if (inplace) {
            this.bmStart(CcBmNames.ALIGN_ELEMENTS);
            while (!cc1.getAllElements().containsAll(cc2.getAllElements()) || !cc2.getAllElements().containsAll(cc1.getAllElements())) {
                this.addAllElements(cc1, cc2.getAllElements(), null, true);
                this.addAllElements(cc2, cc1.getAllElements(), null, true);
            }
            this.bmEnd(CcBmNames.ALIGN_ELEMENTS);
            return new Pair<CongruenceClosure<ELEM>, CongruenceClosure<ELEM>>(cc1, cc2);
        }
        this.bmStart(CcBmNames.ALIGN_ELEMENTS);
        CongruenceClosure<ELEM> cc1Aligned = this.copyNoRemInfoUnfrozen(cc1);
        CongruenceClosure<ELEM> cc2Aligned = this.copyNoRemInfoUnfrozen(cc2);
        while (!cc1Aligned.getAllElements().containsAll(cc2Aligned.getAllElements()) || !cc2Aligned.getAllElements().containsAll(cc1Aligned.getAllElements())) {
            this.addAllElements(cc1Aligned, cc2Aligned.getAllElements(), null, true);
            this.addAllElements(cc2Aligned, cc1Aligned.getAllElements(), null, true);
        }
        cc1Aligned.freezeAndClose();
        cc2Aligned.freezeAndClose();
        this.bmEnd(CcBmNames.ALIGN_ELEMENTS);
        return new Pair<CongruenceClosure<ELEM>, CongruenceClosure<ELEM>>(cc1Aligned, cc2Aligned);
    }

    private static <E extends ICongruenceClosureElement<E>> boolean areDisequalitiesStrongerThan(CongruenceClosure<E> left, CongruenceClosure<E> right) {
        for (ICongruenceClosureElement rep : right.getAllRepresentatives()) {
            for (ICongruenceClosureElement disequalRep : right.getRepresentativesUnequalTo(rep)) {
                if (left.getEqualityStatus(rep, disequalRep) == EqualityStatus.NOT_EQUAL) continue;
                return false;
            }
        }
        return true;
    }

    private boolean assertElementsAreSuperset(Set<ELEM> a, Set<ELEM> b) {
        Set<ELEM> difference = DataStructureUtils.difference(b, a);
        if (!difference.isEmpty()) {
            assert (false);
            return false;
        }
        return true;
    }

    private boolean assertElementsAreSuperset(CongruenceClosure<ELEM> a, CongruenceClosure<ELEM> b) {
        Set<ELEM> difference = DataStructureUtils.difference(b.getAllElements(), a.getAllElements());
        if (!difference.isEmpty()) {
            assert (false);
            return false;
        }
        return true;
    }

    static <E> boolean isPartitionStronger(ThreeValuedEquivalenceRelation<E> first, ThreeValuedEquivalenceRelation<E> second) {
        ArrayList<E> representativesFromBoth = new ArrayList<E>(first.getAllRepresentatives().size() + second.getAllRepresentatives().size());
        representativesFromBoth.addAll(first.getAllRepresentatives());
        representativesFromBoth.addAll(second.getAllRepresentatives());
        for (Object rep : representativesFromBoth) {
            Set<E> eqInOther = second.getEquivalenceClass(rep);
            Set<E> eqInThis = first.getEquivalenceClass(rep);
            if (eqInThis.containsAll(eqInOther)) continue;
            return false;
        }
        return true;
    }

    public SetConstraintConjunction<ELEM> buildSetConstraintConjunction(CCLiteralSetConstraints<ELEM> surroundingSetConstraints, ELEM constrainedElement, Set<SetConstraint<ELEM>> setConstraintsIn) {
        this.bmStart(CcBmNames.BUILD_SET_CONSTRAINT_CONJUNCTION);
        Set<SetConstraint<ELEM>> setConstraintsUpdRepr = this.mSetConstraintManager.updateOnChangedRepresentative(setConstraintsIn, surroundingSetConstraints.getCongruenceClosure());
        Set<SetConstraint<ELEM>> filtered1 = this.normalizeSetConstraintConjunction(surroundingSetConstraints, setConstraintsUpdRepr);
        HashSet filtered2 = new HashSet();
        for (SetConstraint<ELEM> sc2 : filtered1) {
            if (sc2.isSingleton() || SetConstraint.isTautological(constrainedElement, sc2)) continue;
            filtered2.add(sc2);
        }
        assert (!filtered2.stream().anyMatch(sc -> sc.isInconsistent()) || filtered2.size() == 1) : "not correctly normalized: there is a 'false' conjunct, but it is not the only conjunct";
        if (filtered2.size() == 1 && ((SetConstraint)filtered2.iterator().next()).isInconsistent()) {
            this.bmEnd(CcBmNames.BUILD_SET_CONSTRAINT_CONJUNCTION);
            return new SetConstraintConjunction(true);
        }
        SetConstraintConjunction<ELEM> result = new SetConstraintConjunction<ELEM>(surroundingSetConstraints, constrainedElement, filtered2);
        this.bmEnd(CcBmNames.BUILD_SET_CONSTRAINT_CONJUNCTION);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public Set<SetConstraint<ELEM>> normalizeSetConstraintConjunction(CCLiteralSetConstraints<ELEM> surroundingSetConstraints, Collection<SetConstraint<ELEM>> setConstraintsIn) {
        void var5_15;
        this.bmStart(CcBmNames.NORMALIZE_SET_CONSTRAINT_CONJUNCTION);
        if (setConstraintsIn.isEmpty()) {
            this.bmEnd(CcBmNames.NORMALIZE_SET_CONSTRAINT_CONJUNCTION);
            return Collections.emptySet();
        }
        HashSet<SetConstraint<ELEM>> expanded = new HashSet<SetConstraint<ELEM>>(setConstraintsIn);
        HashRelation<ELEM, ELEM> elemToExpansion = surroundingSetConstraints.getElemToExpansion();
        for (SetConstraint<ELEM> setConstraint : setConstraintsIn) {
            for (Object e : setConstraint.getNonLiterals()) {
                Set expansion = elemToExpansion.getImage(e);
                if (expansion.isEmpty()) continue;
                expanded.add(this.mSetConstraintManager.expandNonLiteral(setConstraint, e, expansion));
            }
        }
        HashSet intersectionOfLiteralOnlyConstraints = null;
        for (SetConstraint setConstraint : expanded) {
            if (setConstraint.isInconsistent()) {
                this.bmEnd(CcBmNames.NORMALIZE_SET_CONSTRAINT_CONJUNCTION);
                return Collections.singleton(setConstraint);
            }
            if (!setConstraint.hasOnlyLiterals()) continue;
            if (intersectionOfLiteralOnlyConstraints == null) {
                intersectionOfLiteralOnlyConstraints = new HashSet(setConstraint.getLiterals());
                continue;
            }
            intersectionOfLiteralOnlyConstraints.retainAll(setConstraint.getLiterals());
            if (!intersectionOfLiteralOnlyConstraints.isEmpty()) continue;
            this.bmEnd(CcBmNames.NORMALIZE_SET_CONSTRAINT_CONJUNCTION);
            return Collections.singleton(setConstraint);
        }
        if (intersectionOfLiteralOnlyConstraints != null) {
            HashSet<SetConstraint<ELEM>> hashSet = new HashSet<SetConstraint<ELEM>>();
            hashSet.add(this.mSetConstraintManager.buildSetConstraint(intersectionOfLiteralOnlyConstraints, Collections.emptySet()));
            for (SetConstraint setConstraint : expanded) {
                if (setConstraint.hasOnlyLiterals()) continue;
                Set litIntersection = DataStructureUtils.intersection(intersectionOfLiteralOnlyConstraints, setConstraint.getLiterals());
                hashSet.add(this.mSetConstraintManager.buildSetConstraint(litIntersection, setConstraint.getNonLiterals()));
            }
        } else {
            HashSet<SetConstraint<ELEM>> hashSet = expanded;
        }
        PartialOrderCache<SetConstraint<ELEM>> partialOrderCache = new PartialOrderCache<SetConstraint<ELEM>>(this.mSetConstraintManager.getSetConstraintComparator());
        Set<SetConstraint<ELEM>> filtered = partialOrderCache.getMaximalRepresentatives((Collection<SetConstraint<ELEM>>)var5_15);
        assert (SetConstraintConjunction.sanityCheck(filtered));
        this.bmEnd(CcBmNames.NORMALIZE_SET_CONSTRAINT_CONJUNCTION);
        return filtered;
    }

    public BenchmarkWithCounters getBenchmark() {
        return this.mBenchmark;
    }

    private void bmStartOverall() {
        if (!this.mBenchmarkMode) {
            return;
        }
        this.mBenchmark.incrementCounter(CcBmNames.OVERALL.name());
        this.mBenchmark.unpauseWatch(CcBmNames.OVERALL.name());
    }

    private void bmEndOverall() {
        if (!this.mBenchmarkMode) {
            return;
        }
        this.mBenchmark.pauseWatch(CcBmNames.OVERALL.name());
    }

    void bmStart(CcBmNames watch) {
        if (!this.mBenchmarkMode) {
            return;
        }
        this.bmStartOverall();
        this.mBenchmark.incrementCounter(watch.name());
        this.mBenchmark.unpauseWatch(watch.name());
    }

    void bmEnd(CcBmNames watch) {
        if (!this.mBenchmarkMode) {
            return;
        }
        this.bmEndOverall();
        this.mBenchmark.pauseWatch(watch.name());
    }

    public boolean hasPartialOrderCacheBenchmark() {
        if (this.mPartialOrderCache == null) {
            return false;
        }
        return this.mPartialOrderCache.hasBenchmark();
    }

    public BenchmarkWithCounters getPartialOrderCacheBenchmark() {
        return this.mPartialOrderCache.getBenchmark();
    }

    public SetConstraintManager<ELEM> getSetConstraintManager() {
        return this.mSetConstraintManager;
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> HashRelation<ELEM, ELEM> computeSplitInfo(CongruenceClosure<ELEM> ccWithBroaderPartition, CongruenceClosure<ELEM> ccWithFinerPartition) {
        assert (CcManager.isPartitionStronger(ccWithBroaderPartition.mElementTVER, ccWithFinerPartition.mElementTVER)) : "assuming this has been checked already";
        HashRelation<ICongruenceClosureElement, ICongruenceClosureElement> result = new HashRelation<ICongruenceClosureElement, ICongruenceClosureElement>();
        for (ICongruenceClosureElement finerRep : ccWithFinerPartition.getAllRepresentatives()) {
            ICongruenceClosureElement broaderRep = ccWithBroaderPartition.getRepresentativeElement(finerRep);
            result.addPair(broaderRep, finerRep);
        }
        return result;
    }

    static enum CcBmNames {
        FILTERREDUNDANT,
        UNFREEZE,
        COPY,
        MEET,
        JOIN,
        REMOVE,
        IS_STRONGER_THAN_NO_CACHING,
        ADDNODE,
        REPORTCONTAINS,
        REPORT_EQUALITY,
        REPORT_DISEQUALITY,
        PROJECT_TO_ELEMENTS,
        ADD_ALL_ELEMENTS,
        ALIGN_ELEMENTS,
        OVERALL,
        IS_STRONGER_THAN_W_CACHING,
        BUILD_SET_CONSTRAINT_CONJUNCTION,
        NORMALIZE_SET_CONSTRAINT_CONJUNCTION,
        GET_EQUALITY_STATUS,
        MEET_IS_INCONSISTENT;


        static String[] getNames() {
            String[] result = new String[CcBmNames.values().length];
            int i = 0;
            while (i < CcBmNames.values().length) {
                result[i] = CcBmNames.values()[i].name();
                ++i;
            }
            return result;
        }
    }
}

