/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.CrossProducts;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ThreeValuedEquivalenceRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CCLiteralSetConstraints;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CcAuxData;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CcManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IElementRemovalTarget;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IEqualityReportingTarget;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IRemovalInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintConjunction;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.AbstractRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CongruenceClosure<ELEM extends ICongruenceClosureElement<ELEM>>
implements IEqualityReportingTarget<ELEM>,
IElementRemovalTarget<ELEM> {
    protected final ThreeValuedEquivalenceRelation<ELEM> mElementTVER;
    private final CcAuxData<ELEM> mAuxData;
    protected final FuncAppTreeAuxData mFaAuxData;
    protected final Set<ELEM> mAllLiterals;
    protected boolean mIsFrozen = false;
    boolean mConstructorInitializationPhase = false;
    protected IRemovalInfo<ELEM> mElementCurrentlyBeingRemoved;
    private IRemovalInfo<ELEM> mExternalRemovalInfo;
    private final CcManager<ELEM> mManager;
    CCLiteralSetConstraints<ELEM> mLiteralSetConstraints;

    CongruenceClosure(CcManager<ELEM> manager) {
        this.mElementTVER = new ThreeValuedEquivalenceRelation(CongruenceClosure::literalComparator);
        this.mAuxData = new CcAuxData(this);
        this.mFaAuxData = new FuncAppTreeAuxData();
        this.mAllLiterals = new HashSet<ELEM>();
        this.mManager = manager;
        this.mLiteralSetConstraints = new CCLiteralSetConstraints<ELEM>(manager, this);
    }

    CongruenceClosure(boolean isInconsistent) {
        if (!isInconsistent) {
            throw new AssertionError((Object)"use other constructor");
        }
        this.mElementTVER = null;
        this.mAuxData = null;
        this.mFaAuxData = null;
        this.mAllLiterals = null;
        this.mManager = null;
        this.mLiteralSetConstraints = null;
    }

    CongruenceClosure(CcManager<ELEM> manager, ThreeValuedEquivalenceRelation<ELEM> newElemPartition) {
        this.mManager = manager;
        this.mElementTVER = newElemPartition;
        this.mAuxData = new CcAuxData(this);
        this.mFaAuxData = new FuncAppTreeAuxData();
        this.mAllLiterals = new HashSet<ELEM>();
        this.mLiteralSetConstraints = new CCLiteralSetConstraints<ELEM>(this.mManager, this);
        this.mConstructorInitializationPhase = true;
        for (ICongruenceClosureElement elem : new HashSet<ELEM>(this.mElementTVER.getAllElements())) {
            this.registerNewElement(elem, this);
        }
        this.mConstructorInitializationPhase = false;
        assert (this.sanityCheck());
    }

    CongruenceClosure(CcManager<ELEM> manager, ThreeValuedEquivalenceRelation<ELEM> newElemPartition, CCLiteralSetConstraints<ELEM> literalConstraints, IRemovalInfo<ELEM> remInfo) {
        assert (newElemPartition.getAllElements().containsAll(literalConstraints.getAllElementsMentionedInASetConstraint()));
        this.mElementTVER = newElemPartition;
        this.mAuxData = new CcAuxData(this);
        this.mFaAuxData = new FuncAppTreeAuxData();
        this.mAllLiterals = new HashSet<ELEM>();
        this.mManager = manager;
        this.mLiteralSetConstraints = Objects.requireNonNull(literalConstraints);
        this.mLiteralSetConstraints.setCongruenceClosure(this);
        this.mConstructorInitializationPhase = true;
        for (ICongruenceClosureElement elem : new HashSet<ELEM>(this.mElementTVER.getAllElements())) {
            this.registerNewElement(elem, this, remInfo);
        }
        this.mConstructorInitializationPhase = false;
        assert (this.sanityCheck(remInfo));
    }

    CongruenceClosure(CongruenceClosure<ELEM> original, IRemovalInfo<ELEM> externalRemovalInfo) {
        if (original.isInconsistent()) {
            throw new IllegalArgumentException("use other constructor!");
        }
        this.mElementTVER = new ThreeValuedEquivalenceRelation<ELEM>(original.mElementTVER);
        this.mAuxData = new CcAuxData<ELEM>(this, original.getAuxData());
        this.mFaAuxData = new FuncAppTreeAuxData(original.mFaAuxData);
        this.mAllLiterals = new HashSet<ELEM>(original.mAllLiterals);
        this.mExternalRemovalInfo = externalRemovalInfo;
        this.mManager = original.mManager;
        this.mLiteralSetConstraints = new CCLiteralSetConstraints<ELEM>(original.mManager, this, original.getLiteralSetConstraints());
        assert (this.sanityCheck(externalRemovalInfo));
    }

    CongruenceClosure(CongruenceClosure<ELEM> original) {
        this(original, null);
    }

    static <ELEM extends ICongruenceClosureElement<ELEM>> Integer literalComparator(ELEM e1, ELEM e2) {
        if (e1.isLiteral() && !e2.isLiteral()) {
            return -1;
        }
        if (e2.isLiteral() && !e1.isLiteral()) {
            return 1;
        }
        return 0;
    }

    public void freezeAndClose() {
        assert (!this.mIsFrozen);
        this.mIsFrozen = true;
    }

    public boolean isFrozen() {
        return this.mIsFrozen;
    }

    boolean reportEquality(ELEM elem1, ELEM elem2) {
        boolean result = this.reportEqualityRec(elem1, elem2);
        return result;
    }

    @Override
    public boolean reportEqualityRec(ELEM elem1, ELEM elem2) {
        assert (!this.mIsFrozen);
        if (this.isInconsistent()) {
            throw new IllegalStateException();
        }
        boolean freshElem = false;
        freshElem |= this.mManager.addElementReportChange(this, elem1, true);
        freshElem |= this.mManager.addElementReportChange(this, elem2, true);
        if (this.getEqualityStatus(elem1, elem2) == EqualityStatus.EQUAL) {
            return freshElem;
        }
        if (this.getEqualityStatus(elem1, elem2) == EqualityStatus.NOT_EQUAL) {
            this.mElementTVER.reportEquality(elem1, elem2);
            if (!this.mElementTVER.isInconsistent()) {
                this.mElementTVER.reportDisequality(elem1, elem2);
            }
            assert (this.mElementTVER.isInconsistent());
            return true;
        }
        Pair<HashRelation<ELEM, ELEM>, HashRelation<ELEM, ELEM>> propInfo = this.doMergeAndComputePropagations(elem1, elem2);
        if (propInfo == null) {
            return true;
        }
        CongruenceClosure.doFwccAndBwccPropagationsFromMerge(propInfo, this);
        return true;
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> void doFwccAndBwccPropagationsFromMerge(Pair<HashRelation<ELEM, ELEM>, HashRelation<ELEM, ELEM>> propInfo, IEqualityReportingTarget<ELEM> icc) {
        HashRelation<ELEM, ELEM> equalitiesToPropagate = propInfo.getFirst();
        HashRelation<ELEM, ELEM> disequalitiesToPropagate = propInfo.getSecond();
        for (Map.Entry congruentParents : equalitiesToPropagate) {
            if (icc.isInconsistent(false)) {
                return;
            }
            icc.reportEqualityRec((ICongruenceClosureElement)congruentParents.getKey(), (ICongruenceClosureElement)congruentParents.getValue());
        }
        for (Map.Entry unequalNeighborIndices : disequalitiesToPropagate) {
            if (icc.isInconsistent(false)) {
                return;
            }
            icc.reportDisequalityRec((ICongruenceClosureElement)unequalNeighborIndices.getKey(), (ICongruenceClosureElement)unequalNeighborIndices.getValue());
        }
    }

    public Pair<HashRelation<ELEM, ELEM>, HashRelation<ELEM, ELEM>> doMergeAndComputePropagations(ELEM elem1, ELEM elem2) {
        ICongruenceClosureElement e1OldRep = (ICongruenceClosureElement)this.mElementTVER.getRepresentative(elem1);
        ICongruenceClosureElement e2OldRep = (ICongruenceClosureElement)this.mElementTVER.getRepresentative(elem2);
        CongruenceClosure.constantAndMixFunctionTreatmentOnAddEquality(e1OldRep, e2OldRep, this.mElementTVER.getEquivalenceClass(elem1), this.mElementTVER.getEquivalenceClass(elem2), this.getAuxData(), e -> {
            CongruenceClosure<ICongruenceClosureElement> congruenceClosure = this.mManager.addElement(this, (ICongruenceClosureElement)e, true, true);
        }, this);
        Set<ICongruenceClosureElement> oldUnequalRepsForElem1 = this.getRepresentativesUnequalTo(e1OldRep);
        Set<ICongruenceClosureElement> oldUnequalRepsForElem2 = this.getRepresentativesUnequalTo(e2OldRep);
        this.mElementTVER.reportEquality(elem1, elem2);
        if (this.mElementTVER.isInconsistent()) {
            return null;
        }
        if (e1OldRep.isLiteral() || e2OldRep.isLiteral()) {
            ELEM newRep = this.getRepresentativeElement(elem1);
            assert (newRep.isLiteral()) : "if one element of an equivalence class is a literal, then it must be the representative";
            for (ICongruenceClosureElement unequalToMerged : this.mElementTVER.getRepresentativesUnequalTo(newRep)) {
                if (!unequalToMerged.isLiteral()) continue;
                this.mElementTVER.removeDisequality(newRep, unequalToMerged);
            }
        }
        Pair<HashRelation<ELEM, ELEM>, HashRelation<ELEM, ELEM>> propInfo = new Pair<HashRelation<ELEM, ELEM>, HashRelation<ELEM, ELEM>>(new HashRelation(), new HashRelation());
        HashRelation<ICongruenceClosureElement, ICongruenceClosureElement> eqToProp = this.mLiteralSetConstraints.reportEquality(e1OldRep, e2OldRep, (ICongruenceClosureElement)this.mElementTVER.getRepresentative(elem1));
        if (eqToProp != null) {
            propInfo.getFirst().addAll(eqToProp);
        }
        if (this.mLiteralSetConstraints.isInconsistent()) {
            return null;
        }
        Pair<HashRelation<ICongruenceClosureElement, ICongruenceClosureElement>, HashRelation<ICongruenceClosureElement, ICongruenceClosureElement>> mergePropInfo = this.getAuxData().updateAndGetPropagationsOnMerge((ICongruenceClosureElement)elem1, (ICongruenceClosureElement)elem2, e1OldRep, e2OldRep, oldUnequalRepsForElem1, oldUnequalRepsForElem2);
        propInfo.getFirst().addAll((AbstractRelation)mergePropInfo.getFirst());
        propInfo.getSecond().addAll((AbstractRelation)mergePropInfo.getSecond());
        return propInfo;
    }

    public Set<ELEM> getRepresentativesUnequalTo(ELEM rep) {
        assert (this.isRepresentative(rep));
        HashSet<ELEM> result = new HashSet<ELEM>(this.mElementTVER.getRepresentativesUnequalTo(rep));
        if (rep.isLiteral()) {
            for (ICongruenceClosureElement lit : this.mAllLiterals) {
                if (!lit.hasSameTypeAs(rep) || lit.equals(rep)) continue;
                result.add(lit);
            }
        }
        assert (result.stream().allMatch(el -> el.hasSameTypeAs(rep))) : "don't track disequalities between different sorts -- they are always implicit";
        return result;
    }

    boolean reportDisequality(ELEM elem1, ELEM elem2) {
        boolean result = this.reportDisequalityRec(elem1, elem2);
        return result;
    }

    @Override
    public boolean reportDisequalityRec(ELEM elem1, ELEM elem2) {
        assert (!this.mIsFrozen);
        assert (elem1.hasSameTypeAs(elem2));
        if (this.isInconsistent()) {
            throw new IllegalStateException();
        }
        boolean freshElem = false;
        freshElem |= this.mManager.addElementReportChange(this, elem1, true);
        if (!(freshElem |= this.mManager.addElementReportChange(this, elem2, true)) && this.getEqualityStatus(elem1, elem2) == EqualityStatus.NOT_EQUAL) {
            return false;
        }
        if (elem1.isLiteral() && elem2.isLiteral()) {
            assert (this.getEqualityStatus(elem1, elem2) == EqualityStatus.NOT_EQUAL);
        } else {
            this.mElementTVER.reportDisequality(elem1, elem2);
            if (this.mElementTVER.isInconsistent()) {
                return true;
            }
        }
        this.mLiteralSetConstraints.reportDisequality(elem1, elem2);
        if (this.mLiteralSetConstraints.isInconsistent()) {
            return true;
        }
        HashRelation<ELEM, ELEM> propDeqs = this.getAuxData().getPropagationsOnReportDisequality(elem1, elem2);
        for (Map.Entry deq : propDeqs) {
            this.reportDisequalityRec((ICongruenceClosureElement)deq.getKey(), (ICongruenceClosureElement)deq.getValue());
        }
        return true;
    }

    @Override
    public boolean addElement(ELEM elem, boolean omitSanityCheck) {
        return this.addElement(elem, this, omitSanityCheck);
    }

    public boolean addElement(ELEM elem, IEqualityReportingTarget<ELEM> newEqualityTarget, boolean omitSanityCheck) {
        boolean result = this.addElementRec(elem, newEqualityTarget, null);
        return result;
    }

    private boolean addElementRec(ELEM elem, IEqualityReportingTarget<ELEM> newEqualityTarget, IRemovalInfo<ELEM> remInfo) {
        assert (!this.mIsFrozen);
        boolean newlyAdded = this.mElementTVER.addElement(elem);
        if (newlyAdded) {
            this.registerNewElement(elem, newEqualityTarget, remInfo);
        }
        return newlyAdded;
    }

    private void registerNewElement(ELEM elem, IEqualityReportingTarget<ELEM> newEqualityTarget) {
        this.registerNewElement(elem, newEqualityTarget, null);
    }

    private void registerNewElement(ELEM elem, IEqualityReportingTarget<ELEM> newEqualityTarget, IRemovalInfo<ELEM> remInfo) {
        if (elem.isLiteral()) {
            this.mAllLiterals.add(elem);
        }
        if (elem.isDependentNonFunctionApplication()) {
            for (ICongruenceClosureElement supp : elem.getSupportingNodes()) {
                this.mManager.addElement(this, supp, newEqualityTarget, true, true);
                this.mFaAuxData.addSupportingNode(supp, elem);
            }
        }
        if (!elem.isFunctionApplication()) {
            assert (this.mElementTVER.getRepresentative(elem) != null) : "this method assumes that elem has been added already";
            return;
        }
        if (remInfo == null) {
            this.mFaAuxData.addAfParent(elem.getAppliedFunction(), elem);
            this.mFaAuxData.addArgParent(elem.getArgument(), elem);
        } else {
            if (!remInfo.getAlreadyRemovedElements().contains(elem.getAppliedFunction())) {
                this.mFaAuxData.addAfParent(elem.getAppliedFunction(), elem);
            }
            if (!remInfo.getAlreadyRemovedElements().contains(elem.getArgument())) {
                this.mFaAuxData.addArgParent(elem.getArgument(), elem);
            }
        }
        HashRelation<ELEM, ELEM> equalitiesToPropagate = this.getAuxData().registerNewElement(elem);
        if (remInfo == null) {
            this.mManager.addElement(this, elem.getAppliedFunction(), newEqualityTarget, true, true);
            this.mManager.addElement(this, elem.getArgument(), newEqualityTarget, true, true);
        } else {
            if (!remInfo.getAlreadyRemovedElements().contains(elem.getAppliedFunction())) {
                this.mManager.addElement(this, (ICongruenceClosureElement)elem.getAppliedFunction(), newEqualityTarget, true, true);
            }
            if (!remInfo.getAlreadyRemovedElements().contains(elem.getArgument())) {
                this.mManager.addElement(this, (ICongruenceClosureElement)elem.getArgument(), newEqualityTarget, true, true);
            }
        }
        CongruenceClosure.constantFunctionTreatmentOnAddElement(elem, this.mElementTVER.getEquivalenceClass(elem.getAppliedFunction()), newEqualityTarget);
        CongruenceClosure.mixFunctionTreatmentOnAddElement(elem, (e, set) -> newEqualityTarget.reportContainsConstraint((ICongruenceClosureElement)e, (Set<ICongruenceClosureElement>)set), e -> {
            CongruenceClosure<ICongruenceClosureElement> congruenceClosure = this.mManager.addElement(this, (ICongruenceClosureElement)e, newEqualityTarget, true, true);
        }, this.mElementTVER.getEquivalenceClass(elem.getAppliedFunction()));
        if (remInfo == null) {
            for (Map.Entry eq : equalitiesToPropagate.getSetOfPairs()) {
                newEqualityTarget.reportEqualityRec((ICongruenceClosureElement)eq.getKey(), (ICongruenceClosureElement)eq.getValue());
                if (this.isInconsistent()) break;
            }
        }
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> void constantFunctionTreatmentOnAddElement(ELEM elem, Set<ELEM> weakOrStrongEquivalenceClassOfAppliedFunction, IEqualityReportingTarget<ELEM> newEqualityTarget) {
        if (elem.getAppliedFunction().isConstantFunction() && !newEqualityTarget.isInconsistent(false)) {
            newEqualityTarget.reportEqualityRec(elem, (ICongruenceClosureElement)elem.getAppliedFunction().getConstantFunctionValue());
        }
        for (ICongruenceClosureElement equivalentFunction : weakOrStrongEquivalenceClassOfAppliedFunction) {
            if (newEqualityTarget.isInconsistent(false)) {
                return;
            }
            if (equivalentFunction == elem.getAppliedFunction() || !equivalentFunction.isConstantFunction()) continue;
            newEqualityTarget.addElement(elem.replaceAppliedFunction((ICongruenceClosureElement)equivalentFunction), false);
        }
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> void mixFunctionTreatmentOnAddElement(ELEM elem, BiConsumer<ELEM, Set<ELEM>> reportContainsConstraint, Consumer<ELEM> addElement, Set<ELEM> weakOrStrongEquivalenceClassOfAppliedFunction) {
        if (elem.getAppliedFunction().isMixFunction()) {
            ELEM mixArray1 = elem.getAppliedFunction().getMixFunction1();
            ELEM mixArray2 = elem.getAppliedFunction().getMixFunction2();
            HashSet<ELEM> set = new HashSet<ELEM>();
            set.add(elem.replaceAppliedFunction(mixArray1));
            set.add(elem.replaceAppliedFunction(mixArray2));
            reportContainsConstraint.accept(elem, set);
        }
        for (ICongruenceClosureElement equivalentFunction : weakOrStrongEquivalenceClassOfAppliedFunction) {
            if (equivalentFunction == elem.getAppliedFunction() || !equivalentFunction.isMixFunction()) continue;
            addElement.accept(elem.replaceAppliedFunction((ICongruenceClosureElement)equivalentFunction));
        }
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> void constantAndMixFunctionTreatmentOnAddEquality(ELEM elemRep1, ELEM elemRep2, Set<ELEM> elem1EquivalenceClass, Set<ELEM> elem2EquivalenceClass, CcAuxData<ELEM> auxData, Consumer<ELEM> addElement, IEqualityReportingTarget<ELEM> congruenceClosure) {
        for (ICongruenceClosureElement equivalentFunction1 : new HashSet<ELEM>(elem1EquivalenceClass)) {
            if (!equivalentFunction1.isMixFunction() && !equivalentFunction1.isConstantFunction()) continue;
            for (ICongruenceClosureElement ccpar : auxData.getAfCcPars(elemRep2)) {
                if (congruenceClosure.isInconsistent(false)) {
                    return;
                }
                assert (!equivalentFunction1.equals(ccpar.getAppliedFunction()));
                addElement.accept(ccpar.replaceAppliedFunction(equivalentFunction1));
            }
        }
        for (ICongruenceClosureElement equivalentFunction2 : new HashSet<ELEM>(elem2EquivalenceClass)) {
            if (!equivalentFunction2.isMixFunction() && !equivalentFunction2.isConstantFunction()) continue;
            for (ICongruenceClosureElement ccpar : auxData.getAfCcPars(elemRep1)) {
                if (congruenceClosure.isInconsistent(false)) {
                    return;
                }
                assert (!equivalentFunction2.equals(ccpar.getAppliedFunction()));
                addElement.accept(ccpar.replaceAppliedFunction(equivalentFunction2));
            }
        }
    }

    public ELEM getRepresentativeElement(ELEM elem) {
        ICongruenceClosureElement result = (ICongruenceClosureElement)this.mElementTVER.getRepresentative(elem);
        if (result == null) {
            throw new IllegalArgumentException("Use this method only for elements that you know have been added already");
        }
        return (ELEM)result;
    }

    public Set<ELEM> collectElementsToRemove(ELEM elem) {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(this.mFaAuxData.getDependentsOf(elem));
        for (ICongruenceClosureElement dep : this.mFaAuxData.getDependentsOf(elem)) {
            result.addAll(this.collectTransitiveParents(dep));
        }
        result.addAll(this.collectTransitiveParents(elem));
        return result;
    }

    private Set<ELEM> collectTransitiveParents(ELEM elem) {
        HashSet<ICongruenceClosureElement> result = new HashSet<ICongruenceClosureElement>();
        ArrayDeque worklist = new ArrayDeque();
        worklist.add(elem);
        while (!worklist.isEmpty()) {
            ICongruenceClosureElement current = (ICongruenceClosureElement)worklist.pop();
            result.add(current);
            worklist.addAll(this.mFaAuxData.getAfParents(current));
            worklist.addAll(this.mFaAuxData.getArgParents(current));
        }
        return result;
    }

    public void removeElements(Set<ELEM> elementsToRemove, Map<ELEM, ELEM> nodeToReplacementNode) {
        assert (!this.mIsFrozen);
        for (ICongruenceClosureElement etr : elementsToRemove) {
            this.mFaAuxData.removeFromNodeToDependents(etr);
        }
        for (ICongruenceClosureElement etr : elementsToRemove) {
            if (!this.hasElement(etr)) continue;
            this.updateElementTverAndAuxDataOnRemoveElement(etr, (ICongruenceClosureElement)nodeToReplacementNode.get(etr));
        }
    }

    @Override
    public Set<ELEM> getNodesToIntroduceBeforeRemoval(ELEM elemToRemove, Set<ELEM> elementsToRemove, Map<ELEM, ELEM> elemToRemoveToReplacement) {
        assert (elementsToRemove.contains(elemToRemove));
        assert (elemToRemove.isFunctionApplication());
        boolean etrIsRemovedBecauseOfAf = elementsToRemove.contains(elemToRemove.getAppliedFunction());
        boolean etrIsRemovedBecauseOfArg = elementsToRemove.contains(elemToRemove.getArgument());
        if (etrIsRemovedBecauseOfAf && etrIsRemovedBecauseOfArg) {
            Object afReplacement = this.getOtherEquivalenceClassMember(elemToRemove.getAppliedFunction(), elementsToRemove);
            Object argReplacement = this.getOtherEquivalenceClassMember(elemToRemove.getArgument(), elementsToRemove);
            if (afReplacement != null && argReplacement != null) {
                Object afReplaced = elemToRemove.replaceAppliedFunction(afReplacement);
                Object afAndArgReplaced = afReplaced.replaceArgument(argReplacement);
                assert (!this.mElementCurrentlyBeingRemoved.getRemovedElements().contains(afAndArgReplaced));
                elemToRemoveToReplacement.put(elemToRemove, afAndArgReplaced);
                if (!this.hasElement(afAndArgReplaced)) {
                    assert (this.nodeToAddIsEquivalentToOriginal(afAndArgReplaced, elemToRemove));
                    return Collections.singleton(afAndArgReplaced);
                }
                return Collections.emptySet();
            }
        } else if (etrIsRemovedBecauseOfAf) {
            Object afReplacement = this.getOtherEquivalenceClassMember(elemToRemove.getAppliedFunction(), elementsToRemove);
            if (afReplacement != null) {
                Object afReplaced = elemToRemove.replaceAppliedFunction(afReplacement);
                assert (!this.mElementCurrentlyBeingRemoved.getRemovedElements().contains(afReplaced));
                elemToRemoveToReplacement.put(elemToRemove, afReplaced);
                if (!this.hasElement(afReplaced)) {
                    assert (this.nodeToAddIsEquivalentToOriginal(afReplaced, elemToRemove));
                    return Collections.singleton(afReplaced);
                }
                return Collections.emptySet();
            }
        } else {
            Object argReplacement = this.getOtherEquivalenceClassMember(elemToRemove.getArgument(), elementsToRemove);
            if (argReplacement != null) {
                Object argReplaced = elemToRemove.replaceArgument(argReplacement);
                assert (!this.mElementCurrentlyBeingRemoved.getRemovedElements().contains(argReplaced));
                elemToRemoveToReplacement.put(elemToRemove, argReplaced);
                if (!this.hasElement(argReplaced)) {
                    assert (this.nodeToAddIsEquivalentToOriginal(argReplaced, elemToRemove));
                    return Collections.singleton(argReplaced);
                }
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    private boolean nodeToAddIsEquivalentToOriginal(ELEM afAndArgReplaced, ELEM elemToRemove) {
        CongruenceClosure<ELEM> copy = this.mManager.copyNoRemInfoUnfrozen(this);
        this.mManager.addElement(copy, afAndArgReplaced, true, false);
        if (copy.getEqualityStatus(afAndArgReplaced, elemToRemove) != EqualityStatus.EQUAL) {
            assert (false);
            return false;
        }
        return true;
    }

    public ELEM getOtherEquivalenceClassMember(ELEM eqmember, Set<ELEM> forbiddenSet) {
        assert (this.hasElement(eqmember));
        Set<ELEM> eqc = this.mElementTVER.getEquivalenceClass(eqmember);
        if (eqc.size() == 1) {
            return null;
        }
        for (ICongruenceClosureElement e : eqc) {
            if (e.equals(eqmember) || forbiddenSet != null && forbiddenSet.contains(e)) continue;
            return (ELEM)e;
        }
        return null;
    }

    private ELEM updateElementTverAndAuxDataOnRemoveElement(ELEM elem, ELEM newRepChoice) {
        boolean elemWasRepresentative = this.mElementTVER.isRepresentative(elem);
        ICongruenceClosureElement newRep = (ICongruenceClosureElement)this.mElementTVER.removeElement(elem, newRepChoice);
        assert (this.mElementTVER.getRepresentative(newRep) == newRep);
        assert (!elemWasRepresentative || newRepChoice == null || newRep == newRepChoice);
        this.getAuxData().removeElement((ICongruenceClosureElement)elem, elemWasRepresentative, newRep);
        if (elem.isFunctionApplication()) {
            this.mFaAuxData.removeAfParent(elem.getAppliedFunction(), elem);
            this.mFaAuxData.removeArgParent(elem.getArgument(), elem);
        }
        if (elemWasRepresentative) {
            if (newRep == null) {
                this.mLiteralSetConstraints.projectAway(elem);
            } else {
                this.mLiteralSetConstraints.replaceRepresentative((ICongruenceClosureElement)elem, newRep);
            }
        }
        return (ELEM)newRep;
    }

    CongruenceClosure<ELEM> join(CongruenceClosure<ELEM> other) {
        assert (!(this.isInconsistent() || other.isInconsistent() || this.isTautological() || other.isTautological()));
        Pair<CongruenceClosure<ELEM>, CongruenceClosure<ELEM>> aligned = this.mManager.alignElements(this, other, !this.isFrozen() && !other.isFrozen());
        CongruenceClosure<ELEM> thisAligned = aligned.getFirst();
        CongruenceClosure<ELEM> otherAligned = aligned.getSecond();
        Triple<UnionFind<ELEM>, HashRelation<ELEM, ELEM>, HashRelation<ELEM, ELEM>> joinRes = thisAligned.mElementTVER.joinPartitions(otherAligned.mElementTVER);
        UnionFind<ELEM> newPartition = joinRes.getFirst();
        HashRelation<ELEM, ELEM> thisSplitInfo = joinRes.getSecond();
        HashRelation<ELEM, ELEM> otherSplitInfo = joinRes.getThird();
        HashRelation<ELEM, ELEM> newDisequalities = CongruenceClosure.intersectOrUnionDisequalities(thisAligned, otherAligned, newPartition, true);
        ThreeValuedEquivalenceRelation<ELEM> newElemTver = new ThreeValuedEquivalenceRelation<ELEM>(newPartition, newDisequalities);
        assert (CcManager.isPartitionStronger(thisAligned.mElementTVER, newElemTver));
        assert (CcManager.isPartitionStronger(otherAligned.mElementTVER, newElemTver));
        CongruenceClosure<ELEM> newCc = this.mManager.getCongruenceClosureFromTver(newElemTver, true);
        assert (CcManager.isPartitionStronger(thisAligned.mElementTVER, newCc.mElementTVER));
        assert (CcManager.isPartitionStronger(otherAligned.mElementTVER, newCc.mElementTVER));
        CCLiteralSetConstraints<ELEM> newLiteralSetConstraints = this.mLiteralSetConstraints.join(newCc, thisSplitInfo, otherSplitInfo, other.mLiteralSetConstraints);
        newCc.resetCcLiteralSetConstraints(newLiteralSetConstraints);
        return newCc;
    }

    private void resetCcLiteralSetConstraints(CCLiteralSetConstraints<ELEM> newLiteralSetConstraints) {
        assert (newLiteralSetConstraints.getCongruenceClosure() == this);
        this.mLiteralSetConstraints = newLiteralSetConstraints;
    }

    private static <E extends ICongruenceClosureElement<E>> HashRelation<E, E> intersectOrUnionDisequalities(CongruenceClosure<E> tver1, CongruenceClosure<E> tver2, UnionFind<E> newElemPartition, boolean intersect) {
        HashRelation<ICongruenceClosureElement, ICongruenceClosureElement> result = new HashRelation<ICongruenceClosureElement, ICongruenceClosureElement>();
        BiPredicate<ICongruenceClosureElement, ICongruenceClosureElement> filterForCrossProduct = (e1, e2) -> e1 != e2 && (!e1.isLiteral() || !e2.isLiteral()) && e1.hasSameTypeAs(e2);
        for (Map.Entry pair : CrossProducts.binarySelectiveCrossProduct(newElemPartition.getAllRepresentatives(), false, filterForCrossProduct)) {
            boolean addDisequality;
            assert (!((ICongruenceClosureElement)pair.getKey()).isLiteral() || !((ICongruenceClosureElement)pair.getValue()).isLiteral()) : "disequalities between literals are implicit, the selective cross product should have filtered these cases";
            if (intersect) {
                addDisequality = tver1.getEqualityStatus((ICongruenceClosureElement)pair.getKey(), (ICongruenceClosureElement)pair.getValue()) == EqualityStatus.NOT_EQUAL && tver2.getEqualityStatus((ICongruenceClosureElement)pair.getKey(), (ICongruenceClosureElement)pair.getValue()) == EqualityStatus.NOT_EQUAL;
            } else {
                boolean bl = addDisequality = tver1.getEqualityStatus((ICongruenceClosureElement)pair.getKey(), (ICongruenceClosureElement)pair.getValue()) == EqualityStatus.NOT_EQUAL || tver2.getEqualityStatus((ICongruenceClosureElement)pair.getKey(), (ICongruenceClosureElement)pair.getValue()) == EqualityStatus.NOT_EQUAL;
            }
            if (!addDisequality) continue;
            result.addPair((ICongruenceClosureElement)pair.getKey(), (ICongruenceClosureElement)pair.getValue());
        }
        return result;
    }

    public CongruenceClosure<ELEM> meetRec(CongruenceClosure<ELEM> other, IRemovalInfo<ELEM> remInfo, boolean inplace) {
        assert (!this.isInconsistent());
        assert (!other.isInconsistent() || inplace);
        CongruenceClosure<Object> thisAligned = this.mManager.addAllElements(this, other.getAllElements(), remInfo, inplace);
        for (Map.Entry<ELEM, ELEM> entry : other.getSupportingElementEqualities().entrySet()) {
            if (thisAligned.isInconsistent()) {
                if (inplace) {
                    return thisAligned;
                }
                return this.mManager.getInconsistentCc();
            }
            thisAligned = this.mManager.reportEquality((ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue(), thisAligned, inplace);
        }
        for (Map.Entry<Object, Object> entry : other.getElementDisequalities()) {
            if (thisAligned.isInconsistent()) {
                if (inplace) {
                    return thisAligned;
                }
                return this.mManager.getInconsistentCc();
            }
            thisAligned = this.mManager.reportDisequality((ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue(), thisAligned, inplace);
        }
        for (Map.Entry<Object, Object> entry : other.getLiteralSetConstraints().getConstraints().entrySet()) {
            if (thisAligned.isInconsistent()) {
                if (inplace) {
                    return thisAligned;
                }
                return this.mManager.getInconsistentCc();
            }
            thisAligned = this.mManager.reportContainsConstraint((Object)((ICongruenceClosureElement)entry.getKey()), ((SetConstraintConjunction)entry.getValue()).getSetConstraints(), thisAligned, inplace);
        }
        return thisAligned;
    }

    public CongruenceClosure<ELEM> meetRec(CongruenceClosure<ELEM> other, boolean inplace) {
        return this.meetRec(other, null, inplace);
    }

    public boolean isStrongerThanNoCaching(CongruenceClosure<ELEM> other) {
        if (this.isInconsistent()) {
            return true;
        }
        return this.mManager.isStrongerThanNoCaching(this, other);
    }

    public EqualityStatus getEqualityStatus(ELEM elem1, ELEM elem2) {
        ELEM rep2;
        assert (this.hasElement(elem1) && this.hasElement(elem2));
        assert (!this.isInconsistent()) : "catch this outside!";
        this.mManager.bmStart(CcManager.CcBmNames.GET_EQUALITY_STATUS);
        if (!elem1.hasSameTypeAs(elem2)) {
            this.mManager.bmEnd(CcManager.CcBmNames.GET_EQUALITY_STATUS);
            return EqualityStatus.NOT_EQUAL;
        }
        ELEM rep1 = this.getRepresentativeElement(elem1);
        if (rep1.equals(rep2 = this.getRepresentativeElement(elem2))) {
            this.mManager.bmEnd(CcManager.CcBmNames.GET_EQUALITY_STATUS);
            return EqualityStatus.EQUAL;
        }
        if (rep1.isLiteral() && rep2.isLiteral()) {
            this.mManager.bmEnd(CcManager.CcBmNames.GET_EQUALITY_STATUS);
            return EqualityStatus.NOT_EQUAL;
        }
        Set<SetConstraint<ELEM>> litConstraint1 = this.mLiteralSetConstraints.getConstraint(rep1);
        Set<SetConstraint<ELEM>> litConstraint2 = this.mLiteralSetConstraints.getConstraint(rep2);
        if (this.mManager.getSetConstraintManager().meetIsInconsistent(this.getLiteralSetConstraints(), litConstraint1, litConstraint2)) {
            this.mManager.bmEnd(CcManager.CcBmNames.GET_EQUALITY_STATUS);
            return EqualityStatus.NOT_EQUAL;
        }
        EqualityStatus result = this.mElementTVER.getEqualityStatus(elem1, elem2);
        this.mManager.bmEnd(CcManager.CcBmNames.GET_EQUALITY_STATUS);
        return result;
    }

    public Set<ELEM> getAllElements() {
        return Collections.unmodifiableSet(this.mElementTVER.getAllElements());
    }

    public CCLiteralSetConstraints<ELEM> getLiteralSetConstraints() {
        return this.mLiteralSetConstraints;
    }

    @Override
    public boolean isInconsistent() {
        return this.mElementTVER == null || this.mElementTVER.isInconsistent() || this.mLiteralSetConstraints.isInconsistent();
    }

    @Override
    public boolean isInconsistent(boolean close) {
        return this.isInconsistent();
    }

    private boolean assertNoElementsFromRemInfoInLitSetConstraints(CCLiteralSetConstraints<ELEM> literalConstraints, IRemovalInfo<ELEM> remInfo) {
        if (remInfo == null) {
            return true;
        }
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> en : literalConstraints.getConstraints().entrySet()) {
            if (CongruenceClosure.dependsOnAny((ICongruenceClosureElement)en.getKey(), remInfo.getRemovedElements())) {
                return false;
            }
            if (CongruenceClosure.dependsOnAny(en.getValue().getConstrainedElement(), remInfo.getRemovedElements())) {
                return false;
            }
            for (ICongruenceClosureElement el : en.getValue().getAllRhsElements()) {
                if (!CongruenceClosure.dependsOnAny(el, remInfo.getRemovedElements())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean assertNoElementsFromRemInfoInTver(ThreeValuedEquivalenceRelation<ELEM> newElemPartition, IRemovalInfo<ELEM> remInfo) {
        if (remInfo == null) {
            return true;
        }
        for (ICongruenceClosureElement elem : newElemPartition.getAllElements()) {
            if (!CongruenceClosure.dependsOnAny(elem, remInfo.getRemovedElements())) continue;
            return false;
        }
        return true;
    }

    private boolean assertElementsAreSuperset(Set<ELEM> a, Set<ELEM> b) {
        Set<ELEM> difference = DataStructureUtils.difference(b, a);
        if (!difference.isEmpty()) {
            assert (false);
            return false;
        }
        return true;
    }

    boolean assertElementsAreSuperset(CongruenceClosure<ELEM> a, CongruenceClosure<ELEM> b) {
        Set<ELEM> difference = DataStructureUtils.difference(b.getAllElements(), a.getAllElements());
        if (!difference.isEmpty()) {
            assert (false);
            return false;
        }
        return true;
    }

    public boolean assertAtMostOneLiteralPerEquivalenceClass() {
        if (this.isInconsistent()) {
            return true;
        }
        for (Set<ELEM> eqc : this.mElementTVER.getAllEquivalenceClasses()) {
            assert (eqc.stream().filter(e -> e.isLiteral()).collect(Collectors.toList()).size() < 2);
        }
        return true;
    }

    public boolean assertSimpleElementIsFullyRemoved(ELEM elem) {
        Set<ELEM> transitiveParents = this.collectElementsToRemove(elem);
        for (ICongruenceClosureElement e : this.getAllElements()) {
            if (!transitiveParents.contains(e)) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public boolean assertSingleElementIsFullyRemoved(ELEM elem) {
        for (Map.Entry en : this.mFaAuxData.getNodeToDependentPairs()) {
            if (!((ICongruenceClosureElement)en.getKey()).equals(elem) && !((ICongruenceClosureElement)en.getValue()).equals(elem)) continue;
            assert (false);
            return false;
        }
        return this.assertElementIsFullyRemovedOnlyCc(elem);
    }

    protected boolean assertElementIsFullyRemovedOnlyCc(ELEM elem) {
        if (this.mElementTVER.getRepresentative(elem) != null) {
            assert (false);
            return false;
        }
        return true;
    }

    public boolean assertHasOnlyWeqVarConstraints(Set<ELEM> allWeqNodes) {
        if (this.isTautological()) {
            return true;
        }
        if (allWeqNodes.isEmpty()) {
            return true;
        }
        HashSet<ICongruenceClosureElement> elemsAppearingInADisequality = new HashSet<ICongruenceClosureElement>();
        for (Map.Entry entry : this.mElementTVER.getDisequalities().getSetOfPairs()) {
            elemsAppearingInADisequality.add((ICongruenceClosureElement)entry.getKey());
            elemsAppearingInADisequality.add((ICongruenceClosureElement)entry.getValue());
        }
        for (Set set : this.mElementTVER.getAllEquivalenceClasses()) {
            if (set.size() == 1) continue;
            Set intersection1 = set.stream().filter(eqcelem -> CongruenceClosure.dependsOnAny(eqcelem, allWeqNodes)).collect(Collectors.toSet());
            Set intersection2 = DataStructureUtils.intersection(set, elemsAppearingInADisequality);
            if (!intersection1.isEmpty() || !intersection2.isEmpty()) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public boolean assertHasExternalRemInfo() {
        return this.mExternalRemovalInfo != null;
    }

    @Override
    public boolean sanityCheck() {
        return this.sanityCheck(null);
    }

    public boolean sanityCheck(IRemovalInfo<ELEM> remInfo) {
        return this.sanityCheckOnlyCc(remInfo);
    }

    public boolean sanityCheckOnlyCc() {
        return this.sanityCheckOnlyCc(null);
    }

    public boolean sanityCheckOnlyCc(IRemovalInfo<ELEM> remInfo) {
        if (this.mConstructorInitializationPhase) {
            return true;
        }
        if (this.isInconsistent()) {
            if (this.mElementTVER != null && !this.mElementTVER.isInconsistent() && !this.mLiteralSetConstraints.isInconsistent()) {
                assert (false) : "cc reports as inconsistent, but why?..";
                return false;
            }
            return true;
        }
        if (!this.mElementTVER.sanityCheck()) {
            assert (false);
            return false;
        }
        if (this.mElementTVER.isInconsistent()) {
            assert (false) : "Cc is inconsistent but fields are not null";
            return false;
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : this.getAllRepresentatives()) {
            for (ICongruenceClosureElement iCongruenceClosureElement2 : this.getAuxData().getAfCcPars(iCongruenceClosureElement)) {
                if (iCongruenceClosureElement2.isFunctionApplication()) continue;
                assert (false) : "ccpar is not a funcapp";
                return false;
            }
            for (ICongruenceClosureElement iCongruenceClosureElement3 : this.getAuxData().getArgCcPars(iCongruenceClosureElement)) {
                if (iCongruenceClosureElement3.isFunctionApplication()) continue;
                assert (false) : "ccpar is not a funcapp";
                return false;
            }
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : this.getAllElements()) {
            if (!iCongruenceClosureElement.isFunctionApplication()) continue;
            if (!(this.hasElement(iCongruenceClosureElement.getAppliedFunction()) || remInfo != null && remInfo.getRemovedElements().contains(iCongruenceClosureElement.getAppliedFunction()) || this.mElementCurrentlyBeingRemoved != null && this.mElementCurrentlyBeingRemoved.getRemovedElements().contains(iCongruenceClosureElement.getAppliedFunction()) || this.mExternalRemovalInfo != null && this.mExternalRemovalInfo.getRemovedElements().contains(iCongruenceClosureElement.getAppliedFunction()))) {
                assert (false);
                return false;
            }
            if (this.hasElement(iCongruenceClosureElement.getArgument()) || remInfo != null && remInfo.getRemovedElements().contains(iCongruenceClosureElement.getArgument()) || this.mElementCurrentlyBeingRemoved != null && this.mElementCurrentlyBeingRemoved.getRemovedElements().contains(iCongruenceClosureElement.getArgument()) || this.mExternalRemovalInfo != null && this.mExternalRemovalInfo.getRemovedElements().contains(iCongruenceClosureElement.getArgument())) continue;
            assert (false);
            return false;
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : this.getAllElements()) {
            if (!iCongruenceClosureElement.isFunctionApplication()) continue;
            ICongruenceClosureElement iCongruenceClosureElement4 = this.getRepresentativeElement(iCongruenceClosureElement);
            if (this.getAuxData().getCcChildren(iCongruenceClosureElement4).containsPair((ICongruenceClosureElement)iCongruenceClosureElement.getAppliedFunction(), (ICongruenceClosureElement)iCongruenceClosureElement.getArgument())) continue;
            assert (false) : "ccchild store incomplete";
            return false;
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : this.getAllElements()) {
            if (!iCongruenceClosureElement.isLiteral() || this.mAllLiterals.contains(iCongruenceClosureElement)) continue;
            assert (false) : "all literals store incomplete";
            return false;
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : this.mAllLiterals) {
            if (iCongruenceClosureElement.isLiteral()) continue;
            assert (false) : "non-literal in all literals store";
            return false;
        }
        for (Set set : this.mElementTVER.getAllEquivalenceClasses()) {
            for (ICongruenceClosureElement<Object> iCongruenceClosureElement : set) {
                if (!iCongruenceClosureElement.isLiteral() || this.isRepresentative(iCongruenceClosureElement)) continue;
                assert (false) : "literal is not the representative of its eq class";
                return false;
            }
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : this.getAllElements()) {
            HashSet hashSet = new HashSet();
            HashSet argCcparFromDirectParents = new HashSet();
            for (ICongruenceClosureElement eqcMember : this.mElementTVER.getEquivalenceClass(iCongruenceClosureElement)) {
                hashSet.addAll(this.mFaAuxData.getAfParents(eqcMember));
                argCcparFromDirectParents.addAll(this.mFaAuxData.getArgParents(eqcMember));
            }
            ICongruenceClosureElement rep = this.getRepresentativeElement(iCongruenceClosureElement);
            if (!hashSet.equals(this.getAuxData().getAfCcPars(rep))) {
                DataStructureUtils.difference(hashSet, new HashSet<ICongruenceClosureElement>(this.getAuxData().getAfCcPars(rep)));
                DataStructureUtils.difference(new HashSet<ICongruenceClosureElement>(this.getAuxData().getAfCcPars(rep)), hashSet);
                assert (false) : "funcAppTreeAuxData and ccAuxData don't agree (Af case)";
                return false;
            }
            if (argCcparFromDirectParents.equals(this.getAuxData().getArgCcPars(rep))) continue;
            DataStructureUtils.difference(argCcparFromDirectParents, new HashSet<ICongruenceClosureElement>(this.getAuxData().getArgCcPars(rep)));
            DataStructureUtils.difference(new HashSet<ICongruenceClosureElement>(this.getAuxData().getArgCcPars(rep)), argCcparFromDirectParents);
            assert (false) : "funcAppTreeAuxData and ccAuxData don't agree (Arg case)";
            return false;
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : this.getAllElements()) {
            for (ICongruenceClosureElement<Object> iCongruenceClosureElement5 : this.mElementTVER.getEquivalenceClass(iCongruenceClosureElement)) {
                if (iCongruenceClosureElement.hasSameTypeAs(iCongruenceClosureElement5)) continue;
                assert (false) : "elements of incompatible type are in same eq class";
                return false;
            }
        }
        for (Map.Entry entry : this.mElementTVER.getDisequalities()) {
            if (((ICongruenceClosureElement)entry.getKey()).hasSameTypeAs((ICongruenceClosureElement)entry.getValue())) continue;
            assert (false) : "stored disequality between elements of incompatible type";
            return false;
        }
        if (!this.assertNoExplicitLiteralDisequalities()) {
            assert (false);
            return false;
        }
        if (!this.mLiteralSetConstraints.sanityCheck()) {
            assert (false);
            return false;
        }
        return true;
    }

    private boolean assertNoExplicitLiteralDisequalities() {
        for (Map.Entry deq : this.mElementTVER.getDisequalities()) {
            if (!((ICongruenceClosureElement)deq.getKey()).isLiteral() || !((ICongruenceClosureElement)deq.getValue()).isLiteral()) continue;
            assert (false) : "explicit disequality between literals";
            return false;
        }
        return true;
    }

    public Map<ELEM, ELEM> getSupportingElementEqualities() {
        return this.mElementTVER.getSupportingEqualities();
    }

    public HashRelation<ELEM, ELEM> getElementDisequalities() {
        return this.mElementTVER.getDisequalities();
    }

    Map<String, Integer> summarize() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("#Elements", this.getAllElements().size());
        result.put("#EquivalenceClasses", this.getAllRepresentatives().size());
        result.put("#SupportingEqualties", this.getSupportingElementEqualities().size());
        result.put("#SupportingDisequalties", this.getElementDisequalities().size());
        return result;
    }

    public String toString() {
        if (this.isTautological()) {
            return "True";
        }
        if (this.isInconsistent()) {
            return "False";
        }
        if (this.getAllElements().size() < 30) {
            return this.toLogString();
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> en : this.summarize().entrySet()) {
            sb.append(String.format("%s : %d\n", en.getKey(), en.getValue()));
        }
        return sb.toString();
    }

    @Override
    public String toLogString() {
        if (this.isTautological()) {
            return "True";
        }
        if (this.isInconsistent()) {
            return "False";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("--CC(begin):--\n");
        sb.append("Equivalences:\n");
        for (Set<ELEM> set : this.mElementTVER.getAllEquivalenceClasses()) {
            sb.append(set);
            if (set.size() > 1) {
                sb.append(" --- rep: ");
                sb.append(this.mElementTVER.getRepresentative((ICongruenceClosureElement)set.iterator().next()));
            }
            sb.append("\n");
        }
        sb.append("Disequalities:\n");
        for (Map.Entry entry : this.mElementTVER.getDisequalities()) {
            sb.append(entry.getKey());
            sb.append(" != ");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        sb.append(this.mLiteralSetConstraints.toString());
        sb.append("--CC(end):--\n");
        return sb.toString();
    }

    static <E> boolean haveSameElements(ThreeValuedEquivalenceRelation<E> tver1, ThreeValuedEquivalenceRelation<E> tver2) {
        return tver1.getAllElements().equals(tver2.getAllElements());
    }

    public boolean isTautological() {
        if (this.isInconsistent()) {
            return false;
        }
        return this.mElementTVER.isTautological() && this.mLiteralSetConstraints.isEmpty();
    }

    public void transformElementsAndFunctions(Function<ELEM, ELEM> elemTransformer) {
        assert (!this.mIsFrozen);
        this.mElementTVER.transformElements(elemTransformer);
        this.getAuxData().transformElements(elemTransformer);
        this.mFaAuxData.transformElements(elemTransformer);
        this.mLiteralSetConstraints.transformElements(elemTransformer);
    }

    private static <E> boolean sanitizeTransformer(Function<E, E> elemTransformer, Set<E> inputSet) {
        for (E el : inputSet) {
            E transformed;
            if (el.equals(transformed = elemTransformer.apply(el)) || !inputSet.contains(transformed)) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public boolean hasElements(ELEM ... elems) {
        ELEM[] ELEMArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            ELEM e = ELEMArray[n2];
            if (!this.hasElement(e)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean hasElement(ELEM elem) {
        return this.getAllElements().contains(elem);
    }

    @Override
    public boolean isConstrained(ELEM elem) {
        if (!this.hasElement(elem)) {
            return false;
        }
        if (this.isConstrainedDirectly(elem)) {
            return true;
        }
        if (elem.isDependentNonFunctionApplication()) {
            for (ICongruenceClosureElement supp : elem.getSupportingNodes()) {
                if (!this.isConstrained(supp)) continue;
                return true;
            }
        }
        for (ICongruenceClosureElement afpar : this.mFaAuxData.getAfParents(elem)) {
            if (!this.isConstrained(afpar)) continue;
            return true;
        }
        for (ICongruenceClosureElement argpar : this.mFaAuxData.getArgParents(elem)) {
            if (!this.isConstrained(argpar)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConstrainedDirectly(ELEM elem) {
        if (!this.hasElement(elem)) {
            return false;
        }
        if (this.mElementTVER.isConstrained(elem)) {
            return true;
        }
        return this.mLiteralSetConstraints.isConstrained(elem);
    }

    CongruenceClosure<ELEM> projectToElements(Set<ELEM> elemsToKeep, IRemovalInfo<ELEM> removeElementInfo) {
        assert (!this.mIsFrozen);
        if (this.isInconsistent()) {
            return this;
        }
        CongruenceClosure<ICongruenceClosureElement> copy = this.mManager.getCopyWithRemovalInfo(this, removeElementInfo);
        HashSet<ELEM> worklist = new HashSet<ELEM>(elemsToKeep);
        HashSet<ICongruenceClosureElement> elemsInConstraintsToKeep = new HashSet<ICongruenceClosureElement>();
        HashSet<ICongruenceClosureElement> visitedEquivalenceClassElements = new HashSet<ICongruenceClosureElement>();
        while (!worklist.isEmpty()) {
            ICongruenceClosureElement substituted;
            ICongruenceClosureElement current = (ICongruenceClosureElement)worklist.iterator().next();
            worklist.remove(current);
            if (!copy.hasElement(current)) continue;
            visitedEquivalenceClassElements.addAll(copy.mElementTVER.getEquivalenceClass(current));
            elemsInConstraintsToKeep.add(current);
            for (ICongruenceClosureElement afccpar : new HashSet<ICongruenceClosureElement>(copy.getAuxData().getAfCcPars(copy.getRepresentativeElement(current)))) {
                if (visitedEquivalenceClassElements.contains(afccpar) || elemsInConstraintsToKeep.contains(substituted = afccpar.replaceAppliedFunction(current)) || removeElementInfo != null && CongruenceClosure.dependsOnAny(substituted, removeElementInfo.getRemovedElements())) continue;
                assert (removeElementInfo == null || !CongruenceClosure.dependsOnAny(substituted, removeElementInfo.getRemovedElements()));
                this.mManager.addElement(copy, substituted, true, false);
                worklist.add(substituted);
            }
            for (ICongruenceClosureElement argccpar : new HashSet<ICongruenceClosureElement>(copy.getAuxData().getArgCcPars(copy.getRepresentativeElement(current)))) {
                if (visitedEquivalenceClassElements.contains(argccpar) || elemsInConstraintsToKeep.contains(substituted = argccpar.replaceArgument(current)) || removeElementInfo != null && CongruenceClosure.dependsOnAny(substituted, removeElementInfo.getRemovedElements())) continue;
                assert (removeElementInfo == null || !CongruenceClosure.dependsOnAny(substituted, removeElementInfo.getRemovedElements()));
                this.mManager.addElement(copy, substituted, true, false);
                worklist.add(substituted);
            }
            for (ICongruenceClosureElement relEl : copy.getLiteralSetConstraints().getRelatedElements(copy.getRepresentativeElement(current))) {
                if (visitedEquivalenceClassElements.contains(relEl) || elemsInConstraintsToKeep.contains(relEl) || removeElementInfo != null && CongruenceClosure.dependsOnAny(relEl, removeElementInfo.getRemovedElements())) continue;
                assert (removeElementInfo == null || !CongruenceClosure.dependsOnAny(relEl, removeElementInfo.getRemovedElements()));
                this.mManager.addElement(copy, relEl, true, false);
                worklist.add(relEl);
            }
        }
        ThreeValuedEquivalenceRelation<ELEM> newTver = copy.mElementTVER.filterAndKeepOnlyConstraintsThatIntersectWith(elemsInConstraintsToKeep);
        assert (this.assertNoNewElementsIntroduced(this.getAllElements(), newTver.getAllElements(), elemsToKeep)) : "no elements may have been introduced that were not present before this operation";
        CCLiteralSetConstraints<ELEM> newLiteralSetConstraints = copy.mLiteralSetConstraints.filterAndKeepOnlyConstraintsThatIntersectWith(elemsInConstraintsToKeep);
        for (ICongruenceClosureElement elem : newLiteralSetConstraints.getAllElementsMentionedInASetConstraint()) {
            newTver.addElement(elem);
        }
        CongruenceClosure<ELEM> result = this.mManager.getCongruenceClosureFromTver(newTver, removeElementInfo, newLiteralSetConstraints, true);
        assert (this.assertNoNewElementsIntroduced(this.getAllElements(), result.getAllElements(), elemsToKeep)) : "no elements may have been introduced that were not present before this operation";
        assert (!result.isInconsistent()) : "cannot go from a consistent input to an inconsisten output during projectTo";
        return result;
    }

    public boolean assertNoNewElementsIntroduced(Set<ELEM> oldElems, Set<ELEM> newElems, Set<ELEM> elemsToKeep) {
        Set<ICongruenceClosureElement> diff = DataStructureUtils.difference(newElems, oldElems);
        for (ICongruenceClosureElement d : diff) {
            if (CongruenceClosure.dependsOnAny(d, elemsToKeep)) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public Collection<ELEM> getAllRepresentatives() {
        return this.mElementTVER.getAllRepresentatives();
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> boolean dependsOnAny(ELEM elem, Set<ELEM> sub) {
        if (sub.contains(elem)) {
            return true;
        }
        if (elem.isDependentNonFunctionApplication() && DataStructureUtils.haveNonEmptyIntersection(elem.getSupportingNodes(), sub)) {
            return true;
        }
        if (elem.isFunctionApplication()) {
            return CongruenceClosure.dependsOnAny(elem.getAppliedFunction(), sub) || CongruenceClosure.dependsOnAny(elem.getArgument(), sub);
        }
        return false;
    }

    public IRemovalInfo<ELEM> getElementCurrentlyBeingRemoved() {
        return this.mElementCurrentlyBeingRemoved;
    }

    public void setExternalRemInfo(IRemovalInfo<ELEM> remInfo) {
        assert (this.mExternalRemovalInfo == null || this.mExternalRemovalInfo == remInfo);
        this.mExternalRemovalInfo = remInfo;
    }

    public boolean isRepresentative(ELEM elem) {
        return this.mElementTVER.isRepresentative(elem);
    }

    public CcAuxData<ELEM> getAuxData() {
        return this.mAuxData;
    }

    public void reportEqualityToElementTVER(ELEM node1, ELEM node2) {
        this.mElementTVER.reportEquality(node1, node2);
    }

    public boolean isElementTverInconsistent() {
        return this.mElementTVER.isInconsistent();
    }

    public void reportDisequalityToElementTver(ELEM node1, ELEM node2) {
        this.mElementTVER.reportDisequality(node1, node2);
    }

    public Collection<ELEM> getArgCcPars(ELEM elem) {
        return this.mAuxData.getArgCcPars(elem);
    }

    public Collection<ELEM> getFuncAppsWithFunc(ELEM func) {
        return this.mFaAuxData.getAfParents(func);
    }

    public void setElementCurrentlyBeingRemoved(IRemovalInfo<ELEM> re) {
        assert (re == null || this.mElementCurrentlyBeingRemoved == null);
        this.mElementCurrentlyBeingRemoved = re;
    }

    @Override
    public boolean isDebugMode() {
        return this.mManager.isDebugMode();
    }

    @Override
    public ILogger getLogger() {
        return this.mManager.getLogger();
    }

    public Set<ELEM> getEquivalenceClass(ELEM elem) {
        return Collections.unmodifiableSet(this.mElementTVER.getEquivalenceClass(elem));
    }

    public Set<ELEM> getAllLiterals() {
        return Collections.unmodifiableSet(this.mAllLiterals);
    }

    public CcManager<ELEM> getManager() {
        return this.mManager;
    }

    @Override
    public void reportContainsConstraint(ELEM elem, Set<ELEM> literalSet) {
        HashRelation<ELEM, ELEM> eqToProp = this.mLiteralSetConstraints.reportContains(elem, (Collection<ELEM>)literalSet);
        if (eqToProp != null) {
            for (Map.Entry en : eqToProp) {
                this.mManager.reportEquality((ICongruenceClosureElement)en.getKey(), (ICongruenceClosureElement)en.getValue(), this, true);
            }
        }
    }

    @Override
    public void reportContainsConstraint(ELEM elem, Collection<SetConstraint<ELEM>> setCc) {
        HashRelation<ELEM, ELEM> eqToProp = this.mLiteralSetConstraints.reportContains(elem, (Set<SetConstraint<ELEM>>)new HashSet<SetConstraint<ELEM>>(setCc));
        if (eqToProp != null) {
            for (Map.Entry en : eqToProp) {
                this.mManager.reportEquality((ICongruenceClosureElement)en.getKey(), (ICongruenceClosureElement)en.getValue(), this, true);
            }
        }
    }

    public Set<SetConstraint<ELEM>> getContainsConstraintForElement(ELEM elem) {
        Set<SetConstraint<ELEM>> constraint = this.mLiteralSetConstraints.getConstraint(elem);
        if (SetConstraintManager.isTautologicalWrtElement(elem, constraint)) {
            return null;
        }
        return constraint;
    }

    protected class FuncAppTreeAuxData {
        private final HashRelation<ELEM, ELEM> mDirectAfPars;
        private final HashRelation<ELEM, ELEM> mDirectArgPars;
        private final HashRelation<ELEM, ELEM> mNodeToDependents;

        FuncAppTreeAuxData() {
            this.mDirectAfPars = new HashRelation();
            this.mDirectArgPars = new HashRelation();
            this.mNodeToDependents = new HashRelation();
        }

        FuncAppTreeAuxData(FuncAppTreeAuxData faAuxData) {
            this.mDirectAfPars = new HashRelation(faAuxData.mDirectAfPars);
            this.mDirectArgPars = new HashRelation(faAuxData.mDirectArgPars);
            this.mNodeToDependents = new HashRelation(faAuxData.mNodeToDependents);
        }

        public void addSupportingNode(ELEM supp, ELEM elem) {
            this.mNodeToDependents.addPair(supp, elem);
        }

        public void addAfParent(ELEM elem, ELEM parent) {
            this.mDirectAfPars.addPair(elem, parent);
        }

        public void addArgParent(ELEM elem, ELEM parent) {
            this.mDirectArgPars.addPair(elem, parent);
        }

        public Set<ELEM> getAfParents(ELEM elem) {
            return Collections.unmodifiableSet(this.mDirectAfPars.getImage(elem));
        }

        public Set<ELEM> getArgParents(ELEM elem) {
            return Collections.unmodifiableSet(this.mDirectArgPars.getImage(elem));
        }

        public void removeAfParent(ELEM elem, ELEM parent) {
            this.mDirectAfPars.removePair(elem, parent);
        }

        public void removeArgParent(ELEM elem, ELEM parent) {
            this.mDirectArgPars.removePair(elem, parent);
        }

        public void transformElements(Function<ELEM, ELEM> elemTransformer) {
            this.mDirectAfPars.transformElements(elemTransformer, elemTransformer);
            this.mDirectArgPars.transformElements(elemTransformer, elemTransformer);
            for (Map.Entry en : new HashRelation(this.mNodeToDependents).getSetOfPairs()) {
                this.mNodeToDependents.removePair((ICongruenceClosureElement)en.getKey(), (ICongruenceClosureElement)en.getValue());
                this.mNodeToDependents.addPair((ICongruenceClosureElement)elemTransformer.apply((ICongruenceClosureElement)en.getKey()), (ICongruenceClosureElement)elemTransformer.apply((ICongruenceClosureElement)en.getValue()));
            }
        }

        public Set<Map.Entry<ELEM, ELEM>> getNodeToDependentPairs() {
            return this.mNodeToDependents.getSetOfPairs();
        }

        public Set<ELEM> getDependentsOf(ELEM elem) {
            return this.mNodeToDependents.getImage(elem);
        }

        public void removeFromNodeToDependents(ELEM etr) {
            if (etr.isDependentNonFunctionApplication()) {
                this.mNodeToDependents.removeRangeElement(etr);
            }
            this.mNodeToDependents.removeDomainElement(etr);
        }
    }
}

