/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IElementRemovalTarget;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IRemovalInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IRestoreNodesBeforeRemove;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RemoveCcElement<ELEM extends ICongruenceClosureElement<ELEM>>
implements IRemovalInfo<ELEM>,
IRestoreNodesBeforeRemove<ELEM> {
    private final ELEM mElem;
    private final boolean mIntroduceNewNodes;
    private final boolean mMadeChanges;
    private Set<ELEM> mElementsToRemove;
    private final Set<ELEM> mElementsAlreadyRemoved = new HashSet<ELEM>();
    private final Set<ELEM> mAddedNodes;
    private boolean mDidRemoval = false;
    private CongruenceClosure<ELEM> mElementContainer;

    public RemoveCcElement(CongruenceClosure<ELEM> elementContainer, ELEM elem, boolean introduceNewNodes, boolean useWeqGpa) {
        assert (!elem.isFunctionApplication()) : "unexpected..";
        if (elementContainer.isInconsistent()) {
            throw new IllegalStateException();
        }
        if (elementContainer.isDebugMode()) {
            elementContainer.getLogger().debug((Object)("RemoveElement CC " + this.hashCode() + " : removing " + elem + " from " + elementContainer.hashCode()));
        }
        if (!elementContainer.hasElement(elem)) {
            this.mElem = null;
            this.mMadeChanges = false;
            this.mAddedNodes = Collections.emptySet();
            this.mIntroduceNewNodes = false;
            this.mDidRemoval = true;
            return;
        }
        this.mElementContainer = elementContainer;
        this.mElem = elem;
        this.mIntroduceNewNodes = introduceNewNodes;
        this.mMadeChanges = false;
        this.mAddedNodes = this.mIntroduceNewNodes ? new HashSet() : null;
    }

    public Set<ELEM> getAddedNodes() {
        assert (this.mDidRemoval);
        return this.mAddedNodes;
    }

    @Override
    public Collection<ELEM> getAlreadyRemovedElements() {
        return this.mElementsAlreadyRemoved;
    }

    public void doRemoval() {
        assert (!this.mDidRemoval);
        Set<ELEM> elementsToRemove = this.mElementContainer.collectElementsToRemove(this.mElem);
        this.mElementsToRemove = Collections.unmodifiableSet(elementsToRemove);
        assert (this.mElementsToRemove.stream().allMatch(e -> CongruenceClosure.dependsOnAny(e, Collections.singleton(this.mElem))));
        HashMap<ICongruenceClosureElement, ICongruenceClosureElement> nodeToReplacementNode = new HashMap<ICongruenceClosureElement, ICongruenceClosureElement>();
        for (ICongruenceClosureElement elemToRemove : this.mElementsToRemove) {
            ICongruenceClosureElement otherEqClassMember = this.mElementContainer.getOtherEquivalenceClassMember(elemToRemove, this.mElementsToRemove);
            if (otherEqClassMember == null) continue;
            nodeToReplacementNode.put(elemToRemove, otherEqClassMember);
        }
        assert (DataStructureUtils.intersection(new HashSet(nodeToReplacementNode.values()), this.mElementsToRemove).isEmpty());
        assert (this.nodeAndReplacementAreEquivalent(nodeToReplacementNode, this.mElementContainer));
        assert (!this.mElementContainer.isInconsistent());
        boolean becameInconsistentWhenAddingANode = false;
        becameInconsistentWhenAddingANode = RemoveCcElement.addNodesToKeepInformation(this, this.mElementsToRemove, nodeToReplacementNode);
        if (becameInconsistentWhenAddingANode) {
            assert (this.mElementContainer.isInconsistent());
            this.mDidRemoval = true;
            return;
        }
        assert (this.nodeAndReplacementAreEquivalent(nodeToReplacementNode, this.mElementContainer));
        assert (!this.mElementContainer.isInconsistent());
        assert (!this.mElementContainer.isInconsistent());
        if (this.mElementContainer.isInconsistent()) {
            return;
        }
        this.mElementContainer.removeElements(this.mElementsToRemove, nodeToReplacementNode);
        if (this.mElementContainer.isDebugMode() && this.mElementContainer.isInconsistent()) {
            this.mElementContainer.getLogger().debug((Object)("RemoveElement: " + this.mElementContainer.hashCode() + " became inconsistent during closure operation"));
        }
        this.mDidRemoval = true;
        if (this.mElementContainer.isDebugMode()) {
            this.mElementContainer.getLogger().debug((Object)("RemoveElement " + this.hashCode() + " finished normally"));
        }
    }

    private boolean nodeAndReplacementAreEquivalent(Map<ELEM, ELEM> nodeToReplacementNode, CongruenceClosure<ELEM> elementContainer) {
        for (Map.Entry<ELEM, ELEM> en : nodeToReplacementNode.entrySet()) {
            if (elementContainer.getEqualityStatus((ICongruenceClosureElement)en.getKey(), (ICongruenceClosureElement)en.getValue()) == EqualityStatus.EQUAL) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> boolean addNodesToKeepInformation(IRestoreNodesBeforeRemove<ELEM> rce, Set<ELEM> elementsToRemove, Map<ELEM, ELEM> nodeToReplacementNode) {
        if (!rce.isIntroduceNewNodes()) {
            return false;
        }
        while (true) {
            HashSet<ICongruenceClosureElement> nodesToAdd = new HashSet<ICongruenceClosureElement>();
            for (ICongruenceClosureElement elemToRemove : elementsToRemove) {
                if (!elemToRemove.isFunctionApplication() || !rce.getElementContainer().isConstrained(elemToRemove)) continue;
                Set<ICongruenceClosureElement> nodes = rce.getElementContainer().getNodesToIntroduceBeforeRemoval(elemToRemove, elementsToRemove, nodeToReplacementNode);
                nodesToAdd.addAll(nodes);
            }
            assert (nodesToAdd.stream().allMatch(e -> !CongruenceClosure.dependsOnAny(e, Collections.singleton(rce.getElem()))));
            assert (nodesToAdd.stream().allMatch(n -> !rce.getElementContainer().hasElement((ICongruenceClosureElement)n)));
            if (nodesToAdd.isEmpty()) break;
            if (rce.getElementContainer().isDebugMode()) {
                rce.getElementContainer().getLogger().debug((Object)("RemoveElement: adding nodes " + nodesToAdd));
            }
            for (ICongruenceClosureElement proxyElem : nodesToAdd) {
                if (rce.getElementContainer().isDebugMode()) {
                    rce.getElementContainer().getLogger().debug((Object)("RemoveElement: adding element " + proxyElem + " to " + rce.getElementContainer().hashCode() + " because it was added in weq graph label"));
                }
                rce.getElementContainer().addElement(proxyElem, true);
                if (!rce.getElementContainer().isInconsistent()) continue;
                if (rce.getElementContainer().isDebugMode()) {
                    rce.getElementContainer().getLogger().debug((Object)("RemoveElement: " + rce.getElementContainer().hashCode() + " became inconsistent when adding" + proxyElem));
                }
                return true;
            }
            if (!rce.isIntroduceNewNodes()) continue;
            rce.registerAddedNodes(nodesToAdd);
        }
        return false;
    }

    public boolean madeChanges() {
        assert (this.mDidRemoval);
        return this.mMadeChanges;
    }

    @Override
    public Set<ELEM> getRemovedElements() {
        return this.mElementsToRemove;
    }

    public String toString() {
        return this.mElementsToRemove.toString();
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> void removeSimpleElement(CongruenceClosure<ELEM> cc, ELEM elem) {
        RemoveCcElement.removeSimpleElement(cc, elem, true, true);
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> void removeSimpleElementDontIntroduceNewNodes(CongruenceClosure<ELEM> cc, ELEM elem) {
        RemoveCcElement.removeSimpleElement(cc, elem, false, false);
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> Set<ELEM> removeSimpleElementDontUseWeqGpaTrackAddedNodes(CongruenceClosure<ELEM> cc, ELEM elem) {
        return RemoveCcElement.removeSimpleElement(cc, elem, true, false).getAddedNodes();
    }

    private static <ELEM extends ICongruenceClosureElement<ELEM>> RemoveCcElement<ELEM> removeSimpleElement(CongruenceClosure<ELEM> cc, ELEM elem, boolean introduceNewNodes, boolean useWeqGpa) {
        if (elem.isFunctionApplication()) {
            throw new IllegalArgumentException();
        }
        if (cc.isInconsistent()) {
            throw new IllegalStateException();
        }
        assert (cc.getElementCurrentlyBeingRemoved() == null);
        RemoveCcElement<ELEM> re = new RemoveCcElement<ELEM>(cc, elem, introduceNewNodes, useWeqGpa);
        if (!cc.hasElement(elem)) {
            assert (!re.madeChanges());
            assert (re.getAddedNodes().isEmpty());
            return re;
        }
        cc.setElementCurrentlyBeingRemoved(re);
        re.doRemoval();
        assert (cc.assertSimpleElementIsFullyRemoved(elem));
        cc.setElementCurrentlyBeingRemoved(null);
        assert (cc.assertSimpleElementIsFullyRemoved(elem));
        return re;
    }

    @Override
    public boolean isIntroduceNewNodes() {
        return this.mIntroduceNewNodes;
    }

    @Override
    public ELEM getElem() {
        return this.mElem;
    }

    @Override
    public IElementRemovalTarget<ELEM> getElementContainer() {
        return this.mElementContainer;
    }

    @Override
    public void registerAddedNodes(Set<ELEM> nodesToAdd) {
        this.mAddedNodes.addAll(nodesToAdd);
    }
}

