/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintConjunction;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class SetConstraint<ELEM extends ICongruenceClosureElement<ELEM>> {
    private final Set<ELEM> mLiterals;
    private final Set<ELEM> mNonLiterals;
    private final boolean mIsInconsistent;

    protected SetConstraint(boolean inconsistent) {
        assert (inconsistent) : "use other constructor for this case!";
        this.mLiterals = null;
        this.mNonLiterals = null;
        this.mIsInconsistent = true;
    }

    public boolean isSingleton() {
        return this.getElementSet().size() == 1;
    }

    public ELEM getSingletonValue() {
        assert (this.isSingleton());
        return (ELEM)((ICongruenceClosureElement)this.getElementSet().iterator().next());
    }

    protected SetConstraint(Set<ELEM> literals, Set<ELEM> nonLiterals) {
        assert (literals.stream().allMatch(ICongruenceClosureElement::isLiteral));
        assert (!nonLiterals.stream().anyMatch(ICongruenceClosureElement::isLiteral));
        this.mLiterals = Collections.unmodifiableSet(literals);
        this.mNonLiterals = Collections.unmodifiableSet(nonLiterals);
        boolean bl = this.mIsInconsistent = literals.isEmpty() && nonLiterals.isEmpty();
        assert (!this.mIsInconsistent) : "use other constructor, no?";
        assert (this.sanityCheck());
    }

    public Set<ELEM> getLiterals() {
        return Collections.unmodifiableSet(this.mLiterals);
    }

    public boolean expandVariableToLiterals(ELEM elemRep, Set<ELEM> literals) {
        if (this.mNonLiterals.contains(elemRep)) {
            this.mNonLiterals.remove(elemRep);
            this.mLiterals.addAll(literals);
            return true;
        }
        return false;
    }

    public boolean hasOnlyLiterals() {
        return this.mNonLiterals.isEmpty();
    }

    public boolean isInconsistent() {
        return this.mIsInconsistent || this.mLiterals.isEmpty() && this.mNonLiterals.isEmpty();
    }

    public Set<ELEM> getElementSet() {
        return DataStructureUtils.union(this.mLiterals, this.mNonLiterals);
    }

    public boolean containsElement(ELEM elem) {
        if (elem.isLiteral()) {
            return this.mLiterals != null && this.mLiterals.contains(elem);
        }
        return this.mNonLiterals != null && this.mNonLiterals.contains(elem);
    }

    public String toString() {
        return "SetConstraint " + this.mLiterals + " U " + this.mNonLiterals;
    }

    public boolean sanityCheck() {
        if (!this.mLiterals.stream().allMatch(ICongruenceClosureElement::isLiteral)) {
            assert (false);
            return false;
        }
        if (this.mNonLiterals.stream().anyMatch(ICongruenceClosureElement::isLiteral)) {
            assert (false);
            return false;
        }
        if (this.getElementSet().size() >= 2) {
            Iterator<ELEM> it = this.getElementSet().iterator();
            ICongruenceClosureElement currentOne = null;
            ICongruenceClosureElement currentTwo = (ICongruenceClosureElement)it.next();
            while (it.hasNext()) {
                currentOne = currentTwo;
                if (currentOne.hasSameTypeAs(currentTwo = (ICongruenceClosureElement)it.next())) continue;
                assert (false);
                return false;
            }
        }
        return true;
    }

    public boolean sanityCheck(SetConstraintConjunction<ELEM> surroundingScConjunction) {
        if (!this.sanityCheck()) {
            assert (false);
            return false;
        }
        if (surroundingScConjunction == null) {
            return true;
        }
        if (surroundingScConjunction.mSurroundingCCSetConstraints == null) {
            return true;
        }
        CongruenceClosure<ICongruenceClosureElement> surrCc = surroundingScConjunction.getCongruenceClosure();
        if (surrCc == null) {
            return true;
        }
        if (surrCc.mLiteralSetConstraints == null) {
            return true;
        }
        if (!this.mLiterals.stream().allMatch(surrCc::hasElement)) {
            assert (false);
            return false;
        }
        if (this.mNonLiterals.stream().anyMatch(nl -> !surrCc.isRepresentative((ICongruenceClosureElement)nl))) {
            assert (false);
            return false;
        }
        for (ICongruenceClosureElement nl2 : this.mNonLiterals) {
            Set contCons = surrCc.getContainsConstraintForElement(nl2);
            if (contCons == null || !SetConstraintConjunction.hasOnlyLiterals(contCons)) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> boolean isTautological(ELEM constrainedElement, SetConstraint<ELEM> sc) {
        return sc.containsElement(constrainedElement);
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> SetConstraint<ELEM> getInconsistentSetConstraint() {
        return new SetConstraint<ELEM>(true);
    }

    public Set<ELEM> getNonLiterals() {
        return Collections.unmodifiableSet(this.mNonLiterals);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mIsInconsistent ? 1231 : 1237);
        result = 31 * result + (this.mLiterals == null ? 0 : this.mLiterals.hashCode());
        result = 31 * result + (this.mNonLiterals == null ? 0 : this.mNonLiterals.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetConstraint other = (SetConstraint)obj;
        if (this.mIsInconsistent != other.mIsInconsistent) {
            return false;
        }
        if (this.mLiterals == null ? other.mLiterals != null : !this.mLiterals.equals(other.mLiterals)) {
            return false;
        }
        return !(this.mNonLiterals == null ? other.mNonLiterals != null : !this.mNonLiterals.equals(other.mNonLiterals));
    }
}

