/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;

public class SetConstraintComparator<ELEM extends ICongruenceClosureElement<ELEM>>
implements IPartialComparator<SetConstraint<ELEM>> {
    private final SetConstraintManager<ELEM> mSetConstraintManager;

    public SetConstraintComparator(SetConstraintManager<ELEM> setConstraintManager) {
        this.mSetConstraintManager = setConstraintManager;
    }

    @Override
    public IPartialComparator.ComparisonResult compare(SetConstraint<ELEM> o1, SetConstraint<ELEM> o2) {
        if (o1.equals(o2)) {
            return IPartialComparator.ComparisonResult.EQUAL;
        }
        boolean o1Stronger = this.mSetConstraintManager.isStrongerThan(o1, o2);
        boolean o2Stronger = this.mSetConstraintManager.isStrongerThan(o2, o1);
        if (o1Stronger && o2Stronger) {
            return IPartialComparator.ComparisonResult.EQUAL;
        }
        if (o1Stronger) {
            return IPartialComparator.ComparisonResult.STRICTLY_GREATER;
        }
        if (o2Stronger) {
            return IPartialComparator.ComparisonResult.STRICTLY_SMALLER;
        }
        return IPartialComparator.ComparisonResult.INCOMPARABLE;
    }
}

