/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CCLiteralSetConstraints;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CcManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SetConstraintConjunction<ELEM extends ICongruenceClosureElement<ELEM>> {
    private ELEM mConstrainedElement;
    final CCLiteralSetConstraints<ELEM> mSurroundingCCSetConstraints;
    private final SetConstraintManager<ELEM> mSetConstraintManager;
    private Set<SetConstraint<ELEM>> mSetConstraints;
    private final SetConstraint<ELEM> mScWithOnlyLiterals;
    private boolean mIsInconsistent;

    public SetConstraintConjunction(boolean isInconsistent) {
        assert (isInconsistent) : "use other constructor in this case!!";
        this.mConstrainedElement = null;
        this.mIsInconsistent = true;
        this.mSetConstraints = null;
        this.mSurroundingCCSetConstraints = null;
        this.mScWithOnlyLiterals = null;
        this.mSetConstraintManager = null;
        assert (this.sanityCheck());
    }

    public SetConstraintConjunction(CCLiteralSetConstraints<ELEM> surroundingSetConstraints, ELEM constrainedElement, Collection<SetConstraint<ELEM>> setConstraintsRaw) {
        this.mConstrainedElement = constrainedElement;
        this.mSurroundingCCSetConstraints = surroundingSetConstraints;
        this.mSetConstraintManager = surroundingSetConstraints.getCongruenceClosure().getManager().getSetConstraintManager();
        ArrayList<SetConstraint<ELEM>> onlyLits = new ArrayList<SetConstraint<ELEM>>();
        for (SetConstraint<ELEM> sc : setConstraintsRaw) {
            if (!sc.hasOnlyLiterals()) continue;
            onlyLits.add(sc);
        }
        assert (onlyLits.size() < 2);
        this.mScWithOnlyLiterals = onlyLits.size() == 1 ? (SetConstraint)onlyLits.iterator().next() : null;
        this.mSetConstraints = Collections.unmodifiableSet(new HashSet<SetConstraint<ELEM>>(setConstraintsRaw));
        assert (this.sanityCheck());
    }

    public SetConstraintConjunction(CCLiteralSetConstraints<ELEM> surroundingCCSetConstraints, SetConstraintConjunction<ELEM> original) {
        this.mSurroundingCCSetConstraints = surroundingCCSetConstraints;
        this.mConstrainedElement = original.mConstrainedElement;
        this.mSetConstraintManager = original.mSetConstraintManager;
        this.mSetConstraints = Collections.unmodifiableSet(new HashSet<SetConstraint<ELEM>>(original.getSetConstraints()));
        this.mScWithOnlyLiterals = original.mScWithOnlyLiterals;
        assert (this.sanityCheck());
    }

    public void projectAway(ELEM elem) {
        assert (!elem.equals(this.mConstrainedElement));
        HashSet<SetConstraint<ELEM>> newSetConstraints = new HashSet<SetConstraint<ELEM>>();
        for (SetConstraint<ELEM> sc : this.mSetConstraints) {
            if (sc.containsElement(elem)) continue;
            newSetConstraints.add(sc);
        }
        this.mSetConstraints = newSetConstraints;
    }

    private Set<ELEM> getSingletonValues() {
        return this.mSetConstraintManager.getSingletonValues(this.mSetConstraints);
    }

    public boolean isTautological() {
        if (this.mIsInconsistent) {
            return false;
        }
        return this.mSetConstraints.isEmpty();
    }

    public boolean isInconsistent() {
        assert (!this.mIsInconsistent || this.mSetConstraints == null);
        if (this.mIsInconsistent) {
            return true;
        }
        for (SetConstraint<ELEM> sc : this.mSetConstraints) {
            if (!sc.isInconsistent()) continue;
            return true;
        }
        return false;
    }

    public CongruenceClosure<ELEM> getCongruenceClosure() {
        return this.mSurroundingCCSetConstraints.getCongruenceClosure();
    }

    public ELEM getConstrainedElement() {
        assert (this.mConstrainedElement != null);
        return this.mConstrainedElement;
    }

    CcManager<ELEM> getCcManager() {
        return this.mSurroundingCCSetConstraints.getCongruenceClosure().getManager();
    }

    public Set<ELEM> getAllRhsElements() {
        HashSet<ELEM> result = new HashSet<ELEM>();
        for (SetConstraint<ELEM> sc : this.mSetConstraints) {
            result.addAll(sc.getElementSet());
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<Set<ELEM>> getElementSets() {
        HashSet<Set<ELEM>> result = new HashSet<Set<ELEM>>();
        for (SetConstraint<ELEM> sc : this.mSetConstraints) {
            result.add(sc.getElementSet());
        }
        return Collections.unmodifiableSet(result);
    }

    public String toString() {
        if (this.mIsInconsistent) {
            return "SetCc: False";
        }
        return "SetConstraintConjunction [ConstrainedElement=" + this.mConstrainedElement + ", mSetConstraints=" + this.mSetConstraints + "]";
    }

    public boolean hasOnlyLiterals() {
        return this.mScWithOnlyLiterals != null;
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> boolean hasOnlyLiterals(Collection<SetConstraint<ELEM>> setConstraints) {
        for (SetConstraint<ELEM> sc : setConstraints) {
            if (!sc.hasOnlyLiterals()) continue;
            return true;
        }
        return false;
    }

    public Set<ELEM> getLiterals() {
        assert (this.mScWithOnlyLiterals.getNonLiterals().isEmpty());
        return this.mScWithOnlyLiterals.getLiterals();
    }

    public void expandVariableToLiterals(CCLiteralSetConstraints<ELEM> surroundingSetConstraints, ELEM elem, Set<ELEM> literals) {
        assert (!elem.isLiteral());
        assert (this.getCongruenceClosure().isRepresentative(elem));
        boolean madeChanges = false;
        for (SetConstraint<ELEM> sc : this.mSetConstraints) {
            madeChanges |= sc.expandVariableToLiterals(elem, literals);
        }
        if (madeChanges) {
            this.mSetConstraints = this.mSurroundingCCSetConstraints.getCongruenceClosure().getManager().normalizeSetConstraintConjunction(surroundingSetConstraints, this.mSetConstraints);
        }
    }

    public void resetConstrainedElement(ELEM elementRep) {
        this.mConstrainedElement = elementRep;
    }

    public Set<SetConstraint<ELEM>> getSetConstraints() {
        return Collections.unmodifiableSet(this.mSetConstraints);
    }

    public boolean sanityCheck() {
        if (this.mIsInconsistent) {
            if (this.mSurroundingCCSetConstraints == null) {
                return true;
            }
            if (!this.mSetConstraints.stream().anyMatch(sc -> sc.isInconsistent())) {
                assert (false);
                return false;
            }
        }
        if (!this.getSingletonValues().isEmpty()) {
            assert (false);
            return false;
        }
        for (SetConstraint<ELEM> conjunct : this.mSetConstraints) {
            if (conjunct.sanityCheck()) continue;
            assert (false);
            return false;
        }
        if (this.mSurroundingCCSetConstraints.getCongruenceClosure() != null) {
            for (SetConstraint<ELEM> conjunct : this.mSetConstraints) {
                for (ICongruenceClosureElement iCongruenceClosureElement : conjunct.getElementSet()) {
                    if (this.mSurroundingCCSetConstraints.getCongruenceClosure().isRepresentative(iCongruenceClosureElement)) continue;
                    assert (false);
                    return false;
                }
            }
        }
        for (SetConstraint<ELEM> sc1 : this.mSetConstraints) {
            for (SetConstraint setConstraint : this.mSetConstraints) {
                if (sc1 == setConstraint || !this.mSetConstraintManager.isStrongerThan(sc1, setConstraint)) continue;
                assert (false);
                return false;
            }
        }
        for (SetConstraint<ELEM> sc2 : this.mSetConstraints) {
            if (!sc2.containsElement(this.mConstrainedElement)) continue;
            assert (false) : "we have a constraint of the form x in {x, ...}, which is tautological, but SetConstraintConjunction should be normalized";
            return false;
        }
        return true;
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> boolean sanityCheck(Set<SetConstraint<ELEM>> filtered) {
        if (filtered == null) {
            return true;
        }
        if (filtered.isEmpty()) {
            assert (false);
            return false;
        }
        return true;
    }
}

