/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CCLiteralSetConstraints;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CcManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintConjunction;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SetConstraintManager<ELEM extends ICongruenceClosureElement<ELEM>> {
    private final NestedMap2<Set<ELEM>, Set<ELEM>, SetConstraint<ELEM>> mLiteralsToNonLiteralsToSetConstraint = new NestedMap2();
    private final SetConstraint<ELEM> mInconsistentSetConstraint = new SetConstraint(true);
    private final IPartialComparator<SetConstraint<ELEM>> mSetConstraintComparator = new SetConstraintComparator(this);
    private final CcManager<ELEM> mCcManager;

    public SetConstraintManager(CcManager<ELEM> ccMan) {
        this.mCcManager = ccMan;
    }

    public SetConstraint<ELEM> buildSetConstraint(Set<ELEM> literals, Set<ELEM> nonLiterals) {
        assert (literals.stream().allMatch(ICongruenceClosureElement::isLiteral));
        assert (!nonLiterals.stream().anyMatch(ICongruenceClosureElement::isLiteral));
        if (literals.isEmpty() && nonLiterals.isEmpty()) {
            return this.getInconsistentSetConstraint();
        }
        SetConstraint<ELEM> result = this.mLiteralsToNonLiteralsToSetConstraint.get(literals, nonLiterals);
        if (result == null) {
            result = new SetConstraint<ELEM>(new HashSet<ELEM>(literals), new HashSet<ELEM>(nonLiterals));
            this.mLiteralsToNonLiteralsToSetConstraint.put(literals, nonLiterals, result);
        }
        return result;
    }

    private SetConstraint<ELEM> getInconsistentSetConstraint() {
        return this.mInconsistentSetConstraint;
    }

    public SetConstraint<ELEM> buildSetConstraint(Collection<ELEM> unsortedElements) {
        HashSet<ICongruenceClosureElement> literals = new HashSet<ICongruenceClosureElement>();
        HashSet<ICongruenceClosureElement> nonLiterals = new HashSet<ICongruenceClosureElement>();
        for (ICongruenceClosureElement el : unsortedElements) {
            if (el.isLiteral()) {
                literals.add(el);
                continue;
            }
            nonLiterals.add(el);
        }
        return this.buildSetConstraint(literals, nonLiterals);
    }

    public SetConstraint<ELEM> updateOnChangedRepresentative(SetConstraint<ELEM> oldSetConstraint, ELEM elem1OldRep, ELEM elem2OldRep, ELEM newRep) {
        Set<ELEM> oldElements = oldSetConstraint.getElementSet();
        if (!oldElements.contains(elem1OldRep) && !oldElements.contains(elem2OldRep)) {
            return oldSetConstraint;
        }
        HashSet<ELEM> newLiterals = new HashSet<ELEM>(oldSetConstraint.getLiterals());
        HashSet<ELEM> newNonLiterals = new HashSet<ELEM>(oldSetConstraint.getNonLiterals());
        if (elem1OldRep.isLiteral()) {
            newLiterals.remove(elem1OldRep);
        } else {
            newNonLiterals.remove(elem1OldRep);
        }
        if (elem2OldRep.isLiteral()) {
            newLiterals.remove(elem2OldRep);
        } else {
            newNonLiterals.remove(elem2OldRep);
        }
        if (newRep.isLiteral()) {
            newLiterals.add(newRep);
        } else {
            newNonLiterals.add(newRep);
        }
        return this.buildSetConstraint(newLiterals, newNonLiterals);
    }

    public SetConstraint<ELEM> updateOnChangedRepresentative(SetConstraint<ELEM> oldSetConstraint, ELEM oldRep, ELEM newRep) {
        Set<ELEM> oldElements = oldSetConstraint.getElementSet();
        if (!oldElements.contains(oldRep)) {
            return oldSetConstraint;
        }
        HashSet<ELEM> newLiterals = new HashSet<ELEM>(oldSetConstraint.getLiterals());
        HashSet<ELEM> newNonLiterals = new HashSet<ELEM>(oldSetConstraint.getNonLiterals());
        if (oldRep.isLiteral()) {
            newLiterals.remove(oldRep);
        } else {
            newNonLiterals.remove(oldRep);
        }
        if (newRep.isLiteral()) {
            newLiterals.add(newRep);
        } else {
            newNonLiterals.add(newRep);
        }
        return this.buildSetConstraint(newLiterals, newNonLiterals);
    }

    public SetConstraint<ELEM> updateOnChangedRepresentative(SetConstraint<ELEM> sc, CongruenceClosure<ELEM> newCc) {
        HashSet<ELEM> newLiterals = new HashSet<ELEM>(sc.getLiterals());
        HashSet<ICongruenceClosureElement> newNonLiterals = new HashSet<ICongruenceClosureElement>();
        boolean madeChanges = false;
        for (ICongruenceClosureElement e : sc.getNonLiterals()) {
            ICongruenceClosureElement newRep;
            madeChanges |= e != (newRep = newCc.getRepresentativeElement(e));
            if (newRep.isLiteral()) {
                newLiterals.add(newRep);
                continue;
            }
            newNonLiterals.add(newRep);
        }
        if (!madeChanges) {
            return sc;
        }
        return this.buildSetConstraint(newLiterals, newNonLiterals);
    }

    public SetConstraint<ELEM> filterWithDisequality(SetConstraint<ELEM> constraint, ELEM elem) {
        if (!constraint.getLiterals().contains(elem) && !constraint.getNonLiterals().contains(elem)) {
            return constraint;
        }
        HashSet<ELEM> newLiterals = new HashSet<ELEM>(constraint.getLiterals());
        HashSet<ELEM> newNonLiterals = new HashSet<ELEM>(constraint.getNonLiterals());
        newLiterals.remove(elem);
        newNonLiterals.remove(elem);
        return this.buildSetConstraint(newLiterals, newNonLiterals);
    }

    public SetConstraint<ELEM> transformElements(SetConstraint<ELEM> constraint, Function<ELEM, ELEM> elemTransformer) {
        HashSet<ICongruenceClosureElement> newLiterals = new HashSet<ICongruenceClosureElement>();
        HashSet<ICongruenceClosureElement> newNonLiterals = new HashSet<ICongruenceClosureElement>();
        for (ICongruenceClosureElement e : constraint.getElementSet()) {
            ICongruenceClosureElement transformed = (ICongruenceClosureElement)elemTransformer.apply(e);
            if (transformed.isLiteral()) {
                newLiterals.add(transformed);
                continue;
            }
            newNonLiterals.add(transformed);
        }
        return this.buildSetConstraint(newLiterals, newNonLiterals);
    }

    public SetConstraint<ELEM> filterWithDisequalities(SetConstraint<ELEM> oldConstraint, ELEM constrainedElement, CongruenceClosure<ELEM> congruenceClosure) {
        boolean madeChanges = false;
        HashSet<ELEM> newLiterals = new HashSet<ELEM>(oldConstraint.getLiterals());
        for (ICongruenceClosureElement lit : oldConstraint.getLiterals()) {
            if (congruenceClosure.getEqualityStatus((ICongruenceClosureElement)constrainedElement, lit) != EqualityStatus.NOT_EQUAL) continue;
            madeChanges |= newLiterals.remove(lit);
        }
        HashSet<ELEM> newNonLiterals = new HashSet<ELEM>(oldConstraint.getNonLiterals());
        for (ICongruenceClosureElement lit : oldConstraint.getNonLiterals()) {
            if (congruenceClosure.getEqualityStatus((ICongruenceClosureElement)constrainedElement, lit) != EqualityStatus.NOT_EQUAL) continue;
            madeChanges |= newNonLiterals.remove(lit);
        }
        if (!madeChanges) {
            return oldConstraint;
        }
        return this.buildSetConstraint(newLiterals, newNonLiterals);
    }

    public boolean isStrongerThan(SetConstraint<ELEM> lhsConjunct, SetConstraint<ELEM> rhsConjunct) {
        if (!rhsConjunct.getLiterals().containsAll(lhsConjunct.getLiterals())) {
            return false;
        }
        return rhsConjunct.getNonLiterals().containsAll(lhsConjunct.getNonLiterals());
    }

    public SetConstraint<ELEM> meet(CCLiteralSetConstraints<ELEM> surroundingSetConstraints, Collection<SetConstraint<ELEM>> scs) {
        if (scs.isEmpty()) {
            return null;
        }
        Iterator<SetConstraint<ELEM>> scIt = scs.iterator();
        SetConstraint<ELEM> firstSc = scIt.next();
        HashSet<Object> literals = new HashSet<ELEM>(firstSc.getLiterals());
        HashSet<ELEM> nonLiterals = new HashSet<ELEM>(firstSc.getNonLiterals());
        while (scIt.hasNext()) {
            SetConstraint<ELEM> current = scIt.next();
            HashSet<ICongruenceClosureElement> newLiterals = new HashSet<ICongruenceClosureElement>();
            for (ICongruenceClosureElement l : literals) {
                if (!current.getLiterals().contains(l)) continue;
                newLiterals.add(l);
            }
            literals = newLiterals;
            nonLiterals.addAll(current.getNonLiterals());
        }
        return this.buildSetConstraint(literals, nonLiterals);
    }

    public SetConstraint<ELEM> join(SetConstraint<ELEM> sc1, SetConstraint<ELEM> sc2) {
        return this.buildSetConstraint(DataStructureUtils.union(sc1.getLiterals(), sc2.getLiterals()), DataStructureUtils.union(sc1.getNonLiterals(), sc2.getNonLiterals()));
    }

    public SetConstraint<ELEM> expandNonLiteral(SetConstraint<ELEM> oldSc, ELEM e, Set<ELEM> expansion) {
        assert (oldSc.getNonLiterals().contains(e));
        HashSet<ELEM> newLiterals = new HashSet<ELEM>(oldSc.getLiterals());
        HashSet<ELEM> newNonLiterals = new HashSet<ELEM>(oldSc.getNonLiterals());
        newLiterals.addAll(expansion);
        newNonLiterals.remove(e);
        return this.buildSetConstraint(newLiterals, newNonLiterals);
    }

    public Set<SetConstraint<ELEM>> updateOnChangedRepresentative(Set<SetConstraint<ELEM>> setConstraints, ELEM oldRep, ELEM newRep) {
        HashSet<SetConstraint<ELEM>> result = new HashSet<SetConstraint<ELEM>>();
        for (SetConstraint<ELEM> setConstraint : setConstraints) {
            result.add(this.updateOnChangedRepresentative(setConstraint, oldRep, newRep));
        }
        return result;
    }

    public Set<SetConstraint<ELEM>> updateOnChangedRepresentative(Set<SetConstraint<ELEM>> setConstraints, ELEM elem1OldRep, ELEM elem2OldRep, ELEM newRep) {
        HashSet<SetConstraint<ELEM>> result = new HashSet<SetConstraint<ELEM>>();
        boolean madeChanges = false;
        for (SetConstraint<ELEM> setConstraint : setConstraints) {
            SetConstraint<ELEM> updated = this.updateOnChangedRepresentative(setConstraint, elem1OldRep, elem2OldRep, newRep);
            madeChanges |= updated != setConstraint;
            result.add(updated);
        }
        if (!madeChanges) {
            return setConstraints;
        }
        return result;
    }

    public Set<SetConstraint<ELEM>> transformElements(Set<SetConstraint<ELEM>> setConstraints, Function<ELEM, ELEM> elemTransformer) {
        HashSet<SetConstraint<ELEM>> result = new HashSet<SetConstraint<ELEM>>();
        for (SetConstraint<ELEM> setConstraint : setConstraints) {
            result.add(this.transformElements(setConstraint, elemTransformer));
        }
        return result;
    }

    public Set<SetConstraint<ELEM>> meet(CCLiteralSetConstraints<ELEM> surroundingConstraint, Set<SetConstraint<ELEM>> constraintConjunction1, Set<SetConstraint<ELEM>> constraintConjunction2) {
        if (SetConstraintManager.isTautological(constraintConjunction1)) {
            return constraintConjunction2;
        }
        if (SetConstraintManager.isTautological(constraintConjunction2)) {
            return constraintConjunction1;
        }
        if (this.isInconsistent(constraintConjunction1)) {
            return this.getInconsistentSetConstraintConjunction();
        }
        if (this.isInconsistent(constraintConjunction2)) {
            return this.getInconsistentSetConstraintConjunction();
        }
        Set<SetConstraint<ELEM>> newSetConstraints = DataStructureUtils.union(constraintConjunction1, constraintConjunction2);
        return surroundingConstraint.getCongruenceClosure().getManager().normalizeSetConstraintConjunction(surroundingConstraint, newSetConstraints);
    }

    public boolean meetIsInconsistent(CCLiteralSetConstraints<ELEM> surroundingConstraint, Set<SetConstraint<ELEM>> litConstraint1, Set<SetConstraint<ELEM>> litConstraint2) {
        this.mCcManager.bmStart(CcManager.CcBmNames.MEET_IS_INCONSISTENT);
        SetConstraint<ELEM> lits1 = null;
        for (SetConstraint<ELEM> sc : litConstraint1) {
            if (!sc.hasOnlyLiterals()) continue;
            lits1 = sc;
            break;
        }
        if (lits1 == null) {
            this.mCcManager.bmEnd(CcManager.CcBmNames.MEET_IS_INCONSISTENT);
            return false;
        }
        SetConstraint<ELEM> lits2 = null;
        for (SetConstraint<ELEM> sc : litConstraint2) {
            if (!sc.hasOnlyLiterals()) continue;
            lits2 = sc;
            break;
        }
        if (lits2 == null) {
            this.mCcManager.bmEnd(CcManager.CcBmNames.MEET_IS_INCONSISTENT);
            return false;
        }
        boolean result = !DataStructureUtils.haveNonEmptyIntersection(lits1.getLiterals(), lits2.getLiterals());
        this.mCcManager.bmEnd(CcManager.CcBmNames.MEET_IS_INCONSISTENT);
        return result;
    }

    public boolean isStrongerThan(Set<SetConstraint<ELEM>> constraintConjunction1, Set<SetConstraint<ELEM>> constraintConjunction2) {
        if (SetConstraintManager.isTautological(constraintConjunction1)) {
            return true;
        }
        if (SetConstraintManager.isTautological(constraintConjunction2)) {
            return false;
        }
        if (this.isInconsistent(constraintConjunction1)) {
            return true;
        }
        if (this.isInconsistent(constraintConjunction2)) {
            return false;
        }
        for (SetConstraint<ELEM> rhsConjunct : constraintConjunction2) {
            boolean disjunctionHolds = false;
            for (SetConstraint<ELEM> lhsConjunct : constraintConjunction1) {
                if (this.isStrongerThan(lhsConjunct, rhsConjunct)) continue;
                disjunctionHolds = true;
                break;
            }
            if (disjunctionHolds) continue;
            return false;
        }
        return true;
    }

    public Set<SetConstraint<ELEM>> getInconsistentSetConstraintConjunction() {
        return Collections.singleton(SetConstraint.getInconsistentSetConstraint());
    }

    public Set<SetConstraint<ELEM>> getTautologicalSetConstraintConjunction() {
        return Collections.emptySet();
    }

    public Set<SetConstraint<ELEM>> join(CCLiteralSetConstraints<ELEM> surroundingSetConstraints, Set<SetConstraint<ELEM>> constraintConjunction1, Set<SetConstraint<ELEM>> constraintConjunction2) {
        if (SetConstraintManager.isTautological(constraintConjunction1)) {
            return this.getTautologicalSetConstraintConjunction();
        }
        if (SetConstraintManager.isTautological(constraintConjunction2)) {
            return this.getTautologicalSetConstraintConjunction();
        }
        if (this.isInconsistent(constraintConjunction1)) {
            return constraintConjunction2;
        }
        if (this.isInconsistent(constraintConjunction2)) {
            return constraintConjunction1;
        }
        HashSet<SetConstraint<ELEM>> newSetConstraints = new HashSet<SetConstraint<ELEM>>();
        for (SetConstraint<ELEM> sc1 : constraintConjunction1) {
            for (SetConstraint<ELEM> sc2 : constraintConjunction2) {
                newSetConstraints.add(this.join(sc1, sc2));
            }
        }
        return newSetConstraints;
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> boolean isTautological(Set<SetConstraint<ELEM>> constraints) {
        if (constraints == null) {
            return true;
        }
        return constraints.isEmpty();
    }

    public boolean isInconsistent(Collection<SetConstraint<ELEM>> constraints) {
        if (constraints == null) {
            return false;
        }
        for (SetConstraint<ELEM> sc : constraints) {
            if (!sc.isInconsistent()) continue;
            return true;
        }
        return false;
    }

    public Set<ELEM> getSingletonValues(Set<SetConstraint<ELEM>> constraints) {
        HashSet<ELEM> result = new HashSet<ELEM>();
        for (SetConstraint<ELEM> sc : constraints) {
            if (!sc.isSingleton()) continue;
            result.add(sc.getSingletonValue());
        }
        return result;
    }

    public Set<SetConstraint<ELEM>> filterWithDisequalities(CongruenceClosure<ELEM> congruenceClosure, ELEM constrainedElement, Set<SetConstraint<ELEM>> constraints) {
        HashSet<SetConstraint<ELEM>> result = new HashSet<SetConstraint<ELEM>>();
        boolean madeChanges = false;
        for (SetConstraint<ELEM> setConstraint : constraints) {
            SetConstraint<ELEM> filtered = this.filterWithDisequalities(setConstraint, constrainedElement, congruenceClosure);
            madeChanges |= filtered != setConstraint;
            result.add(filtered);
        }
        if (!madeChanges) {
            return constraints;
        }
        return result;
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> boolean isTautological(SetConstraintConjunction<ELEM> newConstraint) {
        if (newConstraint == null) {
            return true;
        }
        return newConstraint.isTautological();
    }

    public Set<SetConstraint<ELEM>> filterWithDisequality(Set<SetConstraint<ELEM>> setConstraints, ELEM elem) {
        HashSet<SetConstraint<ELEM>> result = new HashSet<SetConstraint<ELEM>>();
        boolean madeChanges = false;
        for (SetConstraint<ELEM> sc : setConstraints) {
            SetConstraint<ELEM> filtered = this.filterWithDisequality(sc, elem);
            madeChanges |= filtered != sc;
            result.add(filtered);
        }
        if (!madeChanges) {
            return setConstraints;
        }
        return result;
    }

    public Set<SetConstraint<ELEM>> updateOnChangedRepresentative(Set<SetConstraint<ELEM>> oldConstraint, CongruenceClosure<ELEM> newCc) {
        if (oldConstraint == null) {
            return null;
        }
        HashSet<SetConstraint<ELEM>> result = new HashSet<SetConstraint<ELEM>>();
        boolean madeChanges = false;
        for (SetConstraint<ELEM> sc : oldConstraint) {
            SetConstraint<ELEM> updRep = this.updateOnChangedRepresentative(sc, newCc);
            madeChanges |= updRep != sc;
            result.add(updRep);
        }
        if (!madeChanges) {
            return oldConstraint;
        }
        return result;
    }

    public IPartialComparator<SetConstraint<ELEM>> getSetConstraintComparator() {
        return this.mSetConstraintComparator;
    }

    public Set<ELEM> getLiteralSet(Set<SetConstraint<ELEM>> scs) {
        assert (scs.stream().filter(SetConstraint::hasOnlyLiterals).collect(Collectors.toList()).size() <= 1) : "not normalized?";
        for (SetConstraint<ELEM> sc : scs) {
            if (!sc.hasOnlyLiterals()) continue;
            return sc.getLiterals();
        }
        return null;
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> boolean isTautologicalWrtElement(ELEM elem, Set<SetConstraint<ELEM>> constraint) {
        if (SetConstraintManager.isTautological(constraint)) {
            return true;
        }
        for (SetConstraint<ELEM> sc : constraint) {
            if (sc.containsElement(elem)) continue;
            return false;
        }
        return true;
    }
}

