/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.poset;

import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.CanonicalPartialComparatorForMaps;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.ILattice;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CanonicalLatticeForMaps<K, V>
extends CanonicalPartialComparatorForMaps<K, V>
implements ILattice<Map<K, V>> {
    private final ILattice<V> mLattice;
    private final Set<K> mKeyDomain;
    private final Map<K, V> mTop;

    public CanonicalLatticeForMaps(ILattice<V> lattice) {
        super(lattice);
        this.mLattice = lattice;
        this.mKeyDomain = null;
        this.mTop = null;
    }

    public CanonicalLatticeForMaps(ILattice<V> lattice, Set<K> keyDomain) {
        super(lattice);
        this.mLattice = lattice;
        this.mKeyDomain = Objects.requireNonNull(keyDomain);
        Object top = lattice.getTop();
        this.mTop = this.mKeyDomain.stream().collect(Collectors.toMap(Function.identity(), x -> top));
    }

    @Override
    public IPartialComparator.ComparisonResult compare(Map<K, V> o1, Map<K, V> o2) {
        assert (this.checkDomain(o1));
        assert (this.checkDomain(o2));
        return super.compare(o1, o2);
    }

    @Override
    public Map<K, V> getBottom() {
        return Collections.emptyMap();
    }

    @Override
    public Map<K, V> getTop() {
        if (this.mTop == null) {
            throw new UnsupportedOperationException("Map lattice has no top element unless key domain is finite");
        }
        return this.mTop;
    }

    @Override
    public Map<K, V> supremum(Map<K, V> h1, Map<K, V> h2) {
        assert (this.checkDomain(h1));
        assert (this.checkDomain(h2));
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : h1.entrySet()) {
            V value = h2.containsKey(entry.getKey()) ? this.mLattice.supremum(entry.getValue(), h2.get(entry.getKey())) : entry.getValue();
            result.put(entry.getKey(), value);
        }
        for (Map.Entry<K, V> entry : h2.entrySet()) {
            if (result.containsKey(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public Map<K, V> infimum(Map<K, V> h1, Map<K, V> h2) {
        Map<K, V> bigger;
        Map<K, V> smaller;
        assert (this.checkDomain(h1));
        assert (this.checkDomain(h2));
        if (h1.size() < h2.size()) {
            smaller = h1;
            bigger = h2;
        } else {
            smaller = h2;
            bigger = h1;
        }
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : smaller.entrySet()) {
            if (!bigger.containsKey(entry.getKey())) continue;
            V value = this.mLattice.infimum(entry.getValue(), bigger.get(entry.getKey()));
            result.put(entry.getKey(), value);
        }
        return result;
    }

    private boolean checkDomain(Map<K, V> map) {
        boolean result;
        boolean bl = result = this.mKeyDomain == null || this.mKeyDomain.containsAll(map.keySet());
        assert (result) : "map with unexpected keys: " + DataStructureUtils.difference(map.keySet(), this.mKeyDomain);
        return result;
    }
}

