/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.poset;

import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import java.util.Comparator;
import java.util.Map;

public class CanonicalPartialComparatorForMaps<K, V>
implements IPartialComparator<Map<K, V>> {
    private final IPartialComparator<V> mComparator;

    public CanonicalPartialComparatorForMaps(IPartialComparator<V> comparator) {
        this.mComparator = comparator;
    }

    public CanonicalPartialComparatorForMaps(Comparator<V> comparator, boolean isConsistent) {
        this(IPartialComparator.fromNonPartialComparator(comparator, isConsistent));
    }

    public CanonicalPartialComparatorForMaps(Comparator<V> comparator) {
        this(comparator, true);
    }

    @Override
    public IPartialComparator.ComparisonResult compare(Map<K, V> o1, Map<K, V> o2) {
        if (o1 == o2) {
            return IPartialComparator.ComparisonResult.EQUAL;
        }
        if (o1.size() > o2.size()) {
            return this.compare(o2, o1).invert();
        }
        IPartialComparator.ComparisonResult result = IPartialComparator.ComparisonResult.EQUAL;
        for (Map.Entry<K, V> entry : o1.entrySet()) {
            V value2 = o2.get(entry.getKey());
            IPartialComparator.ComparisonResult currentPartialComparionResult = value2 == null ? IPartialComparator.ComparisonResult.STRICTLY_GREATER : this.mComparator.compare(entry.getValue(), value2);
            if ((result = IPartialComparator.ComparisonResult.aggregate(result, currentPartialComparionResult)) != IPartialComparator.ComparisonResult.INCOMPARABLE) continue;
            return result;
        }
        if (result == IPartialComparator.ComparisonResult.EQUAL && o1.size() < o2.size()) {
            result = IPartialComparator.ComparisonResult.STRICTLY_SMALLER;
        } else if (result == IPartialComparator.ComparisonResult.STRICTLY_GREATER && !o1.keySet().containsAll(o2.keySet())) {
            result = IPartialComparator.ComparisonResult.INCOMPARABLE;
        }
        return result;
    }
}

