/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.poset;

import java.util.Comparator;
import java.util.Objects;

@FunctionalInterface
public interface IPartialComparator<T> {
    public ComparisonResult compare(T var1, T var2);

    public static <T> IPartialComparator<T> fromNonPartialComparator(Comparator<T> comp, boolean isConsistent) {
        if (isConsistent) {
            return (x, y) -> ComparisonResult.fromNonPartialComparison(comp.compare(x, y));
        }
        return (x, y) -> {
            ComparisonResult result = ComparisonResult.fromNonPartialComparison(comp.compare(x, y));
            if (result == ComparisonResult.EQUAL && !Objects.equals(x, y)) {
                return ComparisonResult.INCOMPARABLE;
            }
            return result;
        };
    }

    public static enum ComparisonResult {
        STRICTLY_SMALLER,
        EQUAL,
        STRICTLY_GREATER,
        INCOMPARABLE;


        public ComparisonResult invert() {
            switch (this) {
                case STRICTLY_SMALLER: {
                    return STRICTLY_GREATER;
                }
                case EQUAL: {
                    return EQUAL;
                }
                case STRICTLY_GREATER: {
                    return STRICTLY_SMALLER;
                }
                case INCOMPARABLE: {
                    return INCOMPARABLE;
                }
            }
            throw new AssertionError((Object)"unknown value");
        }

        private static ComparisonResult fromNonPartialComparison(int nonPartialComparisonResult) {
            if (nonPartialComparisonResult == 0) {
                return EQUAL;
            }
            if (nonPartialComparisonResult > 0) {
                return STRICTLY_GREATER;
            }
            return STRICTLY_SMALLER;
        }

        public static ComparisonResult aggregate(ComparisonResult cr1, ComparisonResult cr2) {
            switch (cr1) {
                case EQUAL: {
                    return cr2;
                }
                case INCOMPARABLE: {
                    return INCOMPARABLE;
                }
                case STRICTLY_SMALLER: 
                case STRICTLY_GREATER: {
                    if (cr2 == INCOMPARABLE || cr2 == cr1.invert()) {
                        return INCOMPARABLE;
                    }
                    return cr1;
                }
            }
            throw new AssertionError((Object)"unknown value");
        }

        public boolean isLessOrEqual() {
            return this == STRICTLY_SMALLER || this == EQUAL;
        }
    }
}

