/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.poset;

import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.TopologicalSorter;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.statistics.BenchmarkWithCounters;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class PartialOrderCache<E> {
    private static final boolean BENCHMARK = true;
    private final IPartialComparator<E> mComparator;
    private final HashRelation<E, E> mStrictlySmaller;
    private final HashRelation<E, E> mNotStrictlySmaller;
    private final UnionFind<E> mEquivalences;
    private final Set<E> mMaximalElements;
    private final BenchmarkWithCounters mBenchmark;

    public PartialOrderCache(IPartialComparator<E> comparator) {
        this.mComparator = comparator;
        this.mStrictlySmaller = new HashRelation();
        this.mNotStrictlySmaller = new HashRelation();
        this.mEquivalences = new UnionFind();
        this.mMaximalElements = new HashSet();
        this.mBenchmark = new BenchmarkWithCounters();
        this.mBenchmark.registerCountersAndWatches(PocBmNames.getNames());
    }

    public E addElement(E elemToAdd) {
        this.bmStart(PocBmNames.ELEMENTS_ADDED);
        E rep = this.mEquivalences.find(elemToAdd);
        if (rep != null) {
            this.bmEnd(PocBmNames.ELEMENTS_ADDED);
            return rep;
        }
        rep = this.mEquivalences.findAndConstructEquivalenceClassIfNeeded(elemToAdd);
        assert (rep == elemToAdd);
        this.mMaximalElements.add(rep);
        for (E otherRep : new ArrayList<E>(this.mEquivalences.getAllRepresentatives())) {
            if (otherRep == rep) continue;
            this.bmStart(PocBmNames.ORDER_REQUESTS_MADE);
            IPartialComparator.ComparisonResult comparisonResult = this.mComparator.compare(elemToAdd, otherRep);
            this.bmEnd(PocBmNames.ORDER_REQUESTS_MADE);
            switch (comparisonResult) {
                case EQUAL: {
                    this.mEquivalences.union(rep, otherRep);
                    E newRep = this.mEquivalences.find(rep);
                    if (newRep == rep) {
                        assert (this.mEquivalences.find(otherRep) == rep);
                        this.mMaximalElements.remove(otherRep);
                        this.mStrictlySmaller.replaceDomainElement(otherRep, newRep);
                        this.mStrictlySmaller.replaceRangeElement(otherRep, newRep);
                    } else {
                        this.mMaximalElements.remove(rep);
                        this.mStrictlySmaller.replaceDomainElement(rep, newRep);
                        this.mStrictlySmaller.replaceRangeElement(rep, newRep);
                    }
                    assert (this.assertInvariants());
                    this.bmEnd(PocBmNames.ELEMENTS_ADDED);
                    return newRep;
                }
                case STRICTLY_SMALLER: {
                    this.addStrictlySmaller(elemToAdd, otherRep);
                    break;
                }
                case STRICTLY_GREATER: {
                    this.addStrictlySmaller(otherRep, elemToAdd);
                    break;
                }
                case INCOMPARABLE: {
                    this.mNotStrictlySmaller.addPair(elemToAdd, otherRep);
                    this.mNotStrictlySmaller.addPair(otherRep, elemToAdd);
                }
            }
        }
        this.bmEnd(PocBmNames.ELEMENTS_ADDED);
        assert (this.assertInvariants());
        return rep;
    }

    private void addStrictlySmaller(E smaller, E greater) {
        assert (this.mEquivalences.find(smaller) == smaller);
        assert (this.mEquivalences.find(greater) == greater);
        E smallerRep = this.mEquivalences.find(smaller);
        E greaterRep = this.mEquivalences.find(greater);
        this.mStrictlySmaller.addPair(smallerRep, greaterRep);
        this.mNotStrictlySmaller.addPair(greaterRep, smallerRep);
        assert (this.assertStrictlySmaller(smallerRep, greaterRep));
        this.mMaximalElements.remove(smallerRep);
        assert (this.assertInvariants());
    }

    public boolean isSmallerOrEqual(E elem1, E elem2) {
        E rep2;
        this.bmStart(PocBmNames.ORDER_REQUESTS_ANSWERED);
        if (elem1 == elem2) {
            return true;
        }
        assert (this.assertInvariants());
        E rep1 = this.addElement(elem1);
        if (rep1 == (rep2 = this.addElement(elem2))) {
            this.bmEnd(PocBmNames.ORDER_REQUESTS_ANSWERED);
            return true;
        }
        boolean result = this.isStrictlySmaller(rep1, rep2);
        this.bmEnd(PocBmNames.ORDER_REQUESTS_ANSWERED);
        return result;
    }

    private boolean isStrictlySmaller(E rep1, E rep2) {
        if (this.mStrictlySmaller.containsPair(rep1, rep2)) {
            return true;
        }
        if (this.mNotStrictlySmaller.containsPair(rep1, rep2)) {
            return false;
        }
        ArrayDeque<Object> worklist = new ArrayDeque<Object>();
        worklist.add(rep1);
        while (!worklist.isEmpty()) {
            Object current = worklist.pop();
            if (current == rep2 && current != rep1) {
                this.mStrictlySmaller.addPair(rep1, rep2);
                assert (this.assertStrictlySmaller(rep1, rep2));
                assert (this.assertInvariants());
                return true;
            }
            worklist.addAll(this.mStrictlySmaller.getImage(current));
        }
        this.mNotStrictlySmaller.addPair(rep1, rep2);
        return false;
    }

    public Set<E> getMaximalRepresentatives(Collection<E> elements) {
        HashSet<E> reps = new HashSet<E>();
        for (E el : elements) {
            reps.add(this.addElement(el));
        }
        HashSet result = new HashSet(reps);
        for (Object rep1 : reps) {
            for (Object rep2 : reps) {
                if (!this.isStrictlySmaller(rep1, rep2)) continue;
                result.remove(rep1);
            }
        }
        return result;
    }

    public Set<E> getMaximalRepresentatives() {
        return this.mMaximalElements;
    }

    public List<E> getTopologicalOrdering() {
        return this.topSortIntern(TopologicalSorter::topologicalOrdering);
    }

    public List<E> getReverseTopologicalOrdering() {
        return this.topSortIntern(TopologicalSorter::reversedTopologicalOrdering);
    }

    private List<E> topSortIntern(BiFunction<TopologicalSorter<E>, Collection<E>, Optional<List<E>>> sortingFunction) {
        TopologicalSorter<Object> sorter = new TopologicalSorter<Object>(this::successor);
        return sortingFunction.apply(sorter, this.mMaximalElements).orElseThrow(() -> new AssertionError((Object)"Cycle in partial order"));
    }

    private Collection<E> successor(E elem) {
        return this.mEquivalences.getAllElements().stream().filter(a -> this.isStrictlySmaller(elem, a)).collect(Collectors.toList());
    }

    private boolean assertStrictlySmaller(E elem1, E elem2) {
        IPartialComparator.ComparisonResult compres = this.mComparator.compare(elem1, elem2);
        if (compres != IPartialComparator.ComparisonResult.STRICTLY_SMALLER) {
            assert (false);
            return false;
        }
        return true;
    }

    private boolean assertInvariants() {
        for (E e : this.mMaximalElements) {
            E find;
            if (e == (find = this.mEquivalences.find(e))) continue;
            assert (false);
            return false;
        }
        for (Map.Entry entry : this.mStrictlySmaller) {
            E findKey = this.mEquivalences.find(entry.getKey());
            if (findKey != entry.getKey()) {
                assert (false);
                return false;
            }
            E findValue = this.mEquivalences.find(entry.getValue());
            if (findValue == entry.getValue()) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public boolean hasElement(E elem) {
        return this.mEquivalences.find(elem) != null;
    }

    public boolean hasBenchmark() {
        return true;
    }

    public BenchmarkWithCounters getBenchmark() {
        if (!this.hasBenchmark()) {
            throw new IllegalStateException();
        }
        return this.mBenchmark;
    }

    private void bmStart(PocBmNames watch) {
        this.mBenchmark.incrementCounter(watch.name());
        this.mBenchmark.unpauseWatch(watch.name());
    }

    private void bmEnd(PocBmNames watch) {
        this.mBenchmark.pauseWatch(watch.name());
    }

    private static enum PocBmNames {
        ORDER_REQUESTS_MADE,
        ORDER_REQUESTS_ANSWERED,
        ELEMENTS_ADDED;


        static String[] getNames() {
            String[] result = new String[PocBmNames.values().length];
            int i = 0;
            while (i < PocBmNames.values().length) {
                result[i] = PocBmNames.values()[i].name();
                ++i;
            }
            return result;
        }
    }
}

