/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.poset;

import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import java.util.Collection;
import java.util.stream.Stream;

public class PosetUtils {
    public static <T> boolean isMaximalElement(T elem, Stream<T> allElems, IPartialComparator<T> comp) {
        boolean result = allElems.allMatch(x -> comp.compare(x, elem) != IPartialComparator.ComparisonResult.STRICTLY_GREATER);
        return result;
    }

    public static <T> boolean isMinimalElement(T eleme, Stream<T> allElems, IPartialComparator<T> comp) {
        boolean result = allElems.allMatch(x -> comp.compare(x, eleme) != IPartialComparator.ComparisonResult.STRICTLY_SMALLER);
        return result;
    }

    public static <T> Stream<T> filterMaximalElements(Collection<T> allElems, IPartialComparator<T> comp) {
        return allElems.stream().filter(x -> PosetUtils.isMaximalElement(x, allElems.stream(), comp));
    }

    public static <T> Stream<T> filterMinimalElements(Collection<T> allElems, IPartialComparator<T> comp) {
        return allElems.stream().filter(x -> PosetUtils.isMinimalElement(x, allElems.stream(), comp));
    }
}

