/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.poset;

import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.ILattice;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import java.util.Collections;
import java.util.Set;

public class PowersetLattice<T>
implements ILattice<Set<T>> {
    private final Set<T> mTop;

    public PowersetLattice(Set<T> fullSet) {
        assert (fullSet != null) : "full set must not be null";
        this.mTop = fullSet;
    }

    public PowersetLattice() {
        this.mTop = null;
    }

    @Override
    public IPartialComparator.ComparisonResult compare(Set<T> o1, Set<T> o2) {
        assert (this.mTop == null || this.mTop.containsAll(o1) && this.mTop.containsAll(o2)) : "set with unexpected elements";
        if (o1.equals(o2)) {
            return IPartialComparator.ComparisonResult.EQUAL;
        }
        if (o2.containsAll(o1)) {
            return IPartialComparator.ComparisonResult.STRICTLY_SMALLER;
        }
        if (o1.containsAll(o2)) {
            return IPartialComparator.ComparisonResult.STRICTLY_GREATER;
        }
        return IPartialComparator.ComparisonResult.INCOMPARABLE;
    }

    @Override
    public Set<T> getBottom() {
        return Collections.emptySet();
    }

    @Override
    public Set<T> getTop() {
        if (this.mTop == null) {
            throw new UnsupportedOperationException("set lattice has no top element unless domain is finite");
        }
        return this.mTop;
    }

    @Override
    public Set<T> supremum(Set<T> h1, Set<T> h2) {
        assert (this.mTop == null || this.mTop.containsAll(h1) && this.mTop.containsAll(h2)) : "set with unexpected elements";
        return DataStructureUtils.union(h1, h2);
    }

    @Override
    public Set<T> infimum(Set<T> h1, Set<T> h2) {
        assert (this.mTop == null || this.mTop.containsAll(h1) && this.mTop.containsAll(h2)) : "set with unexpected elements";
        return DataStructureUtils.intersection(h1, h2);
    }
}

