/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.poset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class TopologicalSorter<V> {
    private Set<V> mUnmarkedNodes;
    private Set<V> mTemporarilyMarkedNodes;
    private List<V> mTopolicalSorting;
    private final Function<V, Collection<V>> mSuccesorsOf;

    public TopologicalSorter(Function<V, Collection<V>> funSuccesor) {
        this.mSuccesorsOf = funSuccesor;
    }

    public Optional<List<V>> topologicalOrdering(Collection<V> graphNodes) {
        Optional<List<V>> ordering = this.reversedTopologicalOrdering(graphNodes);
        ordering.ifPresent(Collections::reverse);
        return ordering;
    }

    public Optional<List<V>> reversedTopologicalOrdering(Collection<V> graphNodes) {
        try {
            return Optional.of(this.tryRevTopSort(graphNodes));
        }
        catch (GraphCycleException graphCycleException) {
            return Optional.empty();
        }
    }

    private List<V> tryRevTopSort(Collection<V> graphNodes) throws GraphCycleException {
        this.mUnmarkedNodes = new LinkedHashSet<V>(graphNodes);
        this.mTemporarilyMarkedNodes = new HashSet<V>();
        this.mTopolicalSorting = new ArrayList<V>(graphNodes.size());
        while (!this.mUnmarkedNodes.isEmpty()) {
            this.visit(this.mUnmarkedNodes.iterator().next());
        }
        return this.mTopolicalSorting;
    }

    private void visit(V node) throws GraphCycleException {
        if (this.mTemporarilyMarkedNodes.contains(node)) {
            throw new GraphCycleException();
        }
        if (this.mUnmarkedNodes.contains(node)) {
            this.markTemporarily(node);
            for (V successorNode : this.mSuccesorsOf.apply(node)) {
                this.visit(successorNode);
            }
            this.markPermanently(node);
            this.mTopolicalSorting.add(node);
        }
    }

    private void markTemporarily(V unmarkedNode) {
        this.mTemporarilyMarkedNodes.add(unmarkedNode);
    }

    private void markPermanently(V temporarilyMarkedNode) {
        this.mTemporarilyMarkedNodes.remove(temporarilyMarkedNode);
        this.mUnmarkedNodes.remove(temporarilyMarkedNode);
    }

    private static class GraphCycleException
    extends Exception {
        private static final long serialVersionUID = -7189895863479876025L;

        private GraphCycleException() {
        }
    }
}

