/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.relation;

import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.MapToCollectionIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractRelation<D, R, SET extends Set<R>, MAP extends Map<D, SET>>
implements Iterable<Map.Entry<D, R>> {
    private static final String NOT_YET_IMPLEMENTED = "not yet implemented";
    protected final MAP mMap = this.newMap();

    public AbstractRelation() {
    }

    public AbstractRelation(AbstractRelation<D, R, ?, ?> rel) {
        this();
        this.addAll(rel);
    }

    protected abstract MAP newMap();

    protected abstract SET newSet();

    public boolean addPair(D domainElem, R rangeElem) {
        Set<Object> rangeElems = (Set)this.mMap.get(domainElem);
        if (rangeElems == null) {
            rangeElems = this.newSet();
            this.mMap.put(domainElem, (Set)rangeElems);
        }
        return rangeElems.add(rangeElem);
    }

    public boolean addAllPairs(D domainElem, Collection<R> rangeElems) {
        if (rangeElems.isEmpty()) {
            return false;
        }
        Set<Object> oldRangeElems = (Set)this.mMap.get(domainElem);
        if (oldRangeElems == null) {
            oldRangeElems = this.newSet();
            this.mMap.put(domainElem, (Set)oldRangeElems);
        }
        return oldRangeElems.addAll(rangeElems);
    }

    public boolean removePair(D domainElem, R rangeElem) {
        boolean result;
        Set rangeElems = (Set)this.mMap.get(domainElem);
        if (rangeElems == null) {
            result = false;
        } else {
            result = rangeElems.remove(rangeElem);
            if (rangeElems.isEmpty()) {
                this.mMap.remove(domainElem);
            }
        }
        return result;
    }

    public void removeAllPairs(AbstractRelation<D, R, ?, ?> rel) {
        for (Map.Entry<D, R> en : rel.getSetOfPairs()) {
            this.removePair(en.getKey(), en.getValue());
        }
    }

    public Set<R> removeDomainElement(D left) {
        Set result = (Set)this.mMap.remove(left);
        assert (this.sanityCheck());
        return result;
    }

    public void removeRangeElement(R elem) {
        MAP mapCopy = this.newMap();
        mapCopy.putAll(this.mMap);
        for (Map.Entry en : mapCopy.entrySet()) {
            ((Set)en.getValue()).remove(elem);
            if (!((Set)en.getValue()).isEmpty()) continue;
            this.mMap.remove(en.getKey());
        }
        assert (this.sanityCheck());
    }

    public void replaceDomainElement(D element, D replacement) {
        assert (replacement != null);
        Set image = (Set)this.mMap.get(element);
        if (image == null) {
            return;
        }
        for (Object rangeElement : image) {
            this.addPair(replacement, rangeElement);
        }
        this.removeDomainElement(element);
        assert (this.sanityCheck());
    }

    public void replaceRangeElement(R element, R replacement) {
        for (Map.Entry en : this.mMap.entrySet()) {
            if (!((Set)en.getValue()).contains(element)) continue;
            ((Set)en.getValue()).remove(element);
            ((Set)en.getValue()).add(replacement);
        }
        assert (this.sanityCheck());
    }

    @Deprecated
    public void transformElements(Function<D, D> dTransformer, Function<R, R> rTransformer) {
        for (Map.Entry<D, R> pair : new HashRelation(this)) {
            this.removePair(pair.getKey(), pair.getValue());
            this.addPair(dTransformer.apply(pair.getKey()), rTransformer.apply(pair.getValue()));
        }
    }

    public boolean addAll(AbstractRelation<D, R, ?, ?> rel) {
        boolean changed = false;
        for (Map.Entry entry : ((Map)rel.mMap).entrySet()) {
            Set<Object> rangeElems = (Set)this.mMap.get(entry.getKey());
            if (rangeElems == null) {
                rangeElems = this.newSet();
                this.mMap.put(entry.getKey(), (Set)rangeElems);
            }
            boolean modified = rangeElems.addAll((Collection)entry.getValue());
            boolean bl = changed = changed || modified;
        }
        return changed;
    }

    public boolean containsPair(D domainElem, R rangeElem) {
        Set rangeElems = (Set)this.mMap.get(domainElem);
        if (rangeElems == null) {
            return false;
        }
        return rangeElems.contains(rangeElem);
    }

    public Set<D> getDomain() {
        return this.mMap.keySet();
    }

    public Set<R> getImage(D domainElem) {
        Set set = (Set)this.mMap.get(domainElem);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet((Set)this.mMap.get(domainElem));
    }

    public int size() {
        int result = 0;
        for (Map.Entry entry : this.mMap.entrySet()) {
            result += ((Set)entry.getValue()).size();
        }
        return result;
    }

    public int numberOfPairsWithGivenDomainElement(D domainElem) {
        if (this.getDomain().contains(domainElem)) {
            return this.getImage(domainElem).size();
        }
        return 0;
    }

    public boolean hasEmptyImage(D domainElem) {
        return this.numberOfPairsWithGivenDomainElement(domainElem) == 0;
    }

    public String toString() {
        return this.mMap.toString();
    }

    public String toStringAsTable() {
        StringBuilder sb = new StringBuilder();
        for (D domainElem : this.getDomain()) {
            for (R rangeElem : this.getImage(domainElem)) {
                sb.append(domainElem + ", " + rangeElem + System.lineSeparator());
            }
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    @Override
    public Iterator<Map.Entry<D, R>> iterator() {
        return new MapToCollectionIterator(this.mMap);
    }

    public void clear() {
        this.mMap.clear();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mMap == null ? 0 : this.mMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractRelation other = (AbstractRelation)obj;
        return !(this.mMap == null ? other.mMap != null : !this.mMap.equals(other.mMap));
    }

    private boolean sanityCheck() {
        for (Map.Entry en : this.mMap.entrySet()) {
            if (en.getKey() == null) {
                return false;
            }
            if (en.getValue() == null) {
                return false;
            }
            if (!((Set)en.getValue()).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Set<Map.Entry<D, SET>> entrySet() {
        return this.mMap.entrySet();
    }

    public Set<Map.Entry<D, R>> getSetOfPairs() {
        return new Set<Map.Entry<D, R>>(){

            @Override
            public boolean add(Map.Entry<D, R> arg0) {
                return AbstractRelation.this.addPair(arg0.getKey(), arg0.getValue());
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<D, R>> arg0) {
                throw new UnsupportedOperationException(AbstractRelation.NOT_YET_IMPLEMENTED);
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException(AbstractRelation.NOT_YET_IMPLEMENTED);
            }

            @Override
            public boolean contains(Object arg0) {
                if (arg0 instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)arg0;
                    return AbstractRelation.this.containsPair(entry.getKey(), entry.getValue());
                }
                return false;
            }

            @Override
            public boolean containsAll(Collection<?> arg0) {
                throw new UnsupportedOperationException(AbstractRelation.NOT_YET_IMPLEMENTED);
            }

            @Override
            public boolean isEmpty() {
                return AbstractRelation.this.mMap.isEmpty();
            }

            @Override
            public Iterator<Map.Entry<D, R>> iterator() {
                return new Iterator<Map.Entry<D, R>>(){
                    private Map.Entry<D, R> mNextEntry;
                    private Iterator<Map.Entry<D, SET>> mOuterIterator;
                    private Iterator<R> mInnerIterator;
                    private Map.Entry<D, SET> mNextOuter;
                    {
                        this.mOuterIterator = (this).AbstractRelation.this.mMap.entrySet().iterator();
                        this.mNextEntry = this.constructNext();
                    }

                    private Map.Entry<D, R> constructNext() {
                        if (this.mInnerIterator == null || !this.mInnerIterator.hasNext()) {
                            if (this.mOuterIterator.hasNext()) {
                                this.mNextOuter = this.mOuterIterator.next();
                                this.mInnerIterator = ((Set)this.mNextOuter.getValue()).iterator();
                            } else {
                                this.mInnerIterator = null;
                            }
                        }
                        if (this.mInnerIterator != null) {
                            if (!$assertionsDisabled && !this.mInnerIterator.hasNext()) {
                                throw new AssertionError();
                            }
                            Object next = this.mInnerIterator.next();
                            return new Map.Entry<D, R>(next){
                                private final D mKey;
                                private final R mValue;
                                {
                                    this.mKey = mNextOuter.getKey();
                                    this.mValue = object;
                                }

                                @Override
                                public D getKey() {
                                    return this.mKey;
                                }

                                @Override
                                public R getValue() {
                                    return this.mValue;
                                }

                                @Override
                                public R setValue(R arg0) {
                                    throw new UnsupportedOperationException(AbstractRelation.NOT_YET_IMPLEMENTED);
                                }
                            };
                        }
                        return null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mNextEntry != null;
                    }

                    @Override
                    public Map.Entry<D, R> next() {
                        Map.Entry result = this.mNextEntry;
                        this.mNextEntry = this.constructNext();
                        return result;
                    }
                };
            }

            @Override
            public boolean remove(Object arg0) {
                if (arg0 instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)arg0;
                    return AbstractRelation.this.removePair(entry.getKey(), entry.getValue());
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> arg0) {
                throw new UnsupportedOperationException(AbstractRelation.NOT_YET_IMPLEMENTED);
            }

            @Override
            public boolean retainAll(Collection<?> arg0) {
                throw new UnsupportedOperationException(AbstractRelation.NOT_YET_IMPLEMENTED);
            }

            @Override
            public int size() {
                return AbstractRelation.this.size();
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException(AbstractRelation.NOT_YET_IMPLEMENTED);
            }

            @Override
            public <T> T[] toArray(T[] a) {
                throw new UnsupportedOperationException(AbstractRelation.NOT_YET_IMPLEMENTED);
            }
        };
    }

    public Set<R> projectToRange() {
        return this.getSetOfPairs().stream().map(x -> x.getValue()).collect(Collectors.toSet());
    }

    public Set<R> projectToRange(Set<D> input) {
        return input.stream().flatMap(x -> this.getImage(x).stream()).collect(Collectors.toSet());
    }

    public boolean reverseAddAll(Map<R, D> map) {
        boolean someNewValueAdded = false;
        for (Map.Entry<R, D> entry : map.entrySet()) {
            someNewValueAdded |= this.addPair(entry.getValue(), entry.getKey());
        }
        return someNewValueAdded;
    }
}

