/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.relation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class DisjointSets<T> {
    private final Map<T, T> mRepresentative = new HashMap<T, T>();
    private final Map<T, Set<T>> mSubsets = new HashMap<T, Set<T>>();

    public DisjointSets(Set<T> elements) {
        for (T x : elements) {
            this.mRepresentative.put(x, x);
            HashSet<T> sub = new HashSet<T>();
            sub.add(x);
            this.mSubsets.put(x, sub);
        }
    }

    public String toString() {
        StringBuilder res = new StringBuilder("Rep:");
        for (Map.Entry<T, T> entry : this.mRepresentative.entrySet()) {
            res.append(" " + entry.getKey() + "in" + entry.getValue());
        }
        res.append("\nPart:");
        for (Map.Entry<T, Object> entry : this.mSubsets.entrySet()) {
            res.append(" " + entry.getKey() + " in " + this.getPartition(entry.getKey()));
        }
        return res.toString();
    }

    public int size() {
        int siz = 0;
        for (Set<T> subset : this.mSubsets.values()) {
            if (subset.isEmpty()) continue;
            ++siz;
        }
        return siz;
    }

    private T changeRepresentative(T x, T rNew) {
        T rOld = this.mRepresentative.get(x);
        if (rOld == rNew) {
            return rNew;
        }
        this.mRepresentative.put(x, rNew);
        if (this.mSubsets.containsKey(rOld)) {
            this.mSubsets.get(rOld).remove(x);
        }
        this.mSubsets.get(rNew).add(x);
        return rNew;
    }

    public void union(T x, T y) {
        this.changeRepresentative(this.find(y), this.find(x));
    }

    public T find(T x) {
        T res = this.mRepresentative.get(x);
        if (res == x) {
            return res;
        }
        return this.changeRepresentative(x, this.find(res));
    }

    public boolean equiv(T x, T y) {
        return this.find(x) == this.find(y);
    }

    public Set<T> getPartition(T x) {
        return this.mSubsets.get(this.find(x));
    }

    private void findAll(T x) {
        for (T y : this.mSubsets.get(x)) {
            if (y == x) continue;
            this.findAll(y);
        }
        this.find(x);
    }

    public boolean equals(Object set) {
        if (!(set instanceof DisjointSets)) {
            return false;
        }
        DisjointSets other = (DisjointSets)set;
        if (!other.mRepresentative.keySet().equals(this.mRepresentative.keySet())) {
            return false;
        }
        for (T x : other.mRepresentative.keySet()) {
            if (other.mSubsets.get(other.mRepresentative.get(x)).equals(this.mSubsets.get(this.mRepresentative.get(x)))) continue;
            return false;
        }
        return true;
    }

    public Iterator<Set<T>> getParitionsIterator() {
        final Iterator<T> it = this.mSubsets.keySet().iterator();
        return new Iterator<Set<T>>(){
            T mCur = null;

            public boolean keepMoving() {
                if (!it.hasNext()) {
                    this.mCur = null;
                    return false;
                }
                do {
                    this.mCur = it.next();
                    DisjointSets.this.findAll(this.mCur);
                } while (it.hasNext() && DisjointSets.this.mSubsets.get(this.mCur).isEmpty());
                if (DisjointSets.this.mSubsets.get(this.mCur).isEmpty()) {
                    this.mCur = null;
                    return false;
                }
                return true;
            }

            @Override
            public boolean hasNext() {
                if (this.mCur == null) {
                    return this.keepMoving();
                }
                return true;
            }

            @Override
            public Set<T> next() {
                if (this.hasNext()) {
                    Set res = DisjointSets.this.mSubsets.get(this.mCur);
                    this.keepMoving();
                    return res;
                }
                throw new NoSuchElementException("No more elments to iterate.");
            }
        };
    }
}

