/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.relation;

import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.IsContained;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Quad;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HashRelation3<K1, K2, K3>
implements Iterable<Triple<K1, K2, K3>> {
    private final NestedMap3<K1, K2, K3, IsContained> mBackingMap = new NestedMap3();

    public boolean addTriple(K1 fst, K2 snd, K3 trd) {
        IsContained isContained = this.mBackingMap.put(fst, snd, trd, IsContained.IsContained);
        return isContained == IsContained.IsContained;
    }

    public void addAllTriples(K1 fst, K2 snd, Collection<K3> trds) {
        for (K3 trd : trds) {
            this.addTriple(fst, snd, trd);
        }
    }

    public boolean containsTriple(K1 fst, K2 snd, K3 trd) {
        IsContained isContained = this.mBackingMap.get(fst, snd, trd);
        return isContained == IsContained.IsContained;
    }

    public Set<K1> projectToFst() {
        return this.mBackingMap.keySet();
    }

    public Set<K2> projectToSnd(K1 k1) {
        NestedMap2<K2, K3, IsContained> snd2trd2ic = this.mBackingMap.get(k1);
        if (snd2trd2ic == null) {
            return Collections.emptySet();
        }
        return snd2trd2ic.keySet();
    }

    public Set<K3> projectToTrd(K1 k1, K2 k2) {
        Map<K3, IsContained> trd2ic = this.mBackingMap.get(k1, k2);
        if (trd2ic == null) {
            return Collections.emptySet();
        }
        return trd2ic.keySet();
    }

    @Override
    public Iterator<Triple<K1, K2, K3>> iterator() {
        return new Iterator<Triple<K1, K2, K3>>(){
            Iterator<Quad<K1, K2, K3, IsContained>> mBackingMapIterator;
            private Triple<K1, K2, K3> mNext;
            {
                this.mBackingMapIterator = HashRelation3.this.mBackingMap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.mNext != null) {
                    return true;
                }
                this.findNext();
                return this.mNext != null;
            }

            private void findNext() {
                if (this.mNext != null) {
                    return;
                }
                Quad next = null;
                while (this.mBackingMapIterator.hasNext()) {
                    Quad current = this.mBackingMapIterator.next();
                    if (current.getFourth() == null) continue;
                    next = current;
                    break;
                }
                if (next != null) {
                    if (!$assertionsDisabled && next.getFourth() == null) {
                        throw new AssertionError();
                    }
                    this.mNext = new Triple(next.getFirst(), next.getSecond(), next.getThird());
                } else {
                    this.mNext = null;
                }
            }

            @Override
            public Triple<K1, K2, K3> next() {
                this.findNext();
                if (this.mNext == null) {
                    throw new UnsupportedOperationException("check hasNext first");
                }
                Triple next = this.mNext;
                this.mNext = null;
                return next;
            }
        };
    }

    public Iterator<Triple<K1, K2, K3>> iterator(K1 k1) {
        return new Iterator<Triple<K1, K2, K3>>(k1){
            Iterator<Quad<K1, K2, K3, IsContained>> mBackingMapIterator;
            {
                this.mBackingMapIterator = HashRelation3.this.mBackingMap.entries(object).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mBackingMapIterator.hasNext();
            }

            @Override
            public Triple<K1, K2, K3> next() {
                Quad next = this.mBackingMapIterator.next();
                return new Triple(next.getFirst(), next.getSecond(), next.getThird());
            }
        };
    }

    public String toStringAsTable() {
        Iterator<Triple<K1, K2, K3>> it = this.iterator();
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            Triple<K1, K2, K3> next = it.next();
            sb.append(next.getFirst() + ", " + next.getSecond() + ", " + next.getThird() + System.lineSeparator());
        }
        return sb.toString();
    }
}

