/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.relation;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class MapToCollectionIterator<D, R, C extends Collection<R>>
implements Iterator<Map.Entry<D, R>> {
    private final Iterator<Map.Entry<D, C>> mOuterIterator;
    private D mLhs;
    private Iterator<R> mRhsIterator;

    public MapToCollectionIterator(Map<D, C> map) {
        this.mOuterIterator = map.entrySet().iterator();
        this.nextLhs();
    }

    @Override
    public boolean hasNext() {
        while (!this.mRhsIterator.hasNext()) {
            if (this.nextLhs()) continue;
            return false;
        }
        return this.mRhsIterator.hasNext();
    }

    @Override
    public Map.Entry<D, R> next() {
        return new MapOfSetEntry(this.mLhs, this.mRhsIterator.next());
    }

    private boolean nextLhs() {
        if (this.mOuterIterator.hasNext()) {
            Map.Entry<D, C> entry = this.mOuterIterator.next();
            this.mLhs = entry.getKey();
            this.mRhsIterator = ((Collection)entry.getValue()).iterator();
            return true;
        }
        this.mRhsIterator = Collections.emptyIterator();
        return false;
    }

    private class MapOfSetEntry
    implements Map.Entry<D, R> {
        private final D mLhsInner;
        private final R mRhsInner;

        public MapOfSetEntry(D lhs, R rhs) {
            this.mLhsInner = lhs;
            this.mRhsInner = rhs;
        }

        @Override
        public D getKey() {
            return this.mLhsInner;
        }

        @Override
        public R getValue() {
            return this.mRhsInner;
        }

        @Override
        public R setValue(R value) {
            throw new UnsupportedOperationException("setValue() is not allowed.");
        }

        public String toString() {
            return this.mLhsInner + "=" + this.mRhsInner;
        }

        @Override
        public final int hashCode() {
            return this.mLhsInner.hashCode() ^ Objects.hashCode(this.mRhsInner);
        }

        @Override
        public final boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)other;
            return Objects.equals(this.mLhsInner, entry.getKey()) && Objects.equals(this.mRhsInner, entry.getValue());
        }
    }
}

