/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.relation;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class NestedIterator<IE, OE, RE>
implements Iterator<RE> {
    private final Iterator<IE> mInnerIterator;
    private IE mCurrentInnerElement;
    private Iterator<OE> mOuterIterator;
    private final Function<IE, Iterator<OE>> mNextOuterIteratorProvider;
    private final Function<IE, Function<OE, RE>> mResultProvider;

    public NestedIterator(Iterator<IE> innerIterator, Function<IE, Iterator<OE>> nextOuterIteratorProvider, Function<IE, Function<OE, RE>> resultProvider) {
        this.mInnerIterator = innerIterator;
        this.mNextOuterIteratorProvider = nextOuterIteratorProvider;
        this.mResultProvider = resultProvider;
        this.nextLetter();
    }

    private void nextLetter() {
        if (this.mInnerIterator.hasNext()) {
            do {
                this.mCurrentInnerElement = this.mInnerIterator.next();
                this.mOuterIterator = this.mNextOuterIteratorProvider.apply(this.mCurrentInnerElement);
            } while (!this.mOuterIterator.hasNext() && this.mInnerIterator.hasNext());
            if (!this.mOuterIterator.hasNext()) {
                this.mCurrentInnerElement = null;
                this.mOuterIterator = null;
            }
        } else {
            this.mCurrentInnerElement = null;
            this.mOuterIterator = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.mCurrentInnerElement != null;
    }

    @Override
    public RE next() {
        if (this.mCurrentInnerElement == null) {
            throw new NoSuchElementException();
        }
        OE nextOuterElement = this.mOuterIterator.next();
        RE result = this.mResultProvider.apply(this.mCurrentInnerElement).apply(nextOuterElement);
        if (!this.mOuterIterator.hasNext()) {
            this.nextLetter();
        }
        return result;
    }
}

