/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.relation;

import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedIterator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TransformIterator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class NestedMap2<K1, K2, V> {
    private final Map<K1, Map<K2, V>> mK1ToK2ToV = new HashMap<K1, Map<K2, V>>();

    public NestedMap2() {
    }

    public Stream<V> values() {
        return this.mK1ToK2ToV.values().stream().map(Map::values).flatMap(Collection::stream);
    }

    public NestedMap2(NestedMap2<K1, K2, V> original) {
        for (K1 k1 : original.keySet()) {
            this.mK1ToK2ToV.put(k1, new HashMap<K2, V>(original.get(k1)));
        }
    }

    public V put(K1 key1, K2 key2, V value) {
        Map<K2, V> k2toV = this.mK1ToK2ToV.get(key1);
        if (k2toV == null) {
            k2toV = new HashMap<K2, V>();
            this.mK1ToK2ToV.put(key1, k2toV);
        }
        return k2toV.put(key2, value);
    }

    public V get(K1 key1, K2 key2) {
        Map<K2, V> k2toV = this.mK1ToK2ToV.get(key1);
        if (k2toV == null) {
            return null;
        }
        return k2toV.get(key2);
    }

    public Map<K2, V> get(K1 key1) {
        return this.mK1ToK2ToV.get(key1);
    }

    public boolean containsKey(Object arg0) {
        return this.mK1ToK2ToV.containsKey(arg0);
    }

    public boolean containsKey(K1 k1, K2 k2) {
        Map<K2, V> k2toV = this.mK1ToK2ToV.get(k1);
        if (k2toV == null) {
            return false;
        }
        return k2toV.containsKey(k2);
    }

    public Set<K1> keySet() {
        return this.mK1ToK2ToV.keySet();
    }

    public Iterable<Pair<K1, K2>> keys2() {
        return () -> new Iterator<Pair<K1, K2>>(){
            private Iterator<Map.Entry<K1, Map<K2, V>>> mIterator1;
            private Map.Entry<K1, Map<K2, V>> mIterator1Object;
            private Iterator<K2> mIterator2;
            {
                this.mIterator1 = NestedMap2.this.mK1ToK2ToV.entrySet().iterator();
                if (this.mIterator1.hasNext()) {
                    this.mIterator1Object = this.mIterator1.next();
                    this.mIterator2 = this.mIterator1Object.getValue().keySet().iterator();
                }
            }

            @Override
            public boolean hasNext() {
                if (this.mIterator1Object == null) {
                    return false;
                }
                return this.mIterator2.hasNext();
            }

            @Override
            public Pair<K1, K2> next() {
                if (this.mIterator1Object == null) {
                    throw new NoSuchElementException();
                }
                if (!this.mIterator2.hasNext()) {
                    if (!this.mIterator1.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.mIterator1Object = this.mIterator1.next();
                    if (!$assertionsDisabled && this.mIterator1Object.getValue().size() <= 0) {
                        throw new AssertionError((Object)"must contain at least one value");
                    }
                    this.mIterator2 = this.mIterator1Object.getValue().keySet().iterator();
                }
                return new Pair(this.mIterator1Object.getKey(), this.mIterator2.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("not yet implemented");
            }
        };
    }

    public Iterable<Triple<K1, K2, V>> entrySet() {
        Iterator innerIterator = this.mK1ToK2ToV.entrySet().iterator();
        Function<Map.Entry, Iterator> nextOuterIteratorProvider = x -> ((Map)x.getValue()).entrySet().iterator();
        Function<Map.Entry, Function> resultProvider = x -> y -> new Triple(x.getKey(), y.getKey(), y.getValue());
        return () -> new NestedIterator(innerIterator, nextOuterIteratorProvider, resultProvider);
    }

    public Iterable<Triple<K1, K2, V>> entries(K1 k1) {
        Map k2ToV = this.mK1ToK2ToV.get(k1);
        if (k2ToV == null) {
            return Collections.emptySet();
        }
        Function<Map.Entry, Triple> transformer = x -> new Triple(k1, x.getKey(), x.getValue());
        return () -> new TransformIterator(k2ToV.entrySet().iterator(), transformer);
    }

    public void addAll(NestedMap2<K1, K2, V> nestedMap) {
        for (Triple<K1, K2, V> triple : nestedMap.entrySet()) {
            this.put(triple.getFirst(), triple.getSecond(), triple.getThird());
        }
    }

    public Map<K2, V> remove(K1 k1) {
        return this.mK1ToK2ToV.remove(k1);
    }

    public V remove(K1 k1, K2 k2) {
        Map<K2, V> k2ToV = this.mK1ToK2ToV.get(k1);
        if (k2ToV == null) {
            return null;
        }
        return k2ToV.remove(k2);
    }

    public void removeK2(K2 k2) {
        for (K1 k1 : this.mK1ToK2ToV.keySet()) {
            this.mK1ToK2ToV.get(k1).remove(k2);
        }
    }

    public void replaceK2(K2 k2orig, K2 k2new, boolean allowThatNewK2isAlreadyPresent) {
        if (allowThatNewK2isAlreadyPresent) {
            throw new UnsupportedOperationException("implement this?");
        }
        for (K1 k1 : this.mK1ToK2ToV.keySet()) {
            Map<K2, V> innerMap = this.mK1ToK2ToV.get(k1);
            V k2Contents = innerMap.get(k2orig);
            if (k2Contents == null) continue;
            if (innerMap.containsKey(k2new)) {
                throw new IllegalStateException();
            }
            innerMap.put(k2new, k2Contents);
            innerMap.remove(k2orig);
        }
    }

    public String toString() {
        return this.mK1ToK2ToV.toString();
    }

    public void clear() {
        this.mK1ToK2ToV.clear();
    }

    public int size() {
        int result = 0;
        for (Map.Entry<K1, Map<K2, V>> entry : this.mK1ToK2ToV.entrySet()) {
            result += entry.getValue().size();
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mK1ToK2ToV == null ? 0 : this.mK1ToK2ToV.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NestedMap2 other = (NestedMap2)obj;
        return !(this.mK1ToK2ToV == null ? other.mK1ToK2ToV != null : !this.mK1ToK2ToV.equals(other.mK1ToK2ToV));
    }

    public boolean isEmpty() {
        return this.mK1ToK2ToV.isEmpty();
    }
}

