/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.relation;

import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedIterator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Quad;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TransformIterator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class NestedMap3<K1, K2, K3, V> {
    private final Map<K1, NestedMap2<K2, K3, V>> mK1ToK2ToK3ToV = new HashMap<K1, NestedMap2<K2, K3, V>>();

    public NestedMap3() {
    }

    public Stream<V> values() {
        return this.mK1ToK2ToK3ToV.values().stream().flatMap(NestedMap2::values);
    }

    public NestedMap3(NestedMap3<K1, K2, K3, V> original) {
        for (K1 k1 : original.keySet()) {
            this.mK1ToK2ToK3ToV.put(k1, new NestedMap2<K2, K3, V>(original.get(k1)));
        }
    }

    public V put(K1 key1, K2 key2, K3 key3, V value) {
        NestedMap2<Object, Object, V> k2tok3toV = this.mK1ToK2ToK3ToV.get(key1);
        if (k2tok3toV == null) {
            k2tok3toV = new NestedMap2();
            this.mK1ToK2ToK3ToV.put(key1, k2tok3toV);
        }
        return k2tok3toV.put(key2, key3, value);
    }

    public V get(K1 key1, K2 key2, K3 key3) {
        NestedMap2<K3, K3, V> k2tok3toV = this.mK1ToK2ToK3ToV.get(key1);
        if (k2tok3toV == null) {
            return null;
        }
        return k2tok3toV.get(key2, key3);
    }

    public Map<K3, V> get(K1 key1, K2 key2) {
        NestedMap2<K2, K3, V> k2toV = this.mK1ToK2ToK3ToV.get(key1);
        if (k2toV == null) {
            return null;
        }
        return k2toV.get(key2);
    }

    public NestedMap2<K2, K3, V> get(K1 key1) {
        return this.mK1ToK2ToK3ToV.get(key1);
    }

    public Set<K1> keySet() {
        return this.mK1ToK2ToK3ToV.keySet();
    }

    public void clear() {
        this.mK1ToK2ToK3ToV.clear();
    }

    public Iterable<Triple<K1, K2, K3>> keys3() {
        Iterator innerIterator = this.mK1ToK2ToK3ToV.entrySet().iterator();
        Function<Map.Entry, Iterator> nextOuterIteratorProvider = x -> ((NestedMap2)x.getValue()).keys2().iterator();
        Function<Map.Entry, Function> resultProvider = x -> y -> new Triple(x.getKey(), y.getFirst(), y.getSecond());
        return () -> new NestedIterator(innerIterator, nextOuterIteratorProvider, resultProvider);
    }

    public Iterable<Quad<K1, K2, K3, V>> entrySet() {
        Iterator innerIterator = this.mK1ToK2ToK3ToV.entrySet().iterator();
        Function<Map.Entry, Iterator> nextOuterIteratorProvider = x -> ((NestedMap2)x.getValue()).entrySet().iterator();
        Function<Map.Entry, Function> resultProvider = x -> y -> new Quad(x.getKey(), y.getFirst(), y.getSecond(), y.getThird());
        return () -> new NestedIterator(innerIterator, nextOuterIteratorProvider, resultProvider);
    }

    public Iterable<Quad<K1, K2, K3, V>> entries(K1 k1) {
        NestedMap2 k2Tok3ToV = this.get(k1);
        if (k2Tok3ToV == null) {
            return Collections.emptySet();
        }
        Function<Triple, Quad> transformer = x -> new Quad(k1, x.getFirst(), x.getSecond(), x.getThird());
        return () -> new TransformIterator(k2Tok3ToV.entrySet().iterator(), transformer);
    }

    public Iterable<Quad<K1, K2, K3, V>> entries(K1 k1, K2 k2) {
        Map k3ToV = this.get(k1, k2);
        if (k3ToV == null) {
            return Collections.emptySet();
        }
        Function<Map.Entry, Quad> transformer = x -> new Quad(k1, k2, x.getKey(), x.getValue());
        return () -> new TransformIterator(k3ToV.entrySet().iterator(), transformer);
    }

    public NestedMap2<K2, K3, V> remove(K1 k1) {
        return this.mK1ToK2ToK3ToV.remove(k1);
    }

    public Map<K3, V> remove(K1 k1, K2 k2) {
        NestedMap2<K2, K3, V> k1Tok2ToV = this.mK1ToK2ToK3ToV.get(k1);
        if (k1Tok2ToV == null) {
            return null;
        }
        return k1Tok2ToV.remove(k2);
    }

    public V remove(K1 k1, K2 k2, K3 k3) {
        NestedMap2<K3, K3, V> k1Tok2ToV = this.mK1ToK2ToK3ToV.get(k1);
        if (k1Tok2ToV == null) {
            return null;
        }
        return k1Tok2ToV.remove(k2, k3);
    }

    public int size() {
        int result = 0;
        for (Map.Entry<K1, NestedMap2<K2, K3, V>> entry : this.mK1ToK2ToK3ToV.entrySet()) {
            result += entry.getValue().size();
        }
        return result;
    }

    public Set<K2> projektTo2() {
        HashSet<K2> result = new HashSet<K2>();
        for (Map.Entry<K1, NestedMap2<K2, K3, V>> entry : this.mK1ToK2ToK3ToV.entrySet()) {
            result.addAll(entry.getValue().keySet());
        }
        return result;
    }

    public String toString() {
        return this.mK1ToK2ToK3ToV.toString();
    }
}

