/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.relation;

import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import de.uni_freiburg.informatik.ultimate.util.LazyInt;

public class Quad<E1, E2, E3, E4> {
    private final E1 mFirst;
    private final E2 mSecond;
    private final E3 mThird;
    private final E4 mFourth;
    private final LazyInt mHash;

    public Quad(E1 first, E2 second, E3 third, E4 fourth) {
        this.mFirst = first;
        this.mSecond = second;
        this.mThird = third;
        this.mFourth = fourth;
        this.mHash = new LazyInt(this::computeHash);
    }

    public E1 getFirst() {
        return this.mFirst;
    }

    public E2 getSecond() {
        return this.mSecond;
    }

    public E3 getThird() {
        return this.mThird;
    }

    public E4 getFourth() {
        return this.mFourth;
    }

    public int hashCode() {
        return this.mHash.get();
    }

    private int computeHash() {
        return HashUtils.hashJenkins(31, this.mFirst, this.mSecond, this.mThird, this.mFourth);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quad other = (Quad)obj;
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (this.mFirst == null ? other.mFirst != null : !this.mFirst.equals(other.mFirst)) {
            return false;
        }
        if (this.mFourth == null ? other.mFourth != null : !this.mFourth.equals(other.mFourth)) {
            return false;
        }
        if (this.mSecond == null ? other.mSecond != null : !this.mSecond.equals(other.mSecond)) {
            return false;
        }
        return !(this.mThird == null ? other.mThird != null : !this.mThird.equals(other.mThird));
    }

    public String toString() {
        return "[" + this.mFirst + ", " + this.mSecond + ", " + this.mThird + ", " + this.mFourth + "]";
    }
}

