/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.relation;

import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.AbstractRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SymmetricHashRelation<E>
extends HashRelation<E, E> {
    public SymmetricHashRelation() {
    }

    public SymmetricHashRelation(AbstractRelation<E, E, ?, ?> rel) {
        super(rel);
    }

    @Override
    public boolean addPair(E domainElem, E rangeElem) {
        boolean wasModified = super.addPair(domainElem, rangeElem);
        super.addPair(rangeElem, domainElem);
        return wasModified;
    }

    @Override
    public boolean removePair(E domainElem, E rangeElem) {
        boolean containedPairFirstDirection = super.removePair(domainElem, rangeElem);
        boolean containedPairSecondDirection = super.removePair(rangeElem, domainElem);
        assert (containedPairFirstDirection == containedPairSecondDirection);
        return containedPairFirstDirection;
    }

    public Set<Doubleton<E>> buildSetOfDoubletons() {
        HashSet result = new HashSet();
        for (Map.Entry entry : this.getSetOfPairs()) {
            result.add(new Doubleton(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public Set<Doubleton<E>> buildSetOfNonSymmetricDoubletons() {
        HashSet result = new HashSet();
        for (Map.Entry entry : this.getSetOfPairs()) {
            if (entry.getKey().equals(entry.getValue())) continue;
            result.add(new Doubleton(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public Set<Doubleton<E>> makeTransitive() {
        HashSet<Doubleton<Doubleton<E>>> allAddedDoubletons = new HashSet<Doubleton<Doubleton<E>>>();
        Set<Doubleton<E>> recentlyAddedDoubletons = this.buildSetOfDoubletons();
        while (!recentlyAddedDoubletons.isEmpty()) {
            HashSet<Doubleton<Doubleton<E>>> newDoubletons = new HashSet<Doubleton<Doubleton<E>>>();
            for (Doubleton<E> doubleton : recentlyAddedDoubletons) {
                for (Object third : this.getImage(doubleton.getOneElement())) {
                    if (this.containsPair(doubleton.getOtherElement(), third)) continue;
                    newDoubletons.add(new Doubleton<E>(doubleton.getOtherElement(), third));
                }
                for (Object third : this.getImage(doubleton.getOtherElement())) {
                    if (this.containsPair(doubleton.getOneElement(), third)) continue;
                    newDoubletons.add(new Doubleton<E>(doubleton.getOneElement(), third));
                }
            }
            recentlyAddedDoubletons = newDoubletons;
            for (Doubleton<E> doubleton : newDoubletons) {
                this.addPair(doubleton.getOneElement(), doubleton.getOtherElement());
            }
            allAddedDoubletons.addAll(newDoubletons);
        }
        return allAddedDoubletons;
    }
}

