/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.scc;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.CombinatoricsUtils;
import de.uni_freiburg.informatik.ultimate.util.scc.StronglyConnectedComponent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class SccComputation<NODE, COMP extends StronglyConnectedComponent<NODE>> {
    private final ILogger mLogger;
    private final IStronglyConnectedComponentFactory<NODE, COMP> mSccFactory;
    protected final ISuccessorProvider<NODE> mSuccessorProvider;
    private final int mNumberOfAllStates;
    protected int mIndex = 0;
    protected final StackHashSet<NODE> mNoScc = new StackHashSet();
    protected final Map<NODE, Integer> mIndices = new HashMap<NODE, Integer>();
    protected final Map<NODE, Integer> mLowLinks = new HashMap<NODE, Integer>();
    protected final ArrayList<COMP> mBalls = new ArrayList();
    protected final ArrayList<COMP> mSCCs = new ArrayList();
    private int mNumberOfNonBallSCCs = 0;
    private Map<COMP, Set<COMP>> mAdjacenceMatrix;

    public SccComputation(ILogger logger, ISuccessorProvider<NODE> successorProvider, IStronglyConnectedComponentFactory<NODE, COMP> sccFac, int numberOfAllNodes, Set<NODE> startNodes) {
        this.mLogger = logger;
        this.mSccFactory = sccFac;
        this.mSuccessorProvider = successorProvider;
        this.mNumberOfAllStates = numberOfAllNodes;
        for (NODE node : startNodes) {
            if (this.mIndices.containsKey(node)) continue;
            this.strongconnect(node);
        }
        assert (this.automatonPartitionedBySCCs());
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Graph consists of " + this.getBalls().size() + " InCaSumBalls and " + this.mNumberOfNonBallSCCs + " non ball SCCs. Number of states in SCCs " + this.mNumberOfAllStates + "."));
        }
    }

    public Map<NODE, COMP> getNodeToComponents() {
        HashMap componentOf = new HashMap();
        for (StronglyConnectedComponent comp : this.getSCCs()) {
            for (Object pred : comp.getNodes()) {
                componentOf.put(pred, comp);
            }
        }
        return componentOf;
    }

    public ISuccessorProvider<COMP> getComponentsSuccessorsProvider() {
        if (this.mAdjacenceMatrix == null) {
            this.mAdjacenceMatrix = this.computeAdjacenceMatrix();
        }
        return node -> this.mAdjacenceMatrix.get(node).iterator();
    }

    private Map<COMP, Set<COMP>> computeAdjacenceMatrix() {
        Map<NODE, COMP> componentOf = this.getNodeToComponents();
        HashMap adjComp = new HashMap();
        List<COMP> sccs = this.getSCCs();
        int maxNeighbours = sccs.size() - 1;
        block0: for (StronglyConnectedComponent comp : sccs) {
            assert (!adjComp.containsKey(comp));
            HashSet<StronglyConnectedComponent> successors = new HashSet<StronglyConnectedComponent>();
            adjComp.put(comp, successors);
            for (Object source : comp.getNodes()) {
                for (NODE target : CombinatoricsUtils.iterateAll(this.mSuccessorProvider.getSuccessors(source))) {
                    StronglyConnectedComponent targetComp = (StronglyConnectedComponent)componentOf.get(target);
                    if (comp.equals(targetComp)) continue;
                    successors.add(targetComp);
                }
                if (successors.size() >= maxNeighbours) continue block0;
            }
        }
        return adjComp;
    }

    public Collection<COMP> getRootComponents() {
        HashSet<COMP> res = new HashSet<COMP>();
        res.addAll(this.getSCCs());
        ISuccessorProvider<COMP> componentsSuccessors = this.getComponentsSuccessorsProvider();
        for (StronglyConnectedComponent comp : this.getSCCs()) {
            for (StronglyConnectedComponent next : CombinatoricsUtils.iterateAll(componentsSuccessors.getSuccessors(comp))) {
                res.remove(next);
            }
        }
        return res;
    }

    public Collection<COMP> getLeafComponents() {
        ISuccessorProvider<COMP> componentsSuccessors = this.getComponentsSuccessorsProvider();
        HashSet<StronglyConnectedComponent> res = new HashSet<StronglyConnectedComponent>();
        for (StronglyConnectedComponent comp : this.getSCCs()) {
            if (componentsSuccessors.getSuccessors(comp).hasNext()) continue;
            res.add(comp);
        }
        return res;
    }

    public Collection<COMP> getLeafComponents(Iterable<NODE> root) {
        ISuccessorProvider<COMP> componentsSuccessors = this.getComponentsSuccessorsProvider();
        HashSet<StronglyConnectedComponent> res = new HashSet<StronglyConnectedComponent>();
        Stack<StronglyConnectedComponent> stk = new Stack<StronglyConnectedComponent>();
        for (NODE r : root) {
            stk.add((StronglyConnectedComponent)this.getNodeToComponents().get(r));
        }
        HashSet<StronglyConnectedComponent> visited = new HashSet<StronglyConnectedComponent>();
        while (!stk.isEmpty()) {
            StronglyConnectedComponent top = (StronglyConnectedComponent)stk.pop();
            boolean hasNext = false;
            Iterator<StronglyConnectedComponent> it = componentsSuccessors.getSuccessors(top);
            while (it.hasNext()) {
                StronglyConnectedComponent nxt = it.next();
                if (!visited.contains(nxt)) {
                    visited.add(nxt);
                    stk.add(nxt);
                }
                hasNext = true;
            }
            if (hasNext) continue;
            res.add(top);
        }
        return res;
    }

    public Collection<NODE> getLeafNodes() {
        HashSet res = new HashSet();
        for (StronglyConnectedComponent comp : this.getLeafComponents()) {
            res.add(comp.getRootNode());
        }
        return res;
    }

    public Collection<NODE> getLeafNodes(NODE root) {
        HashSet<NODE> res = new HashSet<NODE>();
        res.add(root);
        return this.getLeafNodes((Iterable<NODE>)res);
    }

    public Collection<NODE> getLeafNodes(Iterable<NODE> root) {
        Collection<COMP> comps = this.getLeafComponents(root);
        HashSet res = new HashSet();
        for (StronglyConnectedComponent comp : comps) {
            res.add(comp.getRootNode());
        }
        return res;
    }

    public Collection<COMP> getBalls() {
        return Collections.unmodifiableList(this.mBalls);
    }

    public List<COMP> getSCCs() {
        return Collections.unmodifiableList(this.mSCCs);
    }

    protected void strongconnect(NODE v) {
        assert (!this.mIndices.containsKey(v));
        assert (!this.mLowLinks.containsKey(v));
        this.mIndices.put(v, this.mIndex);
        this.mLowLinks.put(v, this.mIndex);
        ++this.mIndex;
        this.mNoScc.push(v);
        Iterator<NODE> it = this.mSuccessorProvider.getSuccessors(v);
        while (it.hasNext()) {
            NODE succCont = it.next();
            this.processSuccessor(v, succCont);
        }
        if (this.mLowLinks.get(v).equals(this.mIndices.get(v))) {
            this.establishNewComponent(v);
        }
    }

    protected void establishNewComponent(NODE v) {
        NODE w;
        COMP scc = this.mSccFactory.constructNewSCComponent();
        do {
            w = this.mNoScc.pop();
            ((StronglyConnectedComponent)scc).addNode(w);
        } while (v != w);
        ((StronglyConnectedComponent)scc).setRootNode(w);
        this.mSCCs.add(scc);
        if (this.isBall((StronglyConnectedComponent<NODE>)scc)) {
            this.mBalls.add(scc);
        } else {
            ++this.mNumberOfNonBallSCCs;
        }
    }

    private void processSuccessor(NODE v, NODE w) {
        if (!this.mIndices.containsKey(w)) {
            this.strongconnect(w);
            this.updateLowlink(v, this.mLowLinks.get(w));
        } else if (this.mNoScc.contains(w)) {
            this.updateLowlink(v, this.mIndices.get(w));
        }
    }

    protected void updateLowlink(NODE node, int newValueCandidate) {
        int min = Math.min(this.mLowLinks.get(node), newValueCandidate);
        this.mLowLinks.put(node, min);
    }

    boolean isBall(StronglyConnectedComponent<NODE> scc) {
        if (scc.getNumberOfStates() == 1) {
            NODE cont = scc.getRootNode();
            Iterator<NODE> it = this.mSuccessorProvider.getSuccessors(cont);
            while (it.hasNext()) {
                NODE succCont = it.next();
                if (!cont.equals(succCont)) continue;
                return true;
            }
            return false;
        }
        assert (scc.getNumberOfStates() > 1);
        return true;
    }

    protected boolean automatonPartitionedBySCCs() {
        int statesInAllBalls = 0;
        int max = 0;
        for (StronglyConnectedComponent scc : this.mBalls) {
            statesInAllBalls += scc.getNumberOfStates();
            max = Math.max(max, scc.getNumberOfStates());
        }
        this.mLogger.debug((Object)("The biggest SCC has " + max + " vertices."));
        boolean sameNumberOfVertices = statesInAllBalls + this.mNumberOfNonBallSCCs == this.mNumberOfAllStates;
        return sameNumberOfVertices;
    }

    @FunctionalInterface
    public static interface IStronglyConnectedComponentFactory<NODE, C extends StronglyConnectedComponent<NODE>> {
        public C constructNewSCComponent();
    }

    @FunctionalInterface
    public static interface ISuccessorProvider<NODE> {
        public Iterator<NODE> getSuccessors(NODE var1);
    }

    static class StackHashSet<NODE> {
        private final Deque<NODE> mStack = new ArrayDeque<NODE>();
        private final Set<NODE> mSet = new HashSet<NODE>();

        StackHashSet() {
        }

        public NODE pop() {
            NODE node = this.mStack.pop();
            this.mSet.remove(node);
            return node;
        }

        public void push(NODE node) {
            this.mStack.push(node);
            boolean modified = this.mSet.add(node);
            if (!modified) {
                throw new IllegalArgumentException("Illegal to add element twice " + node);
            }
        }

        public boolean contains(NODE node) {
            return this.mSet.contains(node);
        }
    }
}

