/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.scc;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.scc.SccComputation;
import de.uni_freiburg.informatik.ultimate.util.scc.StronglyConnectedComponent;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;

public class SccComputationNonRecursive<NODE, COMP extends StronglyConnectedComponent<NODE>>
extends SccComputation<NODE, COMP> {
    public SccComputationNonRecursive(ILogger logger, SccComputation.ISuccessorProvider<NODE> successorProvider, SccComputation.IStronglyConnectedComponentFactory<NODE, COMP> sccFac, int numberOfAllNodes, Set<NODE> startNodes) {
        super(logger, successorProvider, sccFac, numberOfAllNodes, startNodes);
    }

    @Override
    protected void strongconnect(NODE v) {
        ArrayDeque<TodoStackElement> todoStack = new ArrayDeque<TodoStackElement>();
        todoStack.push(new TodoStackElement(v, null));
        block5: while (!todoStack.isEmpty()) {
            TodoStackElement todoStackElement = (TodoStackElement)todoStack.pop();
            switch (todoStackElement.getTask()) {
                case INDEX: {
                    if (this.mIndices.containsKey(todoStackElement.getNode())) continue block5;
                    this.doIndex(todoStackElement.getNode());
                    todoStackElement.reportTaskAccomplished();
                    todoStack.push(todoStackElement);
                    break;
                }
                case GET_SUCCESSORS: {
                    todoStackElement.reportTaskAccomplished();
                    todoStack.push(todoStackElement);
                    this.doGetSuccessors(todoStackElement.getNode(), todoStack);
                    break;
                }
                case SET_LOWLINK: {
                    this.doSetLowlink(todoStackElement.getNode(), todoStackElement.getPredecessor());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    private void doSetLowlink(NODE node, NODE predecessor) {
        if (((Integer)this.mLowLinks.get(node)).equals(this.mIndices.get(node))) {
            this.establishNewComponent(node);
        }
        if (predecessor != null) {
            this.updateLowlink(predecessor, (Integer)this.mLowLinks.get(node));
        }
    }

    private void doGetSuccessors(NODE node, Deque<TodoStackElement> todoStack) {
        Iterator<NODE> it = this.mSuccessorProvider.getSuccessors(node);
        while (it.hasNext()) {
            NODE succ = it.next();
            if (this.mIndices.containsKey(succ)) {
                if (!this.mNoScc.contains(succ)) continue;
                this.updateLowlink(node, (Integer)this.mIndices.get(succ));
                continue;
            }
            todoStack.push(new TodoStackElement(succ, node));
        }
    }

    private void doIndex(NODE node) {
        assert (!this.mIndices.containsKey(node));
        assert (!this.mLowLinks.containsKey(node));
        this.mIndices.put(node, this.mIndex);
        this.mLowLinks.put(node, this.mIndex);
        ++this.mIndex;
        this.mNoScc.push(node);
    }

    static enum NextTask {
        INDEX,
        GET_SUCCESSORS,
        SET_LOWLINK;

    }

    private class TodoStackElement {
        private final NODE mNode;
        private NextTask mTask;
        private final NODE mPredecessor;

        public TodoStackElement(NODE node, NODE predecessor) {
            this.mNode = node;
            this.mTask = NextTask.INDEX;
            this.mPredecessor = predecessor;
        }

        public void reportTaskAccomplished() {
            switch (this.mTask) {
                case INDEX: {
                    this.mTask = NextTask.GET_SUCCESSORS;
                    break;
                }
                case GET_SUCCESSORS: {
                    this.mTask = NextTask.SET_LOWLINK;
                    break;
                }
                case SET_LOWLINK: {
                    throw new IllegalStateException("SET_LOWLINK is last task");
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public NODE getNode() {
            return this.mNode;
        }

        public NextTask getTask() {
            return this.mTask;
        }

        public NODE getPredecessor() {
            return this.mPredecessor;
        }

        public String toString() {
            return "TodoStackElement [mNode=" + this.mNode + ", mTask=" + (Object)((Object)this.mTask) + ", mPredecessor=" + this.mPredecessor + "]";
        }
    }
}

