/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.scc;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class StronglyConnectedComponent<NODE> {
    protected NODE mRootNode;
    protected final Set<NODE> mNodes = new HashSet<NODE>();

    public int getNumberOfStates() {
        return this.mNodes.size();
    }

    public NODE getRootNode() {
        return this.mRootNode;
    }

    public Set<NODE> getNodes() {
        return Collections.unmodifiableSet(this.mNodes);
    }

    public void addNode(NODE node) {
        if (this.mRootNode != null) {
            throw new UnsupportedOperationException("If root node is set SCC may not be modified");
        }
        boolean notAlreadyContained = this.mNodes.add(node);
        assert (notAlreadyContained) : "nodes must not be added twice";
    }

    public void setRootNode(NODE rootNode) {
        if (this.mRootNode != null) {
            throw new UnsupportedOperationException("If root node is set SCC may not be modified");
        }
        this.mRootNode = rootNode;
    }

    public String toString() {
        return String.valueOf(this.mNodes);
    }
}

