/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.simplifier;

import de.uni_freiburg.informatik.ultimate.util.simplifier.INormalFormable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class NormalFormTransformer<E> {
    private final INormalFormable<E> mWrapper;

    public NormalFormTransformer(INormalFormable<E> wrapper) {
        this.mWrapper = wrapper;
    }

    public E toNnf(E formula) {
        if (formula == null) {
            return null;
        }
        if (this.mWrapper.isAtom(formula)) {
            return formula;
        }
        if (this.mWrapper.isLiteral(formula)) {
            if (!this.mWrapper.isNot(formula)) {
                return formula;
            }
            E inner = this.mWrapper.getOperand(formula);
            if (this.mWrapper.isTrue(inner)) {
                return this.mWrapper.makeFalse();
            }
            if (this.mWrapper.isFalse(inner)) {
                return this.mWrapper.makeTrue();
            }
            return formula;
        }
        E current = formula;
        current = this.makeNnf(current);
        current = this.simplify(current);
        return current;
    }

    public E toDnf(E formula) {
        if (formula == null) {
            return null;
        }
        if (this.mWrapper.isAtom(formula)) {
            return formula;
        }
        E current = formula;
        current = this.makeNnf(current);
        current = this.simplify(current);
        current = this.skolemize(current);
        current = this.makeDnf(current);
        current = this.simplifyDnf(current);
        return current;
    }

    public E rewriteNotEquals(E formula) {
        if (formula == null) {
            return null;
        }
        E nnfFormula = this.toNnf(formula);
        if (this.mWrapper.isAtom(nnfFormula)) {
            return this.mWrapper.rewritePredNotEquals(nnfFormula);
        }
        if (this.mWrapper.isLiteral(nnfFormula)) {
            return nnfFormula;
        }
        if (this.mWrapper.isNot(nnfFormula)) {
            E neg;
            E oper = this.mWrapper.getOperand(nnfFormula);
            if (oper == (neg = this.mWrapper.negatePred(oper))) {
                return nnfFormula;
            }
            return this.mWrapper.rewritePredNotEquals(neg);
        }
        if (this.mWrapper.isAnd(nnfFormula)) {
            ArrayDeque<E> operands = new ArrayDeque<E>();
            Iterator<E> iter = this.mWrapper.getOperands(nnfFormula);
            while (iter.hasNext()) {
                E operand = this.rewriteNotEquals(iter.next());
                iter.remove();
                operands.addFirst(operand);
            }
            return this.mWrapper.makeAnd(operands.iterator());
        }
        if (this.mWrapper.isOr(nnfFormula)) {
            ArrayDeque<E> operands = new ArrayDeque<E>();
            Iterator<E> iter = this.mWrapper.getOperands(nnfFormula);
            while (iter.hasNext()) {
                E operand = this.rewriteNotEquals(iter.next());
                iter.remove();
                operands.addFirst(operand);
            }
            return this.mWrapper.makeOr(operands.iterator());
        }
        throw new UnsupportedOperationException();
    }

    public Collection<E> toDnfDisjuncts(E formula) {
        E dnf = this.toDnf(formula);
        if (dnf == null) {
            return null;
        }
        if (!this.mWrapper.isOr(dnf)) {
            return Collections.singleton(dnf);
        }
        return this.toTermsTopLevel(dnf);
    }

    public E simplify(E formula) {
        if (this.mWrapper.isAnd(formula) || this.mWrapper.isOr(formula)) {
            return this.simplifyAndOr(formula);
        }
        return formula;
    }

    private Collection<E> toTermsTopLevel(E formula) {
        if (formula == null) {
            return null;
        }
        ArrayList<E> terms = new ArrayList<E>();
        Iterator<E> iter = this.mWrapper.getOperands(formula);
        while (iter.hasNext()) {
            terms.add(iter.next());
        }
        return terms;
    }

    private E simplifyDnf(E formula) {
        E simplFormula = this.simplify(formula);
        if (!this.mWrapper.isOr(simplFormula)) {
            return simplFormula;
        }
        LinkedHashSet<E> result = this.getSet(this.mWrapper.getOperands(simplFormula));
        Iterator<E> operands = this.mWrapper.getOperands(simplFormula);
        while (operands.hasNext()) {
            E current = operands.next();
            result.remove(current);
            boolean add = true;
            for (Object other : result) {
                if (!this.isSubformula(current, other)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            result.add(current);
        }
        return this.mWrapper.makeOr(result.iterator());
    }

    private boolean isSubformula(E root, E candidate) {
        if (this.mWrapper.isEqual(root, candidate)) {
            return true;
        }
        if (this.mWrapper.isAtom(root)) {
            return false;
        }
        if (this.mWrapper.isAtom(candidate) || this.mWrapper.isNot(candidate) && this.mWrapper.isAtom(this.mWrapper.getOperand(candidate)) ? this.isOperandSubset(root, candidate) : (this.mWrapper.isAnd(root) && this.mWrapper.isAnd(candidate) ? this.isOperandSubset(root, candidate) : this.mWrapper.isOr(root) && this.mWrapper.isOr(candidate) && this.isOperandSubset(root, candidate))) {
            return true;
        }
        Iterator<E> operands = this.mWrapper.getOperands(root);
        while (operands.hasNext()) {
            if (!this.isSubformula(operands.next(), candidate)) continue;
            return true;
        }
        return false;
    }

    private boolean isOperandSubset(E root, E candidate) {
        LinkedHashSet<E> operands = this.getSet(this.mWrapper.getOperands(root));
        Iterator<E> childOperands = this.mWrapper.getOperands(candidate);
        boolean isSub = true;
        while (childOperands.hasNext()) {
            if (operands.contains(childOperands.next())) continue;
            isSub = false;
        }
        return isSub;
    }

    private LinkedHashSet<E> getSet(Iterator<E> iter) {
        LinkedHashSet<E> set = new LinkedHashSet<E>();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return set;
    }

    private E skolemize(E current) {
        return current;
    }

    private E makeDnf(E current) {
        if (this.mWrapper.isAtom(current)) {
            return current;
        }
        if (this.mWrapper.isNot(current)) {
            if (this.mWrapper.isAtom(this.mWrapper.getOperand(current))) {
                return current;
            }
            throw new AssertionError((Object)"Input not in NNF");
        }
        if (this.mWrapper.isAnd(current)) {
            ArrayDeque<E> operands = new ArrayDeque<E>();
            Iterator<E> iter = this.mWrapper.getOperands(current);
            while (iter.hasNext()) {
                E operand = this.makeDnf(iter.next());
                iter.remove();
                operands.add(operand);
            }
            while (!operands.isEmpty()) {
                Object notOr;
                Object or;
                ArrayList<E> newOrOperands;
                Object firstOperand = operands.removeLast();
                if (operands.isEmpty()) {
                    return firstOperand;
                }
                Object secondOperand = operands.removeLast();
                if (this.mWrapper.isOr(firstOperand)) {
                    if (this.mWrapper.isOr(secondOperand)) {
                        newOrOperands = new ArrayList<E>();
                        Iterator<E> firstOrOperands = this.mWrapper.getOperands(firstOperand);
                        while (firstOrOperands.hasNext()) {
                            Iterator<E> secondOrOperands = this.mWrapper.getOperands(secondOperand);
                            E currentOr = firstOrOperands.next();
                            while (secondOrOperands.hasNext()) {
                                newOrOperands.add(this.mWrapper.makeAnd(currentOr, secondOrOperands.next()));
                                secondOrOperands.remove();
                            }
                            firstOrOperands.remove();
                        }
                        operands.addFirst(this.mWrapper.makeOr(newOrOperands.iterator()));
                        continue;
                    }
                    or = firstOperand;
                    notOr = secondOperand;
                } else if (this.mWrapper.isOr(secondOperand)) {
                    or = secondOperand;
                    notOr = firstOperand;
                } else {
                    operands.addFirst(this.mWrapper.makeAnd(firstOperand, secondOperand));
                    continue;
                }
                newOrOperands = new ArrayList();
                Iterator<E> currentOrOperands = this.mWrapper.getOperands(or);
                while (currentOrOperands.hasNext()) {
                    newOrOperands.add(this.mWrapper.makeAnd(currentOrOperands.next(), notOr));
                    currentOrOperands.remove();
                }
                operands.addFirst(this.mWrapper.makeOr(newOrOperands.iterator()));
            }
            throw new AssertionError();
        }
        if (this.mWrapper.isOr(current)) {
            ArrayList<E> inner = new ArrayList<E>();
            Iterator<E> iter = this.mWrapper.getOperands(current);
            while (iter.hasNext()) {
                inner.add(this.makeDnf(iter.next()));
            }
            return this.mWrapper.makeOr(inner.iterator());
        }
        if (this.mWrapper.isExists(current)) {
            return this.mWrapper.changeExists(current, this.makeDnf(this.mWrapper.getOperand(current)));
        }
        if (this.mWrapper.isForall(current)) {
            return this.mWrapper.changeForall(current, this.makeDnf(this.mWrapper.getOperand(current)));
        }
        throw new AssertionError();
    }

    private E makeNnf(E condition) {
        if (this.mWrapper.isAtom(condition)) {
            return condition;
        }
        if (this.mWrapper.isNot(condition)) {
            E operand = this.mWrapper.getOperand(condition);
            if (this.mWrapper.isTrue(operand)) {
                return this.mWrapper.makeFalse();
            }
            if (this.mWrapper.isFalse(operand)) {
                return this.mWrapper.makeTrue();
            }
            if (this.mWrapper.isAtom(operand)) {
                return condition;
            }
            if (this.mWrapper.isNot(operand)) {
                return this.makeNnf(this.mWrapper.getOperand(operand));
            }
            if (this.mWrapper.isOr(operand)) {
                ArrayDeque<E> inner = new ArrayDeque<E>();
                Iterator<E> iter = this.mWrapper.getOperands(operand);
                while (iter.hasNext()) {
                    inner.add(this.makeNnf(this.mWrapper.makeNot(iter.next())));
                }
                return this.mWrapper.makeAnd(inner.iterator());
            }
            if (this.mWrapper.isAnd(operand)) {
                ArrayDeque<E> inner = new ArrayDeque<E>();
                Iterator<E> iter = this.mWrapper.getOperands(operand);
                while (iter.hasNext()) {
                    inner.add(this.makeNnf(this.mWrapper.makeNot(iter.next())));
                }
                return this.mWrapper.makeOr(inner.iterator());
            }
            if (this.mWrapper.isForall(operand)) {
                return this.mWrapper.changeExists(operand, this.makeNnf(this.mWrapper.makeNot(this.mWrapper.getOperand(operand))));
            }
            if (this.mWrapper.isExists(operand)) {
                return this.mWrapper.changeForall(operand, this.makeNnf(this.mWrapper.makeNot(this.mWrapper.getOperand(operand))));
            }
            throw new AssertionError();
        }
        if (this.mWrapper.isOr(condition)) {
            ArrayDeque<E> inner = new ArrayDeque<E>();
            Iterator<E> iter = this.mWrapper.getOperands(condition);
            while (iter.hasNext()) {
                inner.add(this.makeNnf(iter.next()));
            }
            return this.mWrapper.makeOr(inner.iterator());
        }
        if (this.mWrapper.isAnd(condition)) {
            ArrayDeque<E> inner = new ArrayDeque<E>();
            Iterator<E> iter = this.mWrapper.getOperands(condition);
            while (iter.hasNext()) {
                inner.add(this.makeNnf(iter.next()));
            }
            return this.mWrapper.makeAnd(inner.iterator());
        }
        if (this.mWrapper.isForall(condition)) {
            return this.mWrapper.changeForall(condition, this.makeNnf(this.mWrapper.getOperand(condition)));
        }
        if (this.mWrapper.isExists(condition)) {
            return this.mWrapper.changeExists(condition, this.makeNnf(this.mWrapper.getOperand(condition)));
        }
        throw new AssertionError();
    }

    private E simplifyAndOr(E formula) {
        E absorbing;
        E neutral;
        E trueTerm = this.mWrapper.makeTrue();
        E falseTerm = this.mWrapper.makeFalse();
        boolean isAnd = this.mWrapper.isAnd(formula);
        if (isAnd) {
            neutral = trueTerm;
            absorbing = falseTerm;
        } else {
            neutral = falseTerm;
            absorbing = trueTerm;
        }
        LinkedHashSet<E> formulas = new LinkedHashSet<E>();
        Iterator<E> iter = this.mWrapper.getOperands(formula);
        while (iter.hasNext()) {
            E f = iter.next();
            if (this.mWrapper.isEqual(f, neutral)) continue;
            if (this.mWrapper.isEqual(f, absorbing)) {
                return f;
            }
            formulas.addAll(this.mWrapper.normalizeNesting(formula, f));
        }
        if (formulas.size() <= 1) {
            if (formulas.isEmpty()) {
                return neutral;
            }
            return formulas.iterator().next();
        }
        if (isAnd) {
            return this.mWrapper.makeAnd(formulas.iterator());
        }
        return this.mWrapper.makeOr(formulas.iterator());
    }
}

