/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.util.statistics.Aggregate;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.KeyType;
import de.uni_freiburg.informatik.ultimate.util.statistics.PrettyPrint;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public abstract class AbstractStatisticsDataProvider
implements IStatisticsDataProvider {
    private final Map<String, Supplier<Object>> mSuppliers = new LinkedHashMap<String, Supplier<Object>>();
    private final Map<String, BinaryOperator<Object>> mAggregators = new HashMap<String, BinaryOperator<Object>>();
    private final Map<String, BiFunction<String, Object, String>> mPrinters = new HashMap<String, BiFunction<String, Object, String>>();
    private final BenchmarkType mBenchmarkType = new BenchmarkType();

    protected final void declare(String key, Supplier<Object> getter, KeyType type) {
        this.declare(key, getter, type::aggregate, type::prettyPrint);
    }

    protected final void declare(String key, Supplier<Object> getter, BinaryOperator<Object> aggregator, BiFunction<String, Object, String> printer) {
        assert (!this.mSuppliers.containsKey(key));
        assert (getter != null);
        assert (aggregator != null);
        assert (printer != null);
        this.mSuppliers.put(key, getter);
        this.mAggregators.put(key, aggregator);
        this.mPrinters.put(key, printer);
    }

    protected final void forward(String key, Supplier<IStatisticsDataProvider> statistics) {
        this.declare(key, () -> AbstractStatisticsDataProvider.toStatisticsData((IStatisticsDataProvider)statistics.get()), Aggregate::statisticsDataAggregate, PrettyPrint::keyColonData);
    }

    protected final <T> void forwardAll(String key, Iterable<T> elems, Function<T, IStatisticsDataProvider> getStatistics) {
        this.declare(key, () -> StreamSupport.stream(elems.spliterator(), false).map(getStatistics).map(AbstractStatisticsDataProvider::toStatisticsData).collect(Collectors.toCollection(ArrayList::new)), Aggregate::appendList, PrettyPrint.list(PrettyPrint::keyColonData, Object::toString));
    }

    private static StatisticsData toStatisticsData(IStatisticsDataProvider statistics) {
        StatisticsData data = new StatisticsData();
        data.aggregateBenchmarkData(statistics);
        return data;
    }

    @Override
    public Object getValue(String key) {
        Supplier<Object> getter = this.mSuppliers.get(key);
        if (getter == null) {
            throw new IllegalArgumentException("Unknown key '" + key + "'");
        }
        return getter.get();
    }

    @Override
    public IStatisticsType getBenchmarkType() {
        return this.mBenchmarkType;
    }

    public String toString() {
        return this.mBenchmarkType.prettyprintBenchmarkData(this);
    }

    private class BenchmarkType
    implements IStatisticsType {
        private BenchmarkType() {
        }

        @Override
        public Collection<String> getKeys() {
            return AbstractStatisticsDataProvider.this.mSuppliers.keySet();
        }

        @Override
        public Object aggregate(String key, Object value1, Object value2) {
            BinaryOperator<Object> aggregator = AbstractStatisticsDataProvider.this.mAggregators.get(key);
            if (aggregator == null) {
                throw new IllegalArgumentException("Unknown key '" + key + "'");
            }
            return aggregator.apply(value1, value2);
        }

        @Override
        public String prettyprintBenchmarkData(IStatisticsDataProvider benchmarkData) {
            StringBuilder sb = new StringBuilder();
            String delimiter = "";
            for (String key : this.getKeys()) {
                sb.append(delimiter);
                Object value = benchmarkData.getValue(key);
                BiFunction<String, Object, String> printer = AbstractStatisticsDataProvider.this.mPrinters.get(key);
                sb.append(printer.apply(key, value));
                delimiter = ", ";
            }
            return sb.toString();
        }
    }
}

