/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.TimeMemoryTracker;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Benchmark
implements ICsvProviderProvider<Double> {
    private long mMaxMemorySizeBytes;
    private Map<String, TimeMemoryTracker> mWatches;
    private TimeMemoryTracker mGlobalWatch;

    public Benchmark() {
        this.reset();
    }

    public void register(String title) {
        if (!this.mWatches.containsKey(title)) {
            this.mWatches.put(title, new TimeMemoryTracker(title, this.mMaxMemorySizeBytes));
        }
    }

    public void unregister(String title) {
        this.mWatches.remove(title);
    }

    public void start(String title) {
        TimeMemoryTracker watch = this.mWatches.computeIfAbsent(title, a -> new TimeMemoryTracker((String)a, this.mMaxMemorySizeBytes));
        watch.reset();
        watch.start();
    }

    public void startAll() {
        this.mGlobalWatch.reset();
        this.mGlobalWatch.start();
    }

    public void stop(String title) {
        this.stopInternal(title, System.nanoTime());
    }

    public void stopAll() {
        long stopTime = System.nanoTime();
        for (String key : this.mWatches.keySet()) {
            this.stopInternal(key, stopTime);
        }
    }

    private void stopInternal(String title, long stopTime) {
        TimeMemoryTracker watch = this.mWatches.get(title);
        if (watch == null) {
            return;
        }
        if (watch.mStartTime == -1L && this.mGlobalWatch.mStartTime == -1L) {
            return;
        }
        if (watch.mStartTime == -1L) {
            watch.mStartTime = this.mGlobalWatch.mStartTime;
            watch.mStartMemorySizeBytes = this.mGlobalWatch.mStartMemorySizeBytes;
            watch.mStartMemoryFreeSizeBytes = this.mGlobalWatch.mStartMemoryFreeSizeBytes;
            watch.mStartPeakMemorySizeBytes = this.mGlobalWatch.mStartPeakMemorySizeBytes;
        }
        watch.stop(stopTime);
    }

    public void pause(String title) {
        this.stop(title);
    }

    public void unpause(String title) {
        TimeMemoryTracker watch = this.mWatches.get(title);
        if (watch == null) {
            return;
        }
        watch.start();
    }

    public void reset() {
        this.mMaxMemorySizeBytes = Runtime.getRuntime().maxMemory();
        this.mGlobalWatch = new TimeMemoryTracker("Global", this.mMaxMemorySizeBytes);
        this.mWatches = new LinkedHashMap<String, TimeMemoryTracker>();
    }

    public void printResult(ILogger logger) {
        for (TimeMemoryTracker s : this.mWatches.values()) {
            logger.info((Object)s);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        sb.append("Benchmark results are:").append(lineSeparator);
        for (TimeMemoryTracker s : this.mWatches.values()) {
            sb.append(" * ").append(s).append(lineSeparator);
        }
        sb.delete(sb.length() - lineSeparator.length(), sb.length());
        return sb.toString();
    }

    public String getReportString(String title) {
        TimeMemoryTracker watch = this.mWatches.get(title);
        if (watch == null) {
            return "";
        }
        return watch.toString();
    }

    public double getElapsedTime(String title, TimeUnit unit) {
        TimeMemoryTracker watch = this.mWatches.get(title);
        if (watch == null) {
            return -1.0;
        }
        return CoreUtil.convertTimeUnit(watch.mElapsedTimeNs, TimeUnit.NANOSECONDS, unit);
    }

    public long getStartHeapSize(String title) {
        TimeMemoryTracker watch = this.mWatches.get(title);
        if (watch == null) {
            return -1L;
        }
        return watch.mStartMemorySizeBytes;
    }

    public long getStopHeapSize(String title) {
        TimeMemoryTracker watch = this.mWatches.get(title);
        if (watch == null) {
            return -1L;
        }
        return watch.mStopMemorySizeBytes;
    }

    public long getStartMemoryFreeSize(String title) {
        TimeMemoryTracker watch = this.mWatches.get(title);
        if (watch == null) {
            return -1L;
        }
        return watch.mStartMemoryFreeSizeBytes;
    }

    public long getStopMemoryFreeSize(String title) {
        TimeMemoryTracker watch = this.mWatches.get(title);
        if (watch == null) {
            return -1L;
        }
        return watch.mStopMemoryFreeSizeBytes;
    }

    public long getPeakMemoryConsumed(String title) {
        TimeMemoryTracker watch = this.mWatches.get(title);
        if (watch == null) {
            return -1L;
        }
        return watch.mPeakMemorySizeBytes - watch.mStartPeakMemorySizeBytes;
    }

    public long getMaxHeapSize(String title) {
        return this.mMaxMemorySizeBytes;
    }

    public List<String> getTitles() {
        ArrayList<String> rtr = new ArrayList<String>();
        for (TimeMemoryTracker w : this.mWatches.values()) {
            rtr.add(w.mTitle);
        }
        return rtr;
    }

    static boolean isHeap(String memoryPoolName) {
        switch (memoryPoolName) {
            case "Perm Gen [shared-ro]": 
            case "Perm Gen [shared-rw]": 
            case "CodeHeap 'non-nmethods'": 
            case "CodeHeap 'profiled nmethods'": 
            case "Code Cache": 
            case "CodeHeap 'non-profiled nmethods'": 
            case "Perm Gen": 
            case "Metaspace": 
            case "PS Perm Gen": 
            case "Compressed Class Space": {
                return false;
            }
            case "Survivor Space": 
            case "Tenured Gen": 
            case "Eden Space": 
            case "G1 Eden Space": 
            case "G1 Old Gen": 
            case "PS Survivor Space": 
            case "PS Eden Space": 
            case "G1 Survivor Space": 
            case "PS Old Gen": {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown memory pool name \"" + memoryPoolName + "\"");
    }

    @Override
    public ICsvProvider<Double> createCsvProvider() {
        ArrayList<String> columHeaders = new ArrayList<String>();
        columHeaders.add("Runtime (ns)");
        columHeaders.add("Peak memory consumption (bytes)");
        columHeaders.add("Allocated memory start (bytes)");
        columHeaders.add("Allocated memory end (bytes)");
        columHeaders.add("Free memory start (bytes)");
        columHeaders.add("Free memory end (bytes)");
        columHeaders.add("Max. memory available (bytes)");
        SimpleCsvProvider<Double> rtr = new SimpleCsvProvider<Double>(columHeaders);
        for (TimeMemoryTracker w : this.mWatches.values()) {
            ArrayList<Double> values = new ArrayList<Double>();
            values.add(Double.valueOf(w.mElapsedTimeNs));
            values.add(Double.valueOf(w.getPeakMemoryDelta()));
            values.add(Double.valueOf(w.mStartMemorySizeBytes));
            values.add(Double.valueOf(w.mStopMemorySizeBytes));
            values.add(Double.valueOf(w.mStartMemoryFreeSizeBytes));
            values.add(Double.valueOf(w.mStopMemoryFreeSizeBytes));
            values.add(Double.valueOf(this.mMaxMemorySizeBytes));
            rtr.addRow(w.mTitle, values);
        }
        return rtr;
    }
}

