/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.Benchmark;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class BenchmarkWithCounters
implements ICsvProviderProvider<Number> {
    private final Benchmark mWatchBenchmark = new Benchmark();
    private final Map<String, Integer> mCounters = new HashMap<String, Integer>();
    protected final List<String> mColumnTitles = new ArrayList<String>();
    protected final List<Number> mResults = new ArrayList<Number>();
    protected boolean mAlreadyGeneratedColumnTitlesAndResults = false;

    public void registerWatch(String watchName) {
        this.mWatchBenchmark.register(watchName);
    }

    public void unpauseWatch(String watchName) {
        this.mWatchBenchmark.unpause(watchName);
    }

    public void pauseWatch(String watchName) {
        this.mWatchBenchmark.pause(watchName);
    }

    public void registerCounter(String counterName) {
        if (this.mCounters.containsKey(counterName)) {
            throw new IllegalArgumentException("registering the same counter twice is forbidden: " + counterName);
        }
        this.mCounters.put(counterName, 0);
    }

    public void resetCounter(String counterName) {
        if (!this.mCounters.containsKey(counterName)) {
            throw new IllegalArgumentException("register this counter before resetting it: " + counterName);
        }
        this.mCounters.put(counterName, 0);
    }

    public void incrementCounter(String counterName) {
        Integer ctr = this.mCounters.get(counterName);
        if (ctr == null) {
            throw new IllegalArgumentException("register this counter before using it: " + counterName);
        }
        this.mCounters.put(counterName, ctr + 1);
    }

    public void registerCountersAndWatches(String[] names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.registerCounter(name);
            this.registerWatch(name);
            ++n2;
        }
    }

    protected void generateColumnTitlesAndResults() {
        if (this.mAlreadyGeneratedColumnTitlesAndResults) {
            return;
        }
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        for (String string : this.mWatchBenchmark.getTitles()) {
            this.mColumnTitles.add(String.valueOf(string) + "(" + (Object)((Object)timeUnit) + ")");
            this.mResults.add(this.mWatchBenchmark.getElapsedTime(string, timeUnit));
        }
        for (Map.Entry entry : this.mCounters.entrySet()) {
            this.mColumnTitles.add("#" + (String)entry.getKey());
            this.mResults.add((Number)entry.getValue());
        }
        this.mAlreadyGeneratedColumnTitlesAndResults = true;
    }

    public String toString() {
        this.generateColumnTitlesAndResults();
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        int i = 0;
        while (i < this.mColumnTitles.size()) {
            String formatString;
            Number result = this.mResults.get(i);
            if (result instanceof Double) {
                formatString = "%-50s : %15.2f %n";
            } else if (result instanceof Integer) {
                formatString = "%-50s : %15d %n";
            } else {
                throw new AssertionError((Object)"missed benchmark result case?");
            }
            sb.append(String.format(formatString, this.mColumnTitles.get(i), result));
            ++i;
        }
        return sb.toString();
    }

    @Override
    public ICsvProvider<Number> createCsvProvider() {
        this.generateColumnTitlesAndResults();
        SimpleCsvProvider<Number> result = new SimpleCsvProvider<Number>(this.mColumnTitles);
        result.addRow(this.mResults);
        return result;
    }
}

