/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.util.InCaReCounter;
import de.uni_freiburg.informatik.ultimate.util.statistics.Aggregate;
import de.uni_freiburg.informatik.ultimate.util.statistics.Converter;
import de.uni_freiburg.informatik.ultimate.util.statistics.PrettyPrint;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;

public enum KeyType {
    COUNTER(() -> 0, Aggregate::intAdd, PrettyPrint::keyColonData, Converter::identity),
    RATIO(() -> 0.0, Aggregate::doubleAdd, PrettyPrint::keyColonData, Converter::identity),
    TIMER(() -> 0L, Aggregate::longAdd, PrettyPrint.dataAsTime(PrettyPrint::keyColonData), Converter::identity),
    MAX_TIMER(() -> 0L, Aggregate::longMax, PrettyPrint.dataAsTime(PrettyPrint::keyColonData), Converter::identity),
    TT_TIMER(() -> 0L, Aggregate::longAdd, PrettyPrint.dataAsTime(PrettyPrint::dataSpaceKey), Converter::nanos),
    TT_MAX_TIMER(() -> 0L, Aggregate::longMax, PrettyPrint.dataAsTime(PrettyPrint::dataSpaceKey), Converter::nanos),
    IN_CA_RE_COUNTER(InCaReCounter::new, Aggregate::inCaReAdd, PrettyPrint::dataSpaceKey, Converter::identity);

    private final Supplier<Object> mCreate;
    private final BinaryOperator<Object> mAggregate;
    private final BiFunction<String, Object, String> mPrettyPrinter;
    private Function<Object, Object> mConverter;

    private KeyType(Supplier<Object> create, BinaryOperator<Object> aggregate, BiFunction<String, Object, String> prettyprinter, Function<Object, Object> converter) {
        this.mCreate = create;
        this.mAggregate = aggregate;
        this.mPrettyPrinter = prettyprinter;
        this.mConverter = converter;
    }

    public Object createEmpty() {
        return this.mCreate.get();
    }

    public Object aggregate(Object lhs, Object rhs) {
        return this.mAggregate.apply(lhs, rhs);
    }

    public String prettyPrint(String keyName, Object data) {
        return this.mPrettyPrinter.apply(keyName, data);
    }

    public Object convert(Object o) {
        return this.mConverter.apply(o);
    }
}

