/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.util.ReflectionUtil;
import de.uni_freiburg.informatik.ultimate.util.statistics.AbstractStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.KeyType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class StatisticsAggregator
extends AbstractStatisticsDataProvider {
    private final Map<String, KeyType> mKeyTypes;
    private final Map<String, Object> mValues;
    private final Set<String> mKnownTypes = new HashSet<String>();

    public StatisticsAggregator() {
        this.mValues = new LinkedHashMap<String, Object>();
        this.mKeyTypes = new HashMap<String, KeyType>();
    }

    public void aggregateBenchmarkData(IStatisticsDataProvider sdp) {
        this.aggregateBenchmarkData("", sdp);
    }

    public void aggregateBenchmarkData(String keyPrefix, IStatisticsDataProvider sdp) {
        if (sdp instanceof StatisticsAggregator) {
            StatisticsAggregator other = (StatisticsAggregator)sdp;
            this.mKnownTypes.addAll(other.mKnownTypes);
            for (Map.Entry<String, KeyType> entry : other.mKeyTypes.entrySet()) {
                KeyType old = this.mKeyTypes.put(entry.getKey(), entry.getValue());
                if (old != null && old != entry.getValue()) {
                    throw new UnsupportedOperationException("Conflicting keytypes");
                }
                if (old != null) continue;
                this.declare(entry.getKey(), () -> this.mValues.get(entry.getKey()), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : other.mValues.entrySet()) {
                String key = entry.getKey();
                KeyType type = this.mKeyTypes.get(entry.getKey());
                Object val = this.mValues.computeIfAbsent(key, k -> type.createEmpty());
                this.mValues.put(key, type.aggregate(val, entry.getValue()));
            }
            return;
        }
        List<Field> statFields = ReflectionUtil.instanceFields(sdp).stream().filter(f -> f.getAnnotation(Statistics.class) != null).collect(Collectors.toList());
        String string = String.valueOf(keyPrefix) + sdp.getClass();
        if (this.mKnownTypes.add(string)) {
            this.declareTypes(keyPrefix, statFields);
        }
        for (Field f2 : statFields) {
            Statistics annot = f2.getAnnotation(Statistics.class);
            String key = this.getKey(keyPrefix, f2);
            KeyType type = annot.type();
            Object rawValue = ReflectionUtil.access(sdp, f2);
            Object newValue = type.aggregate(this.mValues.get(key), type.convert(rawValue));
            this.mValues.put(key, newValue);
        }
    }

    private void declareTypes(String keyPrefix, List<Field> statFields) {
        for (Field f : statFields) {
            KeyType type;
            Statistics annot = f.getAnnotation(Statistics.class);
            String newKey = this.getKey(keyPrefix, f);
            KeyType old = this.mKeyTypes.put(newKey, type = annot.type());
            if (old != null && old != type) {
                throw new UnsupportedOperationException("Conflicting keytypes");
            }
            this.declare(newKey, () -> this.mValues.get(newKey), type);
            this.mValues.put(newKey, type.createEmpty());
        }
    }

    private String getKey(String prefix, Field f) {
        if (prefix == null || prefix == "") {
            return ReflectionUtil.fieldPrettyName(f);
        }
        return String.valueOf(prefix) + "+" + ReflectionUtil.fieldPrettyName(f);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Statistics {
        public KeyType type();
    }
}

