/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.util.csv.CsvUtils;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class StatisticsData
implements IStatisticsDataProvider,
ICsvProviderProvider<Object> {
    private final Map<String, Object> mKey2Value = new HashMap<String, Object>();
    private IStatisticsType mBenchmarkType;

    public void aggregateBenchmarkData(IStatisticsDataProvider benchmarkDataProvider) {
        if (this.mBenchmarkType == null) {
            assert (this.mKey2Value.isEmpty()) : "may not contain data if type is not known";
            this.mBenchmarkType = benchmarkDataProvider.getBenchmarkType();
            if (this.mBenchmarkType == null) {
                return;
            }
            for (String key : this.mBenchmarkType.getKeys()) {
                Object value = benchmarkDataProvider.getValue(key);
                if (value == null) {
                    throw new AssertionError((Object)("no value for " + key + " provided"));
                }
                this.mKey2Value.put(key, value);
            }
        } else {
            if (benchmarkDataProvider.getBenchmarkType() == null) {
                return;
            }
            if (this.mBenchmarkType != benchmarkDataProvider.getBenchmarkType()) {
                throw new AssertionError((Object)String.format("incompatible benchmarks: %s vs %s", this.mBenchmarkType.getClass(), benchmarkDataProvider.getBenchmarkType().getClass()));
            }
            for (String key : this.mBenchmarkType.getKeys()) {
                Object valueThis = this.mKey2Value.get(key);
                Object valueOther = benchmarkDataProvider.getValue(key);
                Object aggregatedValue = this.mBenchmarkType.aggregate(key, valueThis, valueOther);
                this.mKey2Value.put(key, aggregatedValue);
            }
        }
    }

    @Override
    public Object getValue(String key) {
        Object data = this.mKey2Value.get(key);
        if (data == null) {
            throw new IllegalArgumentException("No value for " + key + " available");
        }
        return data;
    }

    public String toString() {
        if (this.mBenchmarkType == null) {
            return "No data available";
        }
        return this.mBenchmarkType.prettyprintBenchmarkData(this);
    }

    @Override
    public Collection<String> getKeys() {
        if (this.mBenchmarkType == null) {
            throw new AssertionError((Object)"BenchmarkData not yet initialized");
        }
        return this.mBenchmarkType.getKeys();
    }

    @Override
    public IStatisticsType getBenchmarkType() {
        return this.mBenchmarkType;
    }

    public boolean isEmpty() {
        return this.mKey2Value.isEmpty();
    }

    public Map<String, Object> getFlattenedKeyValueMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (String key : this.getKeys()) {
            Object value = this.getValue(key);
            if (value instanceof IStatisticsDataProvider) {
                String composedKey;
                if (value instanceof StatisticsData) {
                    StatisticsData statData = (StatisticsData)value;
                    if (statData.isEmpty()) continue;
                    Map<String, Object> flattenedKeyValueMap = statData.getFlattenedKeyValueMap();
                    for (Map.Entry<String, Object> entry : flattenedKeyValueMap.entrySet()) {
                        composedKey = String.valueOf(key) + "_" + entry.getKey();
                        result.put(composedKey, entry.getValue());
                    }
                    continue;
                }
                IStatisticsDataProvider sdProvider = (IStatisticsDataProvider)value;
                for (String subKey : sdProvider.getKeys()) {
                    Object subValue = sdProvider.getValue(subKey);
                    composedKey = String.valueOf(key) + "_" + subKey;
                    result.put(composedKey, subValue);
                }
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    @Override
    public ICsvProvider<Object> createCsvProvider() {
        Map<String, Object> flatKeyValueMap = this.getFlattenedKeyValueMap();
        return CsvUtils.constructCvsProviderFromMap(flatKeyValueMap);
    }
}

