/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.util.statistics.Benchmark;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class StatisticsGeneratorWithStopwatches {
    private final Map<String, Boolean> mRunningStopwatches = new HashMap<String, Boolean>(this.getStopwatches().length);
    private final Benchmark mBenchmark = new Benchmark();

    public StatisticsGeneratorWithStopwatches() {
        String[] stringArray = this.getStopwatches();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.mRunningStopwatches.put(name, false);
            this.mBenchmark.register(name);
            ++n2;
        }
    }

    public abstract String[] getStopwatches();

    public void start(Object stopwatchName) {
        this.start(stopwatchName.toString());
    }

    public void start(String stopwatchName) {
        assert (this.mRunningStopwatches.containsKey(stopwatchName)) : "no such stopwatch " + stopwatchName;
        assert (!this.mRunningStopwatches.get(stopwatchName).booleanValue()) : "already started " + stopwatchName;
        this.mRunningStopwatches.put(stopwatchName, true);
        this.mBenchmark.unpause(stopwatchName);
    }

    public void stop(Object stopwatchName) {
        this.stop(stopwatchName.toString());
    }

    public void stop(String stopwatchName) {
        assert (this.mRunningStopwatches.containsKey(stopwatchName)) : "no such stopwatch " + stopwatchName;
        assert (this.mRunningStopwatches.get(stopwatchName).booleanValue()) : "not running " + stopwatchName;
        this.mRunningStopwatches.put(stopwatchName, false);
        this.mBenchmark.pause(stopwatchName);
    }

    public void stopAllStopwatches() {
        this.mRunningStopwatches.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).forEach(this::stop);
    }

    protected long getElapsedTime(String stopwatchName) throws StopwatchStillRunningException {
        assert (this.mRunningStopwatches.containsKey(stopwatchName)) : "no such stopwatch " + stopwatchName;
        if (this.mRunningStopwatches.get(stopwatchName).booleanValue()) {
            throw new StopwatchStillRunningException();
        }
        return (long)this.mBenchmark.getElapsedTime(stopwatchName, TimeUnit.NANOSECONDS);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = this.getStopwatches();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            sb.append(name);
            sb.append(": ");
            try {
                sb.append(StatisticsGeneratorWithStopwatches.prettyprintNanoseconds(this.getElapsedTime(name)));
            }
            catch (StopwatchStillRunningException stopwatchStillRunningException) {
                sb.append("clockStillRunning!");
            }
            if (this.mRunningStopwatches.get(name).booleanValue()) {
                sb.append("stopwatch still running!!!");
            }
            sb.append(" ");
            ++n2;
        }
        return sb.toString();
    }

    public static String prettyprintNanoseconds(long time) {
        long seconds = time / 1000000000L;
        long tenthDigit = time / 100000000L % 10L;
        return String.valueOf(seconds) + "." + tenthDigit + "s";
    }

    public class StopwatchStillRunningException
    extends Exception {
        private static final long serialVersionUID = 47519007262609785L;
    }
}

