/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.InCaReCounter;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsElement;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsAggregator;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class StatisticsType<T extends Enum<T>>
implements IStatisticsType {
    public static final Function<Object, Function<Object, Object>> INTEGER_ADDITION = x -> y -> (Integer)x + (Integer)y;
    public static final Function<Object, Function<Object, Object>> LONG_ADDITION = x -> y -> (Long)x + (Long)y;
    public static final Function<Object, Function<Object, Object>> IN_CA_RE_ADDITION = x -> y -> {
        ((InCaReCounter)x).add((InCaReCounter)y);
        return x;
    };
    public static final Function<Object, Function<Object, Object>> DOUBLE_ADDITION = x -> y -> (Double)x + (Double)y;
    public static final Function<Object, Function<Object, Object>> STATISTICS_DATA_AGGREGATION = x -> y -> {
        ((StatisticsData)x).aggregateBenchmarkData((StatisticsData)y);
        return x;
    };
    public static final Function<Object, Function<Object, Object>> STATISTICS_AGGREGATOR_AGGREGATION = x -> y -> {
        ((StatisticsAggregator)x).aggregateBenchmarkData((StatisticsAggregator)y);
        return x;
    };
    public static final Function<String, Function<Object, String>> KEY_BEFORE_DATA = key -> data -> String.valueOf(key) + ": " + data;
    public static final Function<String, Function<Object, String>> DATA_BEFORE_KEY = key -> data -> String.valueOf(String.valueOf(data)) + ' ' + key;
    public static final Function<String, Function<Object, String>> NANOS_BEFORE_KEY = key -> time -> String.valueOf(StatisticsType.prettyprintNanoseconds((Long)time)) + " " + key;
    public static final Function<String, Function<Object, String>> KEY_BEFORE_NANOS = key -> time -> String.valueOf(key) + ": " + StatisticsType.prettyprintNanoseconds((Long)time);
    public static final Function<Object, Function<Object, Object>> INTEGER_MAX = x -> y -> Math.max((Integer)x, (Integer)y);
    private final Class<T> mKeyType;

    public StatisticsType(Class<T> keyType) {
        this.mKeyType = keyType;
    }

    @Override
    public Collection<String> getKeys() {
        ArrayList<String> result = new ArrayList<String>();
        Enum[] enumArray = (Enum[])this.mKeyType.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum test = enumArray[n2];
            result.add(test.toString());
            ++n2;
        }
        return result;
    }

    @Override
    public Object aggregate(String key, Object value1, Object value2) {
        T keyEnum = Enum.valueOf(this.mKeyType, key);
        return ((IStatisticsElement)keyEnum).aggregate(value1, value2);
    }

    @Override
    public String prettyprintBenchmarkData(IStatisticsDataProvider benchmarkData) {
        return StatisticsType.prettyprintBenchmarkData(this.getKeys(), this.mKeyType, benchmarkData);
    }

    public static <T extends Enum<T>> String prettyprintBenchmarkData(Collection<String> keys, Class<T> keyType, IStatisticsDataProvider benchmarkData) {
        StringBuilder sb = new StringBuilder();
        String delimiter = "";
        for (String key : keys) {
            sb.append(delimiter);
            Object value = benchmarkData.getValue(key);
            T keyE = Enum.valueOf(keyType, key);
            sb.append(((IStatisticsElement)keyE).prettyprint(value));
            delimiter = ", ";
        }
        return sb.toString();
    }

    public static String prettyprintBenchmarkData(String key, IStatisticsDataProvider benchmarkData) {
        return String.valueOf(key) + " " + benchmarkData.getValue(key);
    }

    public static String prettyprintNanoseconds(long time) {
        return CoreUtil.toTimeString(time, TimeUnit.NANOSECONDS, TimeUnit.SECONDS, 1);
    }
}

