/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.statistics.Benchmark;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class TimeMemoryTracker {
    long mStartTime;
    long mElapsedTimeNs;
    long mStartMemorySizeBytes;
    long mStopMemorySizeBytes;
    long mStartMemoryFreeSizeBytes;
    long mStopMemoryFreeSizeBytes;
    long mStartPeakMemorySizeBytes;
    long mPeakMemorySizeBytes;
    final String mTitle;
    private final long mMaxMemorySizeBytes;
    private final List<MemoryPoolMXBean> mMemoryPoolBeans;

    public TimeMemoryTracker(String title) {
        this(title, Runtime.getRuntime().maxMemory());
    }

    public TimeMemoryTracker(String title, long maxMemorySizeBytes) {
        this.mMaxMemorySizeBytes = maxMemorySizeBytes;
        this.mTitle = title;
        this.mMemoryPoolBeans = ManagementFactory.getMemoryPoolMXBeans();
        this.reset();
    }

    public void start() {
        this.mStartMemorySizeBytes = Runtime.getRuntime().totalMemory();
        this.mStartMemoryFreeSizeBytes = Runtime.getRuntime().freeMemory();
        long startMemoryUsageBytes = 0L;
        for (MemoryPoolMXBean bean : this.mMemoryPoolBeans) {
            bean.resetPeakUsage();
            if (!Benchmark.isHeap(bean.getName())) continue;
            startMemoryUsageBytes += bean.getPeakUsage().getUsed();
        }
        this.mStartPeakMemorySizeBytes = startMemoryUsageBytes;
        this.mStartTime = System.nanoTime();
    }

    public void stop(long stopTime) {
        this.mElapsedTimeNs = stopTime - this.mStartTime + this.mElapsedTimeNs;
        this.mStopMemorySizeBytes = Runtime.getRuntime().totalMemory();
        this.mStopMemoryFreeSizeBytes = Runtime.getRuntime().freeMemory();
        long stopMemoryUsage = 0L;
        for (MemoryPoolMXBean bean : this.mMemoryPoolBeans) {
            if (!Benchmark.isHeap(bean.getName())) continue;
            stopMemoryUsage += bean.getPeakUsage().getUsed();
        }
        this.mPeakMemorySizeBytes = Math.max(this.mPeakMemorySizeBytes, Math.max(stopMemoryUsage, this.mStartPeakMemorySizeBytes));
    }

    public void reset() {
        this.mStartTime = -1L;
        this.mElapsedTimeNs = 0L;
        this.mStartMemorySizeBytes = 0L;
        this.mStartMemoryFreeSizeBytes = 0L;
        this.mStopMemorySizeBytes = 0L;
        this.mStopMemoryFreeSizeBytes = 0L;
        this.mStartPeakMemorySizeBytes = 0L;
        this.mPeakMemorySizeBytes = 0L;
    }

    public String toString() {
        return this.toString(TimeUnit.MILLISECONDS, 2);
    }

    private String toString(TimeUnit timeUnit, int decimals) {
        if (this.mStartTime == -1L) {
            return String.format("%s was not measured", this.mTitle);
        }
        long memoryDelta = this.mStopMemorySizeBytes - this.mStartMemorySizeBytes;
        long freeMemoryDelta = this.mStartMemoryFreeSizeBytes - this.mStopMemoryFreeSizeBytes;
        String freeMemoryDeltaPrefix = freeMemoryDelta < 0L ? "-" : "";
        freeMemoryDelta = Math.abs(freeMemoryDelta);
        long peakMemoryDelta = this.getPeakMemoryDelta();
        String peakMemoryDeltaPrefix = peakMemoryDelta < 0L ? "-" : "";
        peakMemoryDelta = Math.abs(peakMemoryDelta);
        StringBuilder sb = new StringBuilder();
        long nanoseconds = this.mElapsedTimeNs;
        sb.append(String.format("%s took %." + decimals + "f%s.", this.mTitle, CoreUtil.convertTimeUnit(nanoseconds, TimeUnit.NANOSECONDS, timeUnit), CoreUtil.getTimeUnitSymbol(timeUnit)));
        if (memoryDelta != 0L) {
            String heapPrefix = memoryDelta < 0L ? "-" : "";
            memoryDelta = Math.abs(memoryDelta);
            sb.append(String.format(" Allocated memory was %s in the beginning and %s in the end (delta: %s%s).", CoreUtil.humanReadableByteCount(this.mStartMemorySizeBytes, true), CoreUtil.humanReadableByteCount(this.mStopMemorySizeBytes, true), heapPrefix, CoreUtil.humanReadableByteCount(memoryDelta, true)));
        } else {
            sb.append(String.format(" Allocated memory is still %s.", CoreUtil.humanReadableByteCount(this.mStartMemorySizeBytes, true)));
        }
        if (freeMemoryDelta != 0L) {
            sb.append(String.format(" Free memory was %s in the beginning and %s in the end (delta: %s%s).", CoreUtil.humanReadableByteCount(this.mStartMemoryFreeSizeBytes, true), CoreUtil.humanReadableByteCount(this.mStopMemoryFreeSizeBytes, true), freeMemoryDeltaPrefix, CoreUtil.humanReadableByteCount(freeMemoryDelta, true)));
        } else {
            sb.append(String.format(" Free memory is still %s.", CoreUtil.humanReadableByteCount(this.mStartMemoryFreeSizeBytes, true)));
        }
        if (peakMemoryDelta != 0L) {
            sb.append(String.format(" Peak memory consumption was %s%s.", peakMemoryDeltaPrefix, CoreUtil.humanReadableByteCount(peakMemoryDelta, true)));
        } else {
            sb.append(" There was no memory consumed.");
        }
        sb.append(String.format(" Max. memory is %s.", CoreUtil.humanReadableByteCount(this.mMaxMemorySizeBytes, true)));
        return sb.toString();
    }

    public long getPeakMemoryDelta() {
        return this.mPeakMemorySizeBytes - this.mStartPeakMemorySizeBytes;
    }
}

