/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class TimeTracker {
    private long mStartTime;
    private long mElapsedTimeNs;
    private long mLastDeltaNs;

    public TimeTracker() {
        this.reset();
    }

    public <T> T measure(Supplier<T> fun) {
        this.start();
        T rtr = fun.get();
        this.stop();
        return rtr;
    }

    public void start() {
        this.mStartTime = System.nanoTime();
    }

    public void stop() {
        this.mLastDeltaNs = System.nanoTime() - this.mStartTime;
        this.mElapsedTimeNs = this.mLastDeltaNs + this.mElapsedTimeNs;
    }

    public void reset() {
        this.mStartTime = -1L;
        this.mElapsedTimeNs = 0L;
        this.mLastDeltaNs = -1L;
    }

    public String toString() {
        if (this.mStartTime == -1L) {
            return "N/A";
        }
        return CoreUtil.humanReadableTime(this.mElapsedTimeNs, TimeUnit.NANOSECONDS, 2);
    }

    public long lastDelta(TimeUnit unit) {
        if (this.mLastDeltaNs == -1L) {
            throw new IllegalStateException("Clock was not started");
        }
        return unit.convert(this.mLastDeltaNs, TimeUnit.NANOSECONDS);
    }

    public long elapsedTime(TimeUnit unit) {
        return unit.convert(this.mElapsedTimeNs, TimeUnit.NANOSECONDS);
    }
}

