/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhoenicke.javacup;

import com.github.jhoenicke.javacup.Grammar;
import com.github.jhoenicke.javacup.non_terminal;
import com.github.jhoenicke.javacup.production;
import com.github.jhoenicke.javacup.symbol;
import com.github.jhoenicke.javacup.terminal;
import com.github.jhoenicke.javacup.terminal_set;

public class lr_item
implements Comparable<lr_item> {
    public final production the_production;
    public final int dot_pos;
    private lr_item _shifted;

    private lr_item(production prod, int pos) {
        assert (prod != null) : "Attempt to create an lr_item_core with a null production";
        this.the_production = prod;
        assert (pos >= 0 && pos <= this.the_production.rhs_length()) : "Attempt to create an lr_item_core with a bad dot position";
        this.dot_pos = pos;
    }

    lr_item(production prod) {
        this(prod, 0);
    }

    public final boolean dot_at_end() {
        return this.dot_pos >= this.the_production.rhs_length();
    }

    public final symbol symbol_after_dot() {
        if (this.dot_pos < this.the_production.rhs_length()) {
            return this.the_production.rhs((int)this.dot_pos).the_symbol;
        }
        return null;
    }

    public non_terminal dot_before_nt() {
        symbol sym2 = this.symbol_after_dot();
        if (sym2 instanceof non_terminal) {
            return (non_terminal)sym2;
        }
        return null;
    }

    public lr_item shift_item() {
        assert (!this.dot_at_end()) : "Attempt to shift past end of an lr_item";
        if (this._shifted == null) {
            this._shifted = new lr_item(this.the_production, this.dot_pos + 1);
        }
        return this._shifted;
    }

    @Override
    public int compareTo(lr_item item) {
        if (this.the_production != item.the_production) {
            return this.the_production.index() - item.the_production.index();
        }
        return this.dot_pos - item.dot_pos;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.the_production.lhs().name());
        result.append(" ::= ");
        int i = 0;
        while (i < this.the_production.rhs_length()) {
            if (i == this.dot_pos) {
                result.append("(*) ");
            }
            result.append(this.the_production.rhs((int)i).the_symbol.name()).append(" ");
            ++i;
        }
        if (this.dot_pos == this.the_production.rhs_length()) {
            result.append("(*) ");
        }
        return result.toString();
    }

    public terminal_set calc_lookahead(Grammar grammar) {
        terminal_set result = new terminal_set(grammar);
        int pos = this.dot_pos;
        while (pos < this.the_production.rhs_length()) {
            symbol sym2 = this.the_production.rhs((int)pos).the_symbol;
            if (!sym2.is_non_term()) {
                result.add((terminal)sym2);
                break;
            }
            non_terminal nt = (non_terminal)sym2;
            result.add(nt.first_set());
            if (!nt.nullable()) break;
            ++pos;
        }
        return result;
    }

    public boolean is_nullable() {
        int pos = this.dot_pos;
        while (pos < this.the_production.rhs_length()) {
            symbol sym2 = this.the_production.rhs((int)pos).the_symbol;
            if (!sym2.is_non_term()) {
                return false;
            }
            if (!((non_terminal)sym2).nullable()) {
                return false;
            }
            ++pos;
        }
        return true;
    }
}

