/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhoenicke.javacup;

import com.github.jhoenicke.javacup.CombRow;
import com.github.jhoenicke.javacup.Grammar;
import java.util.BitSet;
import java.util.TreeSet;

public class parse_action_table {
    public final int[][] table;
    public static final int ERROR = 0;
    public static final int SHIFT = 1;
    public static final int REDUCE = 2;

    public parse_action_table(Grammar grammar) {
        int _num_states = grammar.lalr_states().size();
        int _num_terminals = grammar.num_terminals();
        this.table = new int[_num_states][_num_terminals + 1];
    }

    public static int action(int kind, int index) {
        return 2 * index + kind;
    }

    public static boolean isReduce(int code) {
        return code != 0 && (code & 1) == 0;
    }

    public static boolean isShift(int code) {
        return (code & 1) != 0;
    }

    public static int index(int code) {
        return code - 1 >> 1;
    }

    public static String toString(int code) {
        if (code == 0) {
            return "ERROR";
        }
        if (parse_action_table.isShift(code)) {
            return "SHIFT(" + parse_action_table.index(code) + ")";
        }
        return "REDUCE(" + parse_action_table.index(code) + ")";
    }

    public short[] compress(int[] base_table) {
        int[] default_actions = new int[this.table.length];
        TreeSet<CombRow> rows = new TreeSet<CombRow>();
        int i = 0;
        while (i < this.table.length) {
            int[] row = this.table[i];
            default_actions[i] = row[row.length - 1];
            int len = 0;
            int j = 0;
            while (j < row.length - 1) {
                if (row[j] != default_actions[i]) {
                    ++len;
                }
                ++j;
            }
            if (len != 0) {
                int[] comb = new int[len];
                len = 0;
                int j2 = 0;
                while (j2 < row.length - 1) {
                    if (row[j2] != default_actions[i]) {
                        comb[len++] = j2;
                    }
                    ++j2;
                }
                rows.add(new CombRow(i, comb));
            }
            ++i;
        }
        BitSet used = new BitSet();
        int combsize = 0;
        for (CombRow row : rows) {
            row.fitInComb(used);
            int lastidx = row.base + this.table[row.index].length;
            if (lastidx <= combsize) continue;
            combsize = lastidx;
        }
        int _num_states = this.table.length;
        short[] compressed = new short[_num_states + 2 * combsize];
        int i2 = 0;
        while (i2 < _num_states) {
            base_table[i2] = (short)_num_states;
            compressed[i2] = (short)default_actions[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < combsize) {
            compressed[_num_states + 2 * i2] = (short)_num_states;
            compressed[_num_states + 2 * i2 + 1] = 1;
            ++i2;
        }
        for (CombRow row : rows) {
            int base;
            base_table[row.index] = base = this.table.length + 2 * row.base;
            int j = 0;
            while (j < row.comb.length) {
                int t = row.comb[j];
                compressed[base + 2 * t] = (short)row.index;
                compressed[base + 2 * t + 1] = (short)this.table[row.index][t];
                ++j;
            }
        }
        return compressed;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("-------- ACTION_TABLE --------\n");
        int row = 0;
        while (row < this.table.length) {
            result.append("From state #").append(row).append("\n");
            int cnt = 0;
            int default_act = this.table[row][this.table[row].length - 1];
            result.append(" [default:").append(parse_action_table.toString(default_act)).append("]\n");
            int col = 0;
            while (col < this.table[row].length) {
                if (this.table[row][col] != default_act) {
                    result.append(" [term ").append(col).append(":").append(parse_action_table.toString(this.table[row][col])).append("]");
                    if (++cnt == 2) {
                        result.append("\n");
                        cnt = 0;
                    }
                }
                ++col;
            }
            if (cnt != 0) {
                result.append("\n");
            }
            ++row;
        }
        result.append("------------------------------");
        return result.toString();
    }
}

