/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhoenicke.javacup;

import com.github.jhoenicke.javacup.CombRow;
import com.github.jhoenicke.javacup.Grammar;
import com.github.jhoenicke.javacup.lalr_state;
import java.util.BitSet;
import java.util.TreeSet;

public class parse_reduce_table {
    public lalr_state[][] table;
    protected int _num_states;
    private int _num_nonterm;

    public parse_reduce_table(Grammar grammar) {
        this._num_states = grammar.lalr_states().size();
        this._num_nonterm = grammar.num_non_terminals();
        this.table = new lalr_state[this._num_states][this._num_nonterm];
    }

    public int num_states() {
        return this._num_states;
    }

    public short[] compress() {
        BitSet used = new BitSet();
        TreeSet<CombRow> rows = new TreeSet<CombRow>();
        int i = 0;
        while (i < this._num_states) {
            int len = 0;
            int j = 0;
            while (j < this._num_nonterm) {
                if (this.table[i][j] != null) {
                    ++len;
                }
                ++j;
            }
            if (len != 0) {
                used.set(i);
                int[] rowidx = new int[len];
                len = 0;
                int j2 = 0;
                while (j2 < this._num_nonterm) {
                    if (this.table[i][j2] != null) {
                        rowidx[len++] = j2;
                    }
                    ++j2;
                }
                CombRow row = new CombRow(i, rowidx);
                rows.add(row);
            }
            ++i;
        }
        for (CombRow row : rows) {
            row.fitInComb(used);
        }
        int maxbase = used.size();
        while (!used.get(maxbase - 1)) {
            --maxbase;
        }
        short[] compressed = new short[maxbase];
        int i2 = 0;
        while (i2 < maxbase) {
            compressed[i2] = 1;
            ++i2;
        }
        for (CombRow row : rows) {
            int base = row.base;
            compressed[row.index] = (short)base;
            int j = 0;
            while (j < row.comb.length) {
                compressed[base + row.comb[j]] = (short)this.table[row.index][row.comb[j]].index();
                ++j;
            }
        }
        return compressed;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("-------- REDUCE_TABLE --------\n");
        int row = 0;
        while (row < this.num_states()) {
            result.append("From state #").append(row).append("\n");
            int cnt = 0;
            int col = 0;
            while (col < this._num_nonterm) {
                lalr_state goto_st = this.table[row][col];
                if (goto_st != null) {
                    result.append(" [non term ").append(col).append("->");
                    result.append("state ").append(goto_st.index()).append("]");
                    if (++cnt == 3) {
                        result.append("\n");
                        cnt = 0;
                    }
                }
                ++col;
            }
            if (cnt != 0) {
                result.append("\n");
            }
            ++row;
        }
        result.append("-----------------------------");
        return result.toString();
    }
}

